/*
 * Decompiled with CFR 0.152.
 */
package org.accidia.echo.mysql;

import com.google.common.base.Preconditions;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.accidia.echo.protos.Protos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlDataSource {
    private static final Logger logger = LoggerFactory.getLogger(MySqlDataSource.class);
    private static Map<Protos.DataSource, MySqlDataSource> instaces = new HashMap<Protos.DataSource, MySqlDataSource>();
    private final ComboPooledDataSource connectoinPoolDataSource;
    private final Protos.DataSource datasource;

    public static MySqlDataSource newInstance(Protos.DataSource dataSource) {
        return new MySqlDataSource(dataSource);
    }

    public static synchronized MySqlDataSource getInstance(Protos.DataSource datasource) {
        if (!instaces.containsKey(datasource)) {
            instaces.put(datasource, MySqlDataSource.newInstance(datasource));
        }
        return instaces.get(datasource);
    }

    protected MySqlDataSource(Protos.DataSource datasource) {
        String password;
        logger.debug("MySqlStorageMeta(storageMeta)");
        this.datasource = datasource;
        this.connectoinPoolDataSource = new ComboPooledDataSource();
        try {
            this.connectoinPoolDataSource.setDriverClass("com.mysql.jdbc.Driver");
        }
        catch (PropertyVetoException e) {
            throw new RuntimeException(e);
        }
        String hostname = this.getMetadataValue(this.datasource.getMetadataList(), "hostname", true);
        String port = this.getMetadataValue(this.datasource.getMetadataList(), "port", true);
        String databaseName = this.getMetadataValue(this.datasource.getMetadataList(), "database", true);
        String connectionProperties = this.getMetadataValue(this.datasource.getMetadataList(), "connection_properties", false);
        String jdbcUrl = this.getJdbcUrl(hostname, port, databaseName, connectionProperties);
        logger.info("setting jdbc url to: {}", (Object)jdbcUrl);
        this.connectoinPoolDataSource.setJdbcUrl(jdbcUrl);
        String username = this.getMetadataValue(this.datasource.getMetadataList(), "username", false);
        if (username != null) {
            logger.info("setting user to: {}", (Object)username);
            this.connectoinPoolDataSource.setUser(username);
        }
        if ((password = this.getMetadataValue(this.datasource.getMetadataList(), "password", false)) != null) {
            logger.info("setting password...");
            this.connectoinPoolDataSource.setPassword(password);
        }
        this.connectoinPoolDataSource.setTestConnectionOnCheckout(true);
    }

    public ComboPooledDataSource getConnectoinPoolDataSource() {
        logger.debug("getConnectoinPoolDataSource()");
        return this.connectoinPoolDataSource;
    }

    protected String getJdbcUrl(String hostname, String port, String databaseName, String connectionProperties) {
        String url = String.format("jdbc:mysql://%s:%s/%s?%s", hostname, port, databaseName, connectionProperties);
        logger.info("jdbc url is: {}", (Object)url);
        return url;
    }

    protected String getMetadataValue(List<Protos.DataSource.MetaData> metaData, String metadataName, boolean isRequired) {
        for (Protos.DataSource.MetaData md : metaData) {
            if (!md.getName().equalsIgnoreCase(metadataName)) continue;
            return md.getValue();
        }
        Preconditions.checkArgument(isRequired, "invalid metadata: " + metadataName);
        return null;
    }
}

