/*
 * Decompiled with CFR 0.152.
 */
package org.accidia.echo.protobuf;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Protobufs {
    private static final Logger logger = LoggerFactory.getLogger(Protobufs.class);

    public static List<String> getAllFieldNamesToUpperCase(Message message) {
        logger.debug("getAllFieldNamesToUpperCase(message)");
        List<String> fieldNames = Protobufs.getAllFieldNames(message);
        ArrayList<String> fieldNamesToUpperCase = new ArrayList<String>(fieldNames.size());
        for (String fieldName : fieldNames) {
            fieldNamesToUpperCase.add(fieldName.toUpperCase());
        }
        return fieldNamesToUpperCase;
    }

    public static List<String> getAllFieldNames(Message message) {
        logger.debug("getAllFieldNames(message)");
        Preconditions.checkArgument(message != null, "null message");
        List<Descriptors.FieldDescriptor> fields = message.getDescriptorForType().getFields();
        ArrayList<String> fieldsList = new ArrayList<String>(fields.size());
        for (Descriptors.FieldDescriptor fieldDescriptor : fields) {
            fieldsList.add(fieldDescriptor.getName());
        }
        return fieldsList;
    }

    public static List<String> getDefinedFieldNames(Message message) {
        logger.debug("getDefinedFieldNames(message)");
        Preconditions.checkArgument(message != null, "null message");
        Map<Descriptors.FieldDescriptor, Object> fieldsMap = message.getAllFields();
        if (fieldsMap == null || fieldsMap.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> fieldsList = new ArrayList<String>(fieldsMap.size());
        for (Descriptors.FieldDescriptor fieldDescriptor : fieldsMap.keySet()) {
            fieldsList.add(fieldDescriptor.getName());
        }
        return fieldsList;
    }

    public static Object getValueForFieldName(Message message, String fieldName) {
        logger.debug("getValueForFieldName(message,fieldName)");
        Preconditions.checkArgument(message != null, "null message");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(fieldName), "null/empty fieldName");
        for (Descriptors.FieldDescriptor fieldDescriptor : message.getDescriptorForType().getFields()) {
            if (!fieldDescriptor.getName().equalsIgnoreCase(fieldName)) continue;
            return message.getField(fieldDescriptor);
        }
        throw new IllegalArgumentException("invalid fieldName: " + fieldName);
    }

    public static Message getDefaultInstanceForProto(String proto, String messageTypeName) throws IOException, Descriptors.DescriptorValidationException, ReflectiveOperationException {
        logger.debug("getDefaultInstanceForProto(proto)");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(proto), "null/empty proto");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(messageTypeName), "null/empty messageTypeName");
        logger.info("creating temporary file to contain proto");
        File protoFile = File.createTempFile("proto-", ".proto");
        protoFile.deleteOnExit();
        FileUtils.writeStringToFile(protoFile, proto, Charsets.UTF_8);
        String outputDirectory = "/tmp/echo/protos/";
        String mkdirCommand = "mkdir -p /tmp/echo/protos/";
        DefaultExecutor executor = new DefaultExecutor();
        executor.setExitValue(0);
        ExecuteWatchdog watchdog = new ExecuteWatchdog(3000L);
        executor.setWatchdog(watchdog);
        logger.info("executing command: {}", (Object)"mkdir -p /tmp/echo/protos/");
        executor.execute(CommandLine.parse("mkdir -p /tmp/echo/protos/"));
        String protocCommand = "protoc --java_out=/tmp/echo/protos/  --descriptor_set_out=" + protoFile.getAbsolutePath().concat(".desc") + " --proto_path=" + protoFile.getParentFile().getAbsolutePath() + " " + protoFile.getAbsolutePath();
        CommandLine protocCommandLine = CommandLine.parse(protocCommand);
        logger.info("executing command: {}", (Object)protocCommand);
        int exitValue = executor.execute(protocCommandLine);
        if (exitValue != 0) {
            throw new RuntimeException("command returned non-zero: " + protocCommand);
        }
        DescriptorProtos.FileDescriptorSet fileDescriptorSet = DescriptorProtos.FileDescriptorSet.parseFrom(new FileInputStream(protoFile.getAbsolutePath().concat(".desc")));
        for (DescriptorProtos.FileDescriptorProto fileDescriptorProto : fileDescriptorSet.getFileList()) {
            Descriptors.FileDescriptor fileDescriptor = Descriptors.FileDescriptor.buildFrom(fileDescriptorProto, new Descriptors.FileDescriptor[0]);
            for (Descriptors.Descriptor descriptor : fileDescriptor.getMessageTypes()) {
                String javaPackageName = fileDescriptorProto.getOptions().getJavaPackage();
                String javaOuterClassName = fileDescriptorProto.getOptions().getJavaOuterClassname();
                StringBuilder classNameBuilder = new StringBuilder();
                if (!Strings.isNullOrEmpty(javaPackageName)) {
                    classNameBuilder.append(javaPackageName).append(".");
                }
                if (!Strings.isNullOrEmpty(javaOuterClassName)) {
                    classNameBuilder.append(javaOuterClassName).append("$");
                }
                classNameBuilder.append(descriptor.getName());
                String className = classNameBuilder.toString();
                logger.info("class name: {}", (Object)className);
                if (!className.equalsIgnoreCase(messageTypeName)) continue;
                logger.info("message type name found: {}", (Object)messageTypeName);
                DynamicMessage.Builder builder = DynamicMessage.newBuilder(descriptor);
                return builder.buildPartial();
            }
        }
        logger.warn("could not load message type: {} from protobuf description: {}", (Object)messageTypeName, (Object)proto);
        throw new InvalidClassException("invalid message type name: " + messageTypeName);
    }

    public static String toJson(Iterable<? extends Message> messages) {
        if (messages == null) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder("[");
        boolean first = true;
        for (Message message : messages) {
            if (first) {
                first = false;
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append(Protobufs.toJson(message));
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static String toJson(Message message) {
        return JsonFormat.printToString(message);
    }
}

