/*
 * Decompiled with CFR 0.152.
 */
package org.accidia.echo.services.impl;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import java.util.concurrent.Callable;
import org.accidia.echo.protos.Protos;
import org.accidia.echo.services.ITemplateService;
import org.accidia.echo.services.ITenantService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreemarkerTemplateService
implements ITemplateService {
    private static final Logger logger = LoggerFactory.getLogger(FreemarkerTemplateService.class);
    private final ListeningExecutorService listeningExecutorService;
    private final ITenantService tenantService;

    @Inject
    public FreemarkerTemplateService(ListeningExecutorService listeningExecutorService, ITenantService tenantService) {
        this.listeningExecutorService = listeningExecutorService;
        this.tenantService = tenantService;
    }

    @Override
    public ListenableFuture<String> register(String tenant, Protos.Template template) {
        Preconditions.checkArgument(this.tenantService.isRegistered(tenant), "invalid tenant");
        Preconditions.checkArgument(template != null, "null template");
        Preconditions.checkArgument(template.hasName() && template.hasBody() && template.hasContentType(), "invalid template");
        return this.doRegister(tenant, template);
    }

    protected ListenableFuture<String> doRegister(String tenant, Protos.Template template) {
        return this.listeningExecutorService.submit(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return null;
            }
        });
    }

    @Override
    public ListenableFuture<String> process(String tenant, String templateName) {
        logger.debug("process(tenant,templateName)");
        return null;
    }
}

