package org.accidia.echo.services.impl;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import org.accidia.echo.services.ITemplateService;
import org.accidia.echo.services.ITenantService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.Callable;

import static com.google.common.base.Preconditions.checkArgument;
import static org.accidia.echo.protos.Protos.Template;

public class FreemarkerTemplateService implements ITemplateService {
    private static final Logger logger = LoggerFactory.getLogger(FreemarkerTemplateService.class);

    private final ListeningExecutorService listeningExecutorService;
    private final ITenantService tenantService;

    @Inject
    public FreemarkerTemplateService(final ListeningExecutorService listeningExecutorService,
                                     final ITenantService tenantService) {
        this.listeningExecutorService = listeningExecutorService;
        this.tenantService = tenantService;
    }

    @Override
    public ListenableFuture<String> register(final String tenant, final Template template) {
        checkArgument(this.tenantService.isRegistered(tenant), "invalid tenant");
        checkArgument(template != null, "null template");
        checkArgument(template.hasName() && template.hasBody() && template.hasContentType(),
                "invalid template");
        return doRegister(tenant, template);
    }

    protected ListenableFuture<String> doRegister(final String tenant, final Template template) {
        return this.listeningExecutorService.submit(new Callable<String>() {
            @Override
            public String call() throws Exception {
                return null;
            }
        });
    }

    @Override
    public ListenableFuture<String> process(final String tenant, final String templateName) {
        logger.debug("process(tenant,templateName)");
        return null;
    }
}

