/*
 * Decompiled with CFR 0.152.
 */
package org.accidia.echo.mysql.relational;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.accidia.echo.dao.IProtobufDao;
import org.accidia.echo.mysql.EchoSqls;
import org.accidia.echo.mysql.MySqlDataSource;
import org.accidia.echo.mysql.relational.MySqlProtobufRowMapper;
import org.accidia.echo.protobuf.Protobufs;
import org.accidia.echo.protos.Protos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.support.JdbcDaoSupport;

public class MySqlProtobufDao
extends JdbcDaoSupport
implements IProtobufDao {
    private static final Logger logger = LoggerFactory.getLogger(MySqlProtobufDao.class);
    private final Message messageDefaultInstance;
    private final MySqlProtobufRowMapper mySqlProtobufRowMapper = new MySqlProtobufRowMapper();
    private final RowMapper<Message> rowMapper = (resultSet, rowNum) -> this.mySqlProtobufRowMapper.mapResultSet(resultSet, this.getMessageBuilder());

    public static MySqlProtobufDao newInstance(Message messageDefaultInstance, Protos.DataSource dataSource) {
        try {
            return new MySqlProtobufDao(messageDefaultInstance, dataSource);
        }
        catch (Descriptors.DescriptorValidationException | IOException | ReflectiveOperationException e) {
            logger.warn("failed to create new mysql protobuf dao instance:", e);
            throw new RuntimeException(e);
        }
    }

    protected MySqlProtobufDao(Message messageDefaultInstance, Protos.DataSource dataSource) throws Descriptors.DescriptorValidationException, ReflectiveOperationException, IOException {
        logger.debug("MySqlProtobufDao()");
        MySqlDataSource mySqlDataSource = MySqlDataSource.newInstance(dataSource);
        this.setDataSource(mySqlDataSource.getConnectoinPoolDataSource());
        this.messageDefaultInstance = messageDefaultInstance;
    }

    @Override
    public Message findByKey(String key) {
        logger.debug("findByKey(key)");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key), "null/empty key");
        return this.doFindByKey(key);
    }

    protected Message doFindByKey(String key) {
        List<String> fieldNames = Protobufs.getAllFieldNamesToUpperCase(this.getMessageDefaultInstance());
        StringBuilder sqlStringBuilder = new StringBuilder();
        sqlStringBuilder.append("SELECT ").append(Joiner.on(",").join(fieldNames)).append(" FROM ").append(this.getTableName()).append(" WHERE ").append(this.getKeyFieldName()).append(" = ?");
        List<Message> messages = this.getJdbcTemplate().query(sqlStringBuilder.toString(), this.rowMapper, key);
        if (messages == null || messages.isEmpty()) {
            return null;
        }
        return messages.get(0);
    }

    @Override
    public Message findFieldsByKey(String key, List<String> fields) {
        logger.debug("findFieldsByKey(key,fields)");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key), "null/empty key");
        return this.doFindFieldsByKey(key, fields);
    }

    protected Message doFindFieldsByKey(String key, List<String> fields) {
        String sql = EchoSqls.getSqlSelectFieldsForMessage(this.getMessageDefaultInstance(), fields) + " FROM " + this.getTableName() + " WHERE " + this.getKeyFieldName() + " = ?";
        List<Message> messages = this.getJdbcTemplate().query(sql, this.rowMapper, key);
        if (messages == null || messages.isEmpty()) {
            return null;
        }
        return messages.get(0);
    }

    @Override
    public List<String> findList(String listKey, int start, int count) {
        logger.debug("findList(start,count,orderby)");
        Preconditions.checkArgument(start >= 0, "invalid start");
        Preconditions.checkArgument(count >= -1, "invalid count");
        return this.doFindList(listKey, start, count);
    }

    @Override
    public List<String> findAllList(String listKey) {
        return null;
    }

    @Override
    public List<Message> findListObjects(String listKey, int start, int count) {
        return null;
    }

    @Override
    public List<Message> findAllListObjects(String listKey) {
        return null;
    }

    @Override
    public List<Message> findOrderedListObjectsAscending(String listKey, int start, int count) {
        return null;
    }

    @Override
    public List<Message> findAllOrderedListObjectsAscending(String listKey) {
        return null;
    }

    @Override
    public List<Message> findOrderedListObjectsDescending(String listKey, int start, int count) {
        return null;
    }

    @Override
    public List<Message> findAllOrderedListObjectsDescending(String listKey) {
        return null;
    }

    @Override
    public List<String> findOrderedListAscending(String listKey, int start, int conut) {
        return null;
    }

    @Override
    public List<String> findAllOrderedListAscending(String listKey) {
        return null;
    }

    @Override
    public List<String> findOrderedListDescending(String listKey, int start, int conut) {
        return null;
    }

    @Override
    public List<String> findAllOrderedListDescending(String listKey) {
        return null;
    }

    @Override
    public List<String> findAllListsForObject(String objectKey) {
        return null;
    }

    @Override
    public void store(String key, Message object) {
        logger.debug("store(key,object)");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key), "null/empty key");
        Preconditions.checkArgument(object != null, "null object");
        this.doStore(key, object);
    }

    @Override
    public void delete(String key) {
    }

    @Override
    public void addToList(String listKey, String objectKey) {
        logger.debug("addToList(listKey,objectKey)");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(listKey), "null/empty listKey");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(objectKey), "null/empty objectKey");
        this.doAddToList(listKey, objectKey);
    }

    @Override
    public void removeFromList(String listKey, String objectKey) {
    }

    @Override
    public void removeFromAllLists(String objectKey) {
    }

    @Override
    public void addToOrderedList(String listKey, String objectKey, long weight) {
    }

    @Override
    public void storeOrUpdate(String key, Message object) {
        this.store(key, object);
    }

    protected void doStore(String key, Message object) {
        logger.debug("storing message: {}", (Object)object);
        StringBuilder sqlStringBuilder = new StringBuilder();
        sqlStringBuilder.append("REPLACE INTO ").append(this.getTableName()).append(" SET ").append(this.getKeyFieldName()).append(" = ?");
        for (String fieldName : Protobufs.getDefinedFieldNames(object)) {
            if (fieldName.equalsIgnoreCase(this.getKeyFieldName())) continue;
            sqlStringBuilder.append(", ").append(fieldName.toUpperCase()).append(" = ?");
        }
        String sql = sqlStringBuilder.toString();
        logger.debug("sql to run for store: {}", (Object)sql);
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(key);
        for (String fieldName : Protobufs.getDefinedFieldNames(object)) {
            if (fieldName.equalsIgnoreCase(this.getKeyFieldName())) continue;
            parameters.add(Protobufs.getValueForFieldName(object, fieldName));
        }
        this.getJdbcTemplate().update(sqlStringBuilder.toString(), parameters.toArray());
    }

    protected List<String> doFindList(String listKey, int start, int count) {
        StringBuilder sqlStringBuilder = new StringBuilder();
        sqlStringBuilder.append("SELECT `OBJECT_KEY` FROM ").append(this.getListTableName()).append(" WHERE `LIST_KEY` = ? LIMIT ?,?");
        List<String> objectKeys = this.getJdbcTemplate().query(sqlStringBuilder.toString(), (rs, rowNum) -> rs.getString(0), listKey, start, count);
        return objectKeys != null ? objectKeys : Collections.emptyList();
    }

    protected void doAddToList(String listKey, String objectKey) {
        StringBuilder sqlStringBuilder = new StringBuilder();
        sqlStringBuilder.append("REPLACE INTO ").append(this.getListTableName()).append(" SET `LIST_KEY` = ?, `OBJECT_KEY` = ?");
        this.getJdbcTemplate().update(sqlStringBuilder.toString(), listKey, objectKey);
    }

    @Override
    public Message getMessageDefaultInstance() {
        return this.messageDefaultInstance;
    }

    protected Message.Builder getMessageBuilder() {
        return this.messageDefaultInstance.newBuilderForType();
    }

    protected String getKeyFieldName() {
        return this.getMessageDefaultInstance().getDescriptorForType().getFields().get(0).getName().toUpperCase();
    }

    protected String getTableName() {
        return this.getMessageDefaultInstance().getClass().getSimpleName().toUpperCase();
    }

    protected String getListTableName() {
        return this.getTableName() + "_LIST";
    }
}

