package org.accidia.echo.resources;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.ws.rs.Path;

import com.google.common.base.Strings;
import org.accidia.echo.EchoContext;
import org.accidia.echo.Constants;
import org.accidia.echo.protoserver.misc.AsyncResponses;
import org.accidia.echo.protoserver.misc.MediaTypes;
import org.glassfish.jersey.server.ManagedAsync;

import javax.ws.rs.*;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import java.util.concurrent.TimeUnit;

import static com.google.common.base.Preconditions.checkArgument;

@Path("/v1/template/")
public class TemplateResource {
    private final Logger logger = LoggerFactory.getLogger(getClass());
    private final long requestTimeoutInSeconds = EchoContext.INSTANCE.getConfiguration()
            .getConfig().getLong(Constants.CONFIG_KEY__RESOURCE_TIMEOUT_SECONDS);

    @GET
    @Path("/{tenant}/{templateId}")
    @Produces({MediaTypes.APPLICATION_PROTOBUF + ";qs=0.5", MediaType.APPLICATION_JSON})
    @ManagedAsync
    public void getTemplate(@Suspended final AsyncResponse asyncResponse,
                            @PathParam("tenant") final String tenant,
                            @PathParam("templateId") final String templateId) {
        logger.debug("getTemplate()");

        // first validate parameters
//        this.tenantServices.validateTenant(tenant);
        checkArgument(!Strings.isNullOrEmpty(templateId.trim()), "null/empty templateId");

        // then add timeout and completion handler
        AsyncResponses.addTimeoutHandler(asyncResponse, this.requestTimeoutInSeconds, TimeUnit.SECONDS);
        AsyncResponses.addCompletionCallback(asyncResponse);

        // then do get the object
        doGetTemplate(asyncResponse, tenant, templateId);
    }

    protected void doGetTemplate(final AsyncResponse asyncResponse, final String tenant, final String templateId) {
        asyncResponse.resume(Response.ok().entity("<testing>" + templateId + "</testing>").type(MediaType.TEXT_PLAIN).build());
    }
}

