/*
 * Decompiled with CFR 0.152.
 */
package org.accidia.echo.mysql.keyvalue;

import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.accidia.echo.dao.IProtobufDao;
import org.accidia.echo.mysql.keyvalue.MySqlKeyValueProtobufDao;
import org.accidia.echo.protos.Protos;
import org.jasypt.encryption.pbe.StandardPBEByteEncryptor;
import org.springframework.jdbc.core.RowMapper;

public class MySqlKeyValueEncryptedProtobufDao
extends MySqlKeyValueProtobufDao
implements IProtobufDao {
    private final String secretKey;
    private final RowMapper<Message> rowMapper;
    private final StandardPBEByteEncryptor encryptor;

    protected MySqlKeyValueEncryptedProtobufDao(Message messageDefaultInstance, Protos.DataSource dataSource, String secretKey) throws Descriptors.DescriptorValidationException, ReflectiveOperationException, IOException {
        super(messageDefaultInstance, dataSource);
        this.secretKey = secretKey;
        this.rowMapper = (resultSet, rowNum) -> this.mapResultSet(resultSet, this.getMessageBuilder());
        this.encryptor = new StandardPBEByteEncryptor();
        this.encryptor.setAlgorithm("PBEWithMD5AndDES");
        this.encryptor.setPassword(this.secretKey);
    }

    public static MySqlKeyValueEncryptedProtobufDao newInstance(Message messageDefaultInstancee, Protos.DataSource dataSource, String secretKey) {
        try {
            MySqlKeyValueEncryptedProtobufDao instance = new MySqlKeyValueEncryptedProtobufDao(messageDefaultInstancee, dataSource, secretKey);
            instance.createTablesIfNotExist();
            return instance;
        }
        catch (Descriptors.DescriptorValidationException | IOException | ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected byte[] messageToBytes(Message message) {
        byte[] plainBytes = message.toByteArray();
        if (plainBytes == null || plainBytes.length < 0) {
            return null;
        }
        return this.encryptor.encrypt(plainBytes);
    }

    @Override
    protected RowMapper<Message> getRowMapper() {
        return this.rowMapper;
    }

    protected Message mapResultSet(ResultSet resultSet, Message.Builder builder) throws SQLException {
        try {
            byte[] encryptedBytes = resultSet.getBytes("VALUE");
            if (encryptedBytes != null && encryptedBytes.length > 0) {
                builder.mergeFrom(this.encryptor.decrypt(encryptedBytes));
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new SQLException(e);
        }
        return builder.buildPartial();
    }

    @Override
    public long getObjectWeight(String listKey, String objectKey) {
        return 0L;
    }
}

