/*
 * Decompiled with CFR 0.152.
 */
package org.accidia.protoserver;

import com.google.common.base.Preconditions;
import java.net.URI;
import org.accidia.protoserver.IProtoServerApplication;
import org.accidia.protoserver.misc.ProtoServerException;
import org.eclipse.jetty.server.Server;
import org.glassfish.jersey.jetty.JettyHttpContainerFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseProtoServerApplication
implements IProtoServerApplication {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ResourceConfig resourceConfig = this.getResourceConfig().packages(new String[]{"org.accidia.protoserver"});
    private Server server = JettyHttpContainerFactory.createServer((URI)this.getBaseUri(), (ResourceConfig)this.resourceConfig, (boolean)false);

    @Override
    public void startServer() throws ProtoServerException {
        Preconditions.checkState((this.server != null ? 1 : 0) != 0, (Object)"null server");
        this.doStartServer();
    }

    @Override
    public void joinOnServer() throws ProtoServerException {
        Preconditions.checkState((this.server != null ? 1 : 0) != 0, (Object)"null server");
        this.doJoinOnServer();
    }

    @Override
    public void stopServer() throws ProtoServerException {
        Preconditions.checkState((this.server != null ? 1 : 0) != 0, (Object)"null server");
        this.doStopServer();
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    protected void doStartServer() throws ProtoServerException {
        this.logger.info("starting protoserver server at {}", (Object)this.getBaseUri().toString());
        try {
            this.server.start();
        }
        catch (Exception e) {
            this.logger.error("exception caught at server.start -> rethrowing", (Throwable)e);
            throw new ProtoServerException(e);
        }
    }

    protected void doJoinOnServer() throws ProtoServerException {
        this.logger.info("joining on server");
        try {
            this.server.join();
        }
        catch (Exception e) {
            this.logger.error("exception caught at server.join -> rethrowing", (Throwable)e);
            throw new ProtoServerException(e);
        }
    }

    protected void doStopServer() throws ProtoServerException {
        this.logger.info("stopping server");
        try {
            this.server.getServer().stop();
            this.server.destroy();
        }
        catch (Exception e) {
            this.logger.error("exception caught at server.stop/destroy -> rethrowing", (Throwable)e);
            throw new ProtoServerException(e);
        }
    }
}

