/*
 * Decompiled with CFR 0.152.
 */
package org.accidia.protoserver.misc;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.CompletionCallback;
import javax.ws.rs.container.TimeoutHandler;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncResponses {
    public static final Logger logger = LoggerFactory.getLogger(AsyncResponses.class);

    public static void addTimeoutHandler(AsyncResponse asyncResponse, long timeout, TimeUnit timeUnit) {
        logger.debug("addTimeoutHandler(asyncResponse)");
        Preconditions.checkArgument((asyncResponse != null ? 1 : 0) != 0, (Object)"null asyncResponse");
        Preconditions.checkArgument((timeUnit != null ? 1 : 0) != 0, (Object)"null timeUnit");
        asyncResponse.setTimeoutHandler(new TimeoutHandler(){

            public void handleTimeout(AsyncResponse asyncResponse) {
                asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.REQUEST_TIMEOUT).entity((Object)"operation timeout").build());
            }
        });
        asyncResponse.setTimeout(timeout, timeUnit);
    }

    public static void addCompletionCallback(AsyncResponse asyncResponse) {
        logger.debug("addCompletionCallback(asyncResponse)");
        Preconditions.checkArgument((asyncResponse != null ? 1 : 0) != 0, (Object)"null asyncResponse");
        asyncResponse.register((Object)new CompletionCallback(){

            public void onComplete(Throwable throwable) {
                if (throwable == null) {
                    logger.debug("completed");
                } else {
                    logger.warn("exception thrown: ", throwable);
                }
            }
        });
    }

    public static <ResponseType> void addCallbackForListenableFuture(final AsyncResponse asyncResponse, ListenableFuture<ResponseType> future) {
        logger.debug("addCallbackForListenableFuture(asyncResponse,future)");
        Preconditions.checkArgument((asyncResponse != null ? 1 : 0) != 0, (Object)"null asyncResponse");
        Preconditions.checkArgument((future != null ? 1 : 0) != 0, (Object)"null future");
        Futures.addCallback(future, (FutureCallback)new FutureCallback<ResponseType>(){

            public void onSuccess(ResponseType response) {
                asyncResponse.resume(response);
            }

            public void onFailure(Throwable throwable) {
                asyncResponse.resume(throwable);
            }
        });
    }
}

