/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.adapters.cas;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.adapters.cas.CasPasswordHandlerProxy;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.mock.web.MockHttpServletRequest;

public class CasPasswordHandlerProxyTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$adapters$cas$CasPasswordHandlerProxyTests;

    public CasPasswordHandlerProxyTests() {
    }

    public CasPasswordHandlerProxyTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$adapters$cas$CasPasswordHandlerProxyTests == null ? (class$org$acegisecurity$adapters$cas$CasPasswordHandlerProxyTests = CasPasswordHandlerProxyTests.class$("org.acegisecurity.adapters.cas.CasPasswordHandlerProxyTests")) : class$org$acegisecurity$adapters$cas$CasPasswordHandlerProxyTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testDetectsIfHttpServletRequestNotPassed() {
        MockCasPasswordHandlerProxy proxy = new MockCasPasswordHandlerProxy("org/acegisecurity/adapters/cas/applicationContext-valid.xml");
        try {
            proxy.authenticate(null, "x", "y");
            CasPasswordHandlerProxyTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            CasPasswordHandlerProxyTests.assertEquals((String)"Can only process HttpServletRequest", (String)expected.getMessage());
        }
    }

    public void testDetectsMissingDelegate() {
        MockCasPasswordHandlerProxy proxy = new MockCasPasswordHandlerProxy("org/acegisecurity/adapters/cas/applicationContext-invalid.xml");
        try {
            proxy.authenticate((ServletRequest)new MockHttpServletRequest(), "x", "y");
            CasPasswordHandlerProxyTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            CasPasswordHandlerProxyTests.assertEquals((String)"Bean context must contain at least one bean of type CasPasswordHandler", (String)expected.getMessage());
        }
    }

    public void testNormalOperation() {
        MockCasPasswordHandlerProxy proxy = new MockCasPasswordHandlerProxy("org/acegisecurity/adapters/cas/applicationContext-valid.xml");
        CasPasswordHandlerProxyTests.assertTrue((boolean)proxy.authenticate((ServletRequest)new MockHttpServletRequest(), "marissa", "koala"));
        CasPasswordHandlerProxyTests.assertFalse((boolean)proxy.authenticate((ServletRequest)new MockHttpServletRequest(), "marissa", "WRONG_PASSWORD"));
        CasPasswordHandlerProxyTests.assertFalse((boolean)proxy.authenticate((ServletRequest)new MockHttpServletRequest(), "INVALID_USER_NAME", "WRONG_PASSWORD"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MockCasPasswordHandlerProxy
    extends CasPasswordHandlerProxy {
        private ApplicationContext ctx;

        public MockCasPasswordHandlerProxy(String appContextLocation) {
            this.ctx = new ClassPathXmlApplicationContext(appContextLocation);
        }

        private MockCasPasswordHandlerProxy() {
        }

        protected ApplicationContext getContext(HttpServletRequest httpRequest) {
            return this.ctx;
        }
    }
}

