/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.adapters.cas;

import javax.servlet.ServletRequest;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.MockAuthenticationManager;
import org.acegisecurity.adapters.cas.CasPasswordHandler;
import org.springframework.mock.web.MockHttpServletRequest;

public class CasPasswordHandlerTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$adapters$cas$CasPasswordHandlerTests;

    public CasPasswordHandlerTests() {
    }

    public CasPasswordHandlerTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$adapters$cas$CasPasswordHandlerTests == null ? (class$org$acegisecurity$adapters$cas$CasPasswordHandlerTests = CasPasswordHandlerTests.class$("org.acegisecurity.adapters.cas.CasPasswordHandlerTests")) : class$org$acegisecurity$adapters$cas$CasPasswordHandlerTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testDeniesAccessWhenAuthenticationManagerThrowsException() throws Exception {
        CasPasswordHandler handler = new CasPasswordHandler();
        handler.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager(false));
        handler.afterPropertiesSet();
        CasPasswordHandlerTests.assertFalse((boolean)handler.authenticate((ServletRequest)new MockHttpServletRequest(), "username", "password"));
    }

    public void testDetectsEmptyAuthenticationManager() throws Exception {
        CasPasswordHandler handler = new CasPasswordHandler();
        try {
            handler.afterPropertiesSet();
            CasPasswordHandlerTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            CasPasswordHandlerTests.assertEquals((String)"An AuthenticationManager is required", (String)expected.getMessage());
        }
    }

    public void testGettersSetters() {
        CasPasswordHandler handler = new CasPasswordHandler();
        handler.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager(false));
        CasPasswordHandlerTests.assertTrue((handler.getAuthenticationManager() != null ? 1 : 0) != 0);
    }

    public void testGracefullyHandlesEmptyUsernamesAndPassword() throws Exception {
        CasPasswordHandler handler = new CasPasswordHandler();
        handler.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager(true));
        handler.afterPropertiesSet();
        CasPasswordHandlerTests.assertFalse((boolean)handler.authenticate((ServletRequest)new MockHttpServletRequest(), "", "password"));
        CasPasswordHandlerTests.assertFalse((boolean)handler.authenticate((ServletRequest)new MockHttpServletRequest(), null, "password"));
        CasPasswordHandlerTests.assertTrue((boolean)handler.authenticate((ServletRequest)new MockHttpServletRequest(), "user", null));
        CasPasswordHandlerTests.assertTrue((boolean)handler.authenticate((ServletRequest)new MockHttpServletRequest(), "user", ""));
    }

    public void testNormalOperation() throws Exception {
        CasPasswordHandler handler = new CasPasswordHandler();
        handler.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager(true));
        handler.afterPropertiesSet();
        CasPasswordHandlerTests.assertTrue((boolean)handler.authenticate((ServletRequest)new MockHttpServletRequest(), "username", "password"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

