/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.adapters.cas3;

import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.adapters.cas3.CasAuthenticationHandler;
import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.UsernamePasswordCredentials;
import org.springframework.test.AbstractDependencyInjectionSpringContextTests;

public class CasAuthenticationHandlerTests
extends AbstractDependencyInjectionSpringContextTests {
    private AuthenticationManager authenticationManager;
    private CasAuthenticationHandler casAuthenticationHandler;

    protected String[] getConfigLocations() {
        return new String[]{"/org/acegisecurity/adapters/cas/applicationContext-valid.xml"};
    }

    private UsernamePasswordCredentials getCredentialsFor(String username, String password) {
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials();
        credentials.setUsername(username);
        credentials.setPassword(password);
        return credentials;
    }

    protected void onSetUp() throws Exception {
        this.casAuthenticationHandler = new CasAuthenticationHandler();
        this.casAuthenticationHandler.setAuthenticationManager(this.authenticationManager);
        this.casAuthenticationHandler.afterPropertiesSet();
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void testAfterPropertiesSet() throws Exception {
        this.casAuthenticationHandler.setAuthenticationManager(null);
        try {
            this.casAuthenticationHandler.afterPropertiesSet();
            CasAuthenticationHandlerTests.fail((String)"IllegalArgumenException expected when no AuthenticationManager is set.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGracefullyHandlesInvalidInput() {
        try {
            CasAuthenticationHandlerTests.assertFalse((boolean)this.casAuthenticationHandler.authenticate((Credentials)this.getCredentialsFor("", "")));
            CasAuthenticationHandlerTests.assertFalse((boolean)this.casAuthenticationHandler.authenticate((Credentials)this.getCredentialsFor(null, null)));
        }
        catch (AuthenticationException e) {
            CasAuthenticationHandlerTests.fail((String)"AuthenticationException not expected.");
        }
    }

    public void testInvalidUsernamePasswordCombination() {
        try {
            CasAuthenticationHandlerTests.assertFalse((boolean)this.casAuthenticationHandler.authenticate((Credentials)this.getCredentialsFor("scott", "scott")));
        }
        catch (AuthenticationException e) {
            CasAuthenticationHandlerTests.fail((String)"AuthenticationException not expected.");
        }
    }

    public void testValidUsernamePasswordCombination() {
        try {
            CasAuthenticationHandlerTests.assertTrue((boolean)this.casAuthenticationHandler.authenticate((Credentials)this.getCredentialsFor("scott", "wombat")));
        }
        catch (AuthenticationException e) {
            CasAuthenticationHandlerTests.fail((String)"AuthenticationException not expected.");
        }
    }
}

