/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.adapters.cas3;

import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.jasig.cas.authentication.principal.UsernamePasswordCredentials;
import org.springframework.util.Assert;

public final class CasAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler {
    private AuthenticationManager authenticationManager;
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    protected void afterPropertiesSetInternal() throws Exception {
        Assert.notNull((Object)this.authenticationManager, (String)"authenticationManager cannot be null.");
    }

    protected boolean authenticateUsernamePasswordInternal(UsernamePasswordCredentials credentials) throws org.jasig.cas.authentication.handler.AuthenticationException {
        UsernamePasswordAuthenticationToken authenticationRequest = new UsernamePasswordAuthenticationToken((Object)credentials.getUsername(), (Object)credentials.getPassword());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Attempting to authenticate for user: " + credentials.getUsername()));
        }
        try {
            this.authenticationManager.authenticate((Authentication)authenticationRequest);
        }
        catch (AuthenticationException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Authentication request for " + credentials.getUsername() + " failed: " + e.toString()), (Throwable)e);
            }
            return false;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Authentication request for " + credentials.getUsername() + " successful."));
        }
        return true;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }
}

