/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.adapters.catalina;

import java.io.File;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Map;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.adapters.PrincipalAcegiUserToken;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.realm.RealmBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class CatalinaAcegiUserRealm
extends RealmBase {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$adapters$catalina$CatalinaAcegiUserRealm == null ? (class$org$acegisecurity$adapters$catalina$CatalinaAcegiUserRealm = CatalinaAcegiUserRealm.class$("org.acegisecurity.adapters.catalina.CatalinaAcegiUserRealm")) : class$org$acegisecurity$adapters$catalina$CatalinaAcegiUserRealm));
    private AuthenticationManager authenticationManager;
    private Container container;
    private String appContextLocation;
    private String key;
    protected final String name = "CatalinaSpringUserRealm / $Id: CatalinaAcegiUserRealm.java 1496 2006-05-23 13:38:33Z benalex $";
    static /* synthetic */ Class class$org$acegisecurity$adapters$catalina$CatalinaAcegiUserRealm;
    static /* synthetic */ Class class$org$acegisecurity$AuthenticationManager;

    public Principal authenticate(String username, String credentials) {
        if (username == null) {
            return null;
        }
        if (credentials == null) {
            credentials = "";
        }
        UsernamePasswordAuthenticationToken request = new UsernamePasswordAuthenticationToken((Object)username, (Object)credentials);
        Authentication response = null;
        try {
            response = this.authenticationManager.authenticate((Authentication)request);
        }
        catch (AuthenticationException failed) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Authentication request for user: " + username + " failed: " + failed.toString()));
            }
            return null;
        }
        return new PrincipalAcegiUserToken(this.key, response.getPrincipal().toString(), response.getCredentials().toString(), response.getAuthorities(), response.getPrincipal());
    }

    public Principal authenticate(String username, byte[] credentials) {
        return this.authenticate(username, new String(credentials));
    }

    public Principal authenticate(String username, String digest, String nonce, String nc, String cnonce, String qop, String realm, String md5a2) {
        return null;
    }

    public Principal authenticate(X509Certificate[] x509Certificates) {
        return null;
    }

    public String getAppContextLocation() {
        return this.appContextLocation;
    }

    public String getKey() {
        return this.key;
    }

    protected String getName() {
        return this.name;
    }

    protected String getPassword(String arg0) {
        return null;
    }

    protected Principal getPrincipal(String arg0) {
        return null;
    }

    public boolean hasRole(Principal principal, String role) {
        if (principal == null || role == null) {
            return false;
        }
        if (!(principal instanceof PrincipalAcegiUserToken)) {
            logger.warn((Object)("Expected passed principal to be of type PrincipalAcegiUserToken but was " + principal.getClass().getName()));
            return false;
        }
        PrincipalAcegiUserToken test = (PrincipalAcegiUserToken)principal;
        return test.isUserInRole(role);
    }

    public void setAppContextLocation(String appContextLocation) {
        this.appContextLocation = appContextLocation;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void start() throws LifecycleException {
        this.start(true);
    }

    private void start(boolean startParent) throws LifecycleException {
        if (startParent) {
            super.start();
        }
        if (this.appContextLocation == null || "".equals(this.appContextLocation)) {
            throw new LifecycleException("appContextLocation must be defined");
        }
        if (this.key == null || "".equals(this.key)) {
            throw new LifecycleException("key must be defined");
        }
        File xml = new File(System.getProperty("catalina.base"), this.appContextLocation);
        if (!xml.exists()) {
            throw new LifecycleException("appContextLocation does not seem to exist in " + xml.toString());
        }
        FileSystemXmlApplicationContext ctx = new FileSystemXmlApplicationContext("file:" + xml.getAbsolutePath());
        Map beans = ctx.getBeansOfType(class$org$acegisecurity$AuthenticationManager == null ? (class$org$acegisecurity$AuthenticationManager = CatalinaAcegiUserRealm.class$("org.acegisecurity.AuthenticationManager")) : class$org$acegisecurity$AuthenticationManager, true, true);
        if (beans.size() == 0) {
            throw new IllegalArgumentException("Bean context must contain at least one bean of type AuthenticationManager");
        }
        String beanName = (String)beans.keySet().iterator().next();
        this.authenticationManager = (AuthenticationManager)beans.get(beanName);
        logger.info((Object)"CatalinaAcegiUserRealm Started");
    }

    protected void startForTest() throws LifecycleException {
        this.start(false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

