/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.adapters.jboss;

import java.io.IOException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.acegisecurity.AccountExpiredException;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.CredentialsExpiredException;
import org.acegisecurity.adapters.PrincipalAcegiUserToken;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.spi.AbstractServerLoginModule;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.beans.factory.access.SingletonBeanFactoryLocator;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class JbossAcegiLoginModule
extends AbstractServerLoginModule {
    private AuthenticationManager authenticationManager;
    private Principal identity;
    private String key;
    private char[] credential;
    static /* synthetic */ Class class$org$acegisecurity$AuthenticationManager;

    protected Principal getIdentity() {
        return this.identity;
    }

    protected Group[] getRoleSets() throws LoginException {
        SimpleGroup roles = new SimpleGroup("Roles");
        Group[] roleSets = new Group[]{roles};
        if (this.identity instanceof Authentication) {
            Authentication user = (Authentication)this.identity;
            for (int i = 0; i < user.getAuthorities().length; ++i) {
                roles.addMember((Principal)new SimplePrincipal(user.getAuthorities()[i].getAuthority()));
            }
        }
        return roleSets;
    }

    protected String[] getUsernameAndPassword() throws LoginException {
        String[] info = new String[]{null, null};
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available to collect authentication information");
        }
        NameCallback nc = new NameCallback("User name: ", "guest");
        PasswordCallback pc = new PasswordCallback("Password: ", false);
        Callback[] callbacks = new Callback[]{nc, pc};
        String username = null;
        String password = null;
        try {
            this.callbackHandler.handle(callbacks);
            username = nc.getName();
            char[] tmpPassword = pc.getPassword();
            if (tmpPassword != null) {
                this.credential = new char[tmpPassword.length];
                System.arraycopy(tmpPassword, 0, this.credential, 0, tmpPassword.length);
                pc.clearPassword();
                password = new String(this.credential);
            }
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException("CallbackHandler does not support: " + uce.getCallback());
        }
        info[0] = username;
        info[1] = password;
        return info;
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)"initializing jboss login module");
        }
        this.key = (String)options.get("key");
        if (this.key == null || "".equals(this.key)) {
            throw new IllegalArgumentException("key must be defined");
        }
        String singletonId = (String)options.get("singletonId");
        String appContextLocation = (String)options.get("appContextLocation");
        if ((singletonId == null || "".equals(singletonId)) && appContextLocation == null || "".equals(appContextLocation)) {
            throw new IllegalArgumentException("appContextLocation must be defined");
        }
        String beanName = (String)options.get("authenticationManager");
        if ((singletonId == null || "".equals(singletonId)) && Thread.currentThread().getContextClassLoader().getResource(appContextLocation) == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("cannot locate " + appContextLocation));
            }
            throw new IllegalArgumentException("Cannot locate " + appContextLocation);
        }
        ClassPathXmlApplicationContext ctx = null;
        if (singletonId == null || "".equals(singletonId)) {
            try {
                ctx = new ClassPathXmlApplicationContext(appContextLocation);
            }
            catch (Exception e) {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("error loading spring context " + appContextLocation + " " + e));
                }
                throw new IllegalArgumentException("error loading spring context " + appContextLocation + " " + e);
            }
        } else {
            BeanFactoryLocator bfl;
            BeanFactoryReference bf;
            if (this.log.isInfoEnabled()) {
                this.log.debug((Object)("retrieving singleton instance " + singletonId));
            }
            if ((ctx = (ApplicationContext)(bf = (bfl = SingletonBeanFactoryLocator.getInstance()).useBeanFactory(singletonId)).getFactory()) == null) {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("singleton " + beanName + " does not exists"));
                }
                throw new IllegalArgumentException("singleton " + singletonId + " does not exists");
            }
        }
        if (beanName == null || "".equals(beanName)) {
            Map beans = null;
            try {
                beans = ctx.getBeansOfType(class$org$acegisecurity$AuthenticationManager == null ? (class$org$acegisecurity$AuthenticationManager = JbossAcegiLoginModule.class$("org.acegisecurity.AuthenticationManager")) : class$org$acegisecurity$AuthenticationManager, true, true);
            }
            catch (Exception e) {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("exception in getBeansOfType " + e));
                }
                throw new IllegalStateException("spring error in get beans by class");
            }
            if (beans.size() == 0) {
                throw new IllegalArgumentException("Bean context must contain at least one bean of type AuthenticationManager");
            }
            beanName = (String)beans.keySet().iterator().next();
        }
        this.authenticationManager = (AuthenticationManager)ctx.getBean(beanName);
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)"Successfully started JbossSpringLoginModule");
        }
    }

    public boolean login() throws LoginException {
        this.loginOk = false;
        String[] info = this.getUsernameAndPassword();
        String username = info[0];
        String password = info[1];
        if (username == null && password == null) {
            this.identity = null;
            this.log.trace((Object)("Authenticating as unauthenticatedIdentity=" + this.identity));
        }
        if (username == null) {
            username = "";
        }
        if (password == null) {
            password = "";
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"checking identity");
        }
        if (this.identity == null) {
            this.log.debug((Object)"creating usernamepassword token");
            UsernamePasswordAuthenticationToken request = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
            Authentication response = null;
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"attempting authentication");
                }
                response = this.authenticationManager.authenticate((Authentication)request);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"authentication succeded");
                }
            }
            catch (CredentialsExpiredException cee) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Credential has expired");
                }
                throw new CredentialExpiredException("The credential used to identify the user has expired");
            }
            catch (AccountExpiredException cee) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Account has expired, throwing jaas exception");
                }
                throw new javax.security.auth.login.AccountExpiredException("The account specified in login has expired");
            }
            catch (AuthenticationException failed) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Bad password for username=" + username));
                }
                throw new FailedLoginException("Password Incorrect/Password Required");
            }
            this.log.debug((Object)"user is logged. redirecting to jaas classes");
            this.identity = new PrincipalAcegiUserToken(this.key, response.getName(), response.getCredentials().toString(), response.getAuthorities(), response.getPrincipal());
        }
        if (this.getUseFirstPass()) {
            this.sharedState.put("javax.security.auth.login.name", username);
            this.sharedState.put("javax.security.auth.login.password", this.credential);
        }
        this.loginOk = true;
        this.log.trace((Object)("User '" + this.identity + "' authenticated, loginOk=" + this.loginOk));
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

