/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.adapters.jetty;

import java.util.Map;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.adapters.jetty.JettyAcegiUserToken;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.UserPrincipal;
import org.mortbay.http.UserRealm;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public final class JettyAcegiUserRealm
implements UserRealm {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$adapters$jetty$JettyAcegiUserRealm == null ? (class$org$acegisecurity$adapters$jetty$JettyAcegiUserRealm = JettyAcegiUserRealm.class$("org.acegisecurity.adapters.jetty.JettyAcegiUserRealm")) : class$org$acegisecurity$adapters$jetty$JettyAcegiUserRealm));
    private AuthenticationManager authenticationManager;
    private String key;
    private String realm;
    static /* synthetic */ Class class$org$acegisecurity$adapters$jetty$JettyAcegiUserRealm;
    static /* synthetic */ Class class$org$acegisecurity$AuthenticationManager;

    public JettyAcegiUserRealm(String realm, String providerKey, String appContextLocation) {
        this.realm = realm;
        this.key = providerKey;
        if (realm == null || "".equals(realm)) {
            throw new IllegalArgumentException("realm must be specified");
        }
        if (this.key == null || "".equals(this.key)) {
            throw new IllegalArgumentException("key must be specified");
        }
        if (appContextLocation == null || "".equals(appContextLocation)) {
            throw new IllegalArgumentException("appContextLocation must be specified");
        }
        if (Thread.currentThread().getContextClassLoader().getResource(appContextLocation) == null) {
            throw new IllegalArgumentException("Cannot locate " + appContextLocation);
        }
        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext(appContextLocation);
        Map beans = ctx.getBeansOfType(class$org$acegisecurity$AuthenticationManager == null ? (class$org$acegisecurity$AuthenticationManager = JettyAcegiUserRealm.class$("org.acegisecurity.AuthenticationManager")) : class$org$acegisecurity$AuthenticationManager, true, true);
        if (beans.size() == 0) {
            throw new IllegalArgumentException("Bean context must contain at least one bean of type AuthenticationManager");
        }
        String beanName = (String)beans.keySet().iterator().next();
        this.authenticationManager = (AuthenticationManager)beans.get(beanName);
    }

    protected JettyAcegiUserRealm() {
        throw new IllegalArgumentException("Cannot use default constructor");
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public String getName() {
        return this.realm;
    }

    public UserPrincipal authenticate(String username, Object password, HttpRequest httpRequest) {
        if (username == null) {
            return null;
        }
        if (password == null) {
            password = "";
        }
        UsernamePasswordAuthenticationToken request = new UsernamePasswordAuthenticationToken((Object)username.toString(), (Object)password.toString());
        Authentication response = null;
        try {
            response = this.authenticationManager.authenticate((Authentication)request);
        }
        catch (AuthenticationException failed) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Authentication request for user: " + username + " failed: " + failed.toString()));
            }
            return null;
        }
        return new JettyAcegiUserToken(this.key, response.getPrincipal().toString(), response.getCredentials().toString(), response.getAuthorities());
    }

    public void disassociate(UserPrincipal userPrincipal) {
    }

    public void logout(UserPrincipal arg0) {
    }

    public UserPrincipal popRole(UserPrincipal userPrincipal) {
        return userPrincipal;
    }

    public UserPrincipal pushRole(UserPrincipal userPrincipal, String role) {
        return userPrincipal;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

