/* Copyright 2004, 2005 Acegi Technology Pty Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.acegisecurity.event.authentication;

import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;


/**
 * Application event which indicates authentication failure due to the user's
 * account having expired.
 *
 * @author Ben Alex
 * @version $Id: AuthenticationFailureExpiredEvent.java,v 1.2 2005/11/17 00:55:48 benalex Exp $
 */
public class AuthenticationFailureExpiredEvent
    extends AbstractAuthenticationFailureEvent {
    //~ Constructors ===========================================================

    public AuthenticationFailureExpiredEvent(Authentication authentication,
        AuthenticationException exception) {
        super(authentication, exception);
    }
}
