/* Copyright 2004 Acegi Technology Pty Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.acegisecurity.providers.dao.cache;

import org.acegisecurity.providers.dao.UserCache;
import org.acegisecurity.userdetails.UserDetails;


/**
 * Does not perform any caching.
 *
 * @author Ben Alex
 * @version $Id: NullUserCache.java,v 1.6 2005/11/29 13:10:11 benalex Exp $
 */
public class NullUserCache implements UserCache {
    //~ Methods ================================================================

    public UserDetails getUserFromCache(String username) {
        return null;
    }

    public void putUserInCache(UserDetails user) {}

    public void removeUserFromCache(String username) {}
}
