/* Copyright 2004, 2005 Acegi Technology Pty Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.acegisecurity.providers.ldap.authenticator;

import org.acegisecurity.providers.encoding.ShaPasswordEncoder;

/**
 * A version of {@link ShaPasswordEncoder} which always uses
 * Base-64 encoding and prepends the string
 * "{SHA}" to the encoded hash.
 *
 * @author Luke Taylor
 * @version $Id: LdapShaPasswordEncoder.java,v 1.1 2005/12/15 00:18:12 luke_t Exp $
 */
public class LdapShaPasswordEncoder extends ShaPasswordEncoder {
    public LdapShaPasswordEncoder() {
        super.setEncodeHashAsBase64(true);
    }

    public String encodePassword(String rawPass, Object salt) {
        return "{SHA}" + super.encodePassword(rawPass, salt);
    }
}
