/* Copyright 2004, 2005, 2006 Acegi Technology Pty Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.acegisecurity.providers;

import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;


/**
 * Indicates a class can process a specific  {@link
 * org.acegisecurity.Authentication} implementation.
 *
 * @author Ben Alex
 * @version $Id: AuthenticationProvider.java 1496 2006-05-23 13:38:33Z benalex $
 */
public interface AuthenticationProvider {
    //~ Methods ========================================================================================================

    /**
     * Performs authentication with the same contract as {@link
     * org.acegisecurity.AuthenticationManager#authenticate(Authentication)}.
     *
     * @param authentication the authentication request object.
     *
     * @return a fully authenticated object including credentials. May return <code>null</code> if the
     *         <code>AuthenticationProvider</code> is unable to support authentication of the passed
     *         <code>Authentication</code> object. In such a case, the next <code>AuthenticationProvider</code> that
     *         supports the presented <code>Authentication</code> class will be tried.
     *
     * @throws AuthenticationException if authentication fails.
     */
    public Authentication authenticate(Authentication authentication)
        throws AuthenticationException;

    /**
     * Returns <code>true</code> if this <Code>AuthenticationProvider</code> supports the indicated
     * <Code>Authentication</code> object.<p>Returning <code>true</code> does not guarantee an
     * <code>AuthenticationProvider</code> will be able to authenticate the presented instance of the
     * <code>Authentication</code> class. It simply indicates it can support closer evaluation of it. An
     * <code>AuthenticationProvider</code> can still return <code>null</code> from the {@link
     * #authenticate(Authentication)} method to indicate another <code>AuthenticationProvider</code> should be tried.</p>
     *  <P>Selection of an <code>AuthenticationProvider</code> capable of performing authentication is
     * conducted at runtime the <code>ProviderManager</code>.</p>
     *
     * @param authentication DOCUMENT ME!
     *
     * @return <code>true</code> if the implementation can more closely evaluate the <code>Authentication</code> class
     *         presented
     */
    public boolean supports(Class authentication);
}
