/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.acls.jdbc;

import java.lang.reflect.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.acegisecurity.Authentication;
import org.acegisecurity.acls.AccessControlEntry;
import org.acegisecurity.acls.Acl;
import org.acegisecurity.acls.AlreadyExistsException;
import org.acegisecurity.acls.ChildrenExistException;
import org.acegisecurity.acls.MutableAcl;
import org.acegisecurity.acls.MutableAclService;
import org.acegisecurity.acls.NotFoundException;
import org.acegisecurity.acls.domain.AccessControlEntryImpl;
import org.acegisecurity.acls.jdbc.AclCache;
import org.acegisecurity.acls.jdbc.JdbcAclService;
import org.acegisecurity.acls.jdbc.LookupStrategy;
import org.acegisecurity.acls.objectidentity.ObjectIdentity;
import org.acegisecurity.acls.objectidentity.ObjectIdentityImpl;
import org.acegisecurity.acls.sid.GrantedAuthoritySid;
import org.acegisecurity.acls.sid.PrincipalSid;
import org.acegisecurity.acls.sid.Sid;
import org.acegisecurity.context.SecurityContextHolder;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class JdbcMutableAclService
extends JdbcAclService
implements MutableAclService {
    private AclCache aclCache;
    private String deleteClassByClassNameString = "DELETE FROM acl_class WHERE class=?";
    private String deleteEntryByObjectIdentityForeignKey = "DELETE FROM acl_entry WHERE acl_object_identity=?";
    private String deleteObjectIdentityByPrimaryKey = "DELETE FROM acl_object_identity WHERE id=?";
    private String identityQuery = "call identity()";
    private String insertClass = "INSERT INTO acl_class (id, class) VALUES (null, ?)";
    private String insertEntry = "INSERT INTO acl_entry (id, acl_object_identity, ace_order, sid, mask, granting, audit_success, audit_failure)VALUES (null, ?, ?, ?, ?, ?, ?, ?)";
    private String insertObjectIdentity = "INSERT INTO acl_object_identity (id, object_id_class, object_id_identity, owner_sid, entries_inheriting) VALUES (null, ?, ?, ?, ?)";
    private String insertSid = "INSERT INTO acl_sid (id, principal, sid) VALUES (null, ?, ?)";
    private String selectClassPrimaryKey = "SELECT id FROM acl_class WHERE class=?";
    private String selectCountObjectIdentityRowsForParticularClassNameString = "SELECT COUNT(acl_object_identity.id) FROM acl_object_identity, acl_class WHERE acl_class.id = acl_object_identity.object_id_class and class=?";
    private String selectObjectIdentityPrimaryKey = "SELECT acl_object_identity.id FROM acl_object_identity, acl_class WHERE acl_object_identity.object_id_class = acl_class.id and acl_class.class=? and acl_object_identity.object_id_identity = ?";
    private String selectSidPrimaryKey = "SELECT id FROM acl_sid WHERE principal=? AND sid=?";
    private String updateObjectIdentity = "UPDATE acl_object_identity SET parent_object = ?, owner_sid = ?, entries_inheriting = ?where id = ?";
    static /* synthetic */ Class class$org$acegisecurity$acls$MutableAcl;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$org$acegisecurity$acls$objectidentity$ObjectIdentityImpl;

    public JdbcMutableAclService(DataSource dataSource, LookupStrategy lookupStrategy, AclCache aclCache) {
        super(dataSource, lookupStrategy);
        Assert.notNull((Object)aclCache, (String)"AclCache required");
        this.aclCache = aclCache;
    }

    public MutableAcl createAcl(ObjectIdentity objectIdentity) throws AlreadyExistsException {
        Assert.notNull((Object)objectIdentity, (String)"Object Identity required");
        if (this.retrieveObjectIdentityPrimaryKey(objectIdentity) != null) {
            throw new AlreadyExistsException("Object identity '" + objectIdentity + "' already exists");
        }
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        PrincipalSid sid = new PrincipalSid(auth);
        this.createObjectIdentity(objectIdentity, sid);
        Acl acl = this.readAclById(objectIdentity);
        Assert.isInstanceOf((Class)(class$org$acegisecurity$acls$MutableAcl == null ? (class$org$acegisecurity$acls$MutableAcl = JdbcMutableAclService.class$("org.acegisecurity.acls.MutableAcl")) : class$org$acegisecurity$acls$MutableAcl), (Object)acl, (String)"MutableAcl should be been returned");
        return (MutableAcl)acl;
    }

    protected void createEntries(final MutableAcl acl) {
        this.jdbcTemplate.batchUpdate(this.insertEntry, new BatchPreparedStatementSetter(){

            public int getBatchSize() {
                return acl.getEntries().length;
            }

            public void setValues(PreparedStatement stmt, int i) throws SQLException {
                AccessControlEntry entry_ = (AccessControlEntry)Array.get(acl.getEntries(), i);
                Assert.isTrue((boolean)(entry_ instanceof AccessControlEntryImpl), (String)"Unknown ACE class");
                AccessControlEntryImpl entry = (AccessControlEntryImpl)entry_;
                stmt.setLong(1, (Long)acl.getId());
                stmt.setInt(2, i);
                stmt.setLong(3, JdbcMutableAclService.this.createOrRetrieveSidPrimaryKey(entry.getSid(), true));
                stmt.setInt(4, entry.getPermission().getMask());
                stmt.setBoolean(5, entry.isGranting());
                stmt.setBoolean(6, entry.isAuditSuccess());
                stmt.setBoolean(7, entry.isAuditFailure());
            }
        });
    }

    protected void createObjectIdentity(ObjectIdentity object, Sid owner) {
        Long sidId = this.createOrRetrieveSidPrimaryKey(owner, true);
        Long classId = this.createOrRetrieveClassPrimaryKey(object.getJavaType(), true);
        this.jdbcTemplate.update(this.insertObjectIdentity, new Object[]{classId, object.getIdentifier().toString(), sidId, new Boolean(true)});
    }

    protected Long createOrRetrieveClassPrimaryKey(Class clazz, boolean allowCreate) {
        List classIds = this.jdbcTemplate.queryForList(this.selectClassPrimaryKey, new Object[]{clazz.getName()}, class$java$lang$Long == null ? (class$java$lang$Long = JdbcMutableAclService.class$("java.lang.Long")) : class$java$lang$Long);
        Long classId = null;
        if (classIds.isEmpty()) {
            if (allowCreate) {
                classId = null;
                this.jdbcTemplate.update(this.insertClass, new Object[]{clazz.getName()});
                Assert.isTrue((boolean)TransactionSynchronizationManager.isSynchronizationActive(), (String)"Transaction must be running");
                classId = new Long(this.jdbcTemplate.queryForLong(this.identityQuery));
            }
        } else {
            classId = (Long)classIds.iterator().next();
        }
        return classId;
    }

    protected Long createOrRetrieveSidPrimaryKey(Sid sid, boolean allowCreate) {
        Assert.notNull((Object)sid, (String)"Sid required");
        String sidName = null;
        boolean principal = true;
        if (sid instanceof PrincipalSid) {
            sidName = ((PrincipalSid)sid).getPrincipal();
        } else if (sid instanceof GrantedAuthoritySid) {
            sidName = ((GrantedAuthoritySid)sid).getGrantedAuthority();
            principal = false;
        } else {
            throw new IllegalArgumentException("Unsupported implementation of Sid");
        }
        List sidIds = this.jdbcTemplate.queryForList(this.selectSidPrimaryKey, new Object[]{new Boolean(principal), sidName}, class$java$lang$Long == null ? (class$java$lang$Long = JdbcMutableAclService.class$("java.lang.Long")) : class$java$lang$Long);
        Long sidId = null;
        if (sidIds.isEmpty()) {
            if (allowCreate) {
                sidId = null;
                this.jdbcTemplate.update(this.insertSid, new Object[]{new Boolean(principal), sidName});
                Assert.isTrue((boolean)TransactionSynchronizationManager.isSynchronizationActive(), (String)"Transaction must be running");
                sidId = new Long(this.jdbcTemplate.queryForLong(this.identityQuery));
            }
        } else {
            sidId = (Long)sidIds.iterator().next();
        }
        return sidId;
    }

    public void deleteAcl(ObjectIdentity objectIdentity, boolean deleteChildren) throws ChildrenExistException {
        Assert.notNull((Object)objectIdentity, (String)"Object Identity required");
        Assert.notNull((Object)objectIdentity.getIdentifier(), (String)"Object Identity doesn't provide an identifier");
        ObjectIdentity[] children = this.findChildren(objectIdentity);
        if (deleteChildren) {
            for (int i = 0; i < children.length; ++i) {
                this.deleteAcl(children[i], true);
            }
        } else if (children.length > 0) {
            throw new ChildrenExistException("Cannot delete '" + objectIdentity + "' (has " + children.length + " children)");
        }
        this.deleteEntries(objectIdentity);
        this.deleteObjectIdentityAndOptionallyClass(objectIdentity);
        this.aclCache.evictFromCache(objectIdentity);
    }

    protected void deleteEntries(ObjectIdentity oid) {
        this.jdbcTemplate.update(this.deleteEntryByObjectIdentityForeignKey, new Object[]{this.retrieveObjectIdentityPrimaryKey(oid)});
    }

    protected void deleteObjectIdentityAndOptionallyClass(ObjectIdentity oid) {
        this.jdbcTemplate.update(this.deleteObjectIdentityByPrimaryKey, new Object[]{this.retrieveObjectIdentityPrimaryKey(oid)});
        Object[] className = new Object[]{oid.getJavaType().getName()};
        long numObjectIdentities = this.jdbcTemplate.queryForLong(this.selectCountObjectIdentityRowsForParticularClassNameString, className);
        if (numObjectIdentities == 0L) {
            this.jdbcTemplate.update(this.deleteClassByClassNameString, className);
        }
    }

    protected Long retrieveObjectIdentityPrimaryKey(ObjectIdentity oid) {
        try {
            return new Long(this.jdbcTemplate.queryForLong(this.selectObjectIdentityPrimaryKey, new Object[]{oid.getJavaType().getName(), oid.getIdentifier()}));
        }
        catch (DataAccessException notFound) {
            return null;
        }
    }

    public MutableAcl updateAcl(MutableAcl acl) throws NotFoundException {
        Assert.notNull((Object)acl.getId(), (String)"Object Identity doesn't provide an identifier");
        this.deleteEntries(acl.getObjectIdentity());
        this.createEntries(acl);
        this.updateObjectIdentity(acl);
        this.aclCache.evictFromCache(acl.getObjectIdentity());
        return (MutableAcl)super.readAclById(acl.getObjectIdentity());
    }

    protected void updateObjectIdentity(MutableAcl acl) {
        Long parentId = null;
        if (acl.getParentAcl() != null) {
            Assert.isInstanceOf((Class)(class$org$acegisecurity$acls$objectidentity$ObjectIdentityImpl == null ? (class$org$acegisecurity$acls$objectidentity$ObjectIdentityImpl = JdbcMutableAclService.class$("org.acegisecurity.acls.objectidentity.ObjectIdentityImpl")) : class$org$acegisecurity$acls$objectidentity$ObjectIdentityImpl), (Object)acl.getParentAcl().getObjectIdentity(), (String)"Implementation only supports ObjectIdentityImpl");
            ObjectIdentityImpl oii = (ObjectIdentityImpl)acl.getParentAcl().getObjectIdentity();
            parentId = this.retrieveObjectIdentityPrimaryKey(oii);
        }
        Assert.notNull((Object)acl.getOwner(), (String)"Owner is required in this implementation");
        Long ownerSid = this.createOrRetrieveSidPrimaryKey(acl.getOwner(), true);
        int count = this.jdbcTemplate.update(this.updateObjectIdentity, new Object[]{parentId, ownerSid, new Boolean(acl.isEntriesInheriting()), acl.getId()});
        if (count != 1) {
            throw new NotFoundException("Unable to locate ACL to update");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

