/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.afterinvocation;

import java.util.Collection;
import java.util.Iterator;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthorizationServiceException;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.acls.AclService;
import org.acegisecurity.acls.Permission;
import org.acegisecurity.afterinvocation.AbstractAclProvider;
import org.acegisecurity.afterinvocation.ArrayFilterer;
import org.acegisecurity.afterinvocation.CollectionFilterer;
import org.acegisecurity.afterinvocation.Filterer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AclEntryAfterInvocationCollectionFilteringProvider
extends AbstractAclProvider {
    protected static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$afterinvocation$AclEntryAfterInvocationCollectionFilteringProvider == null ? (class$org$acegisecurity$afterinvocation$AclEntryAfterInvocationCollectionFilteringProvider = AclEntryAfterInvocationCollectionFilteringProvider.class$("org.acegisecurity.afterinvocation.AclEntryAfterInvocationCollectionFilteringProvider")) : class$org$acegisecurity$afterinvocation$AclEntryAfterInvocationCollectionFilteringProvider));
    static /* synthetic */ Class class$org$acegisecurity$afterinvocation$AclEntryAfterInvocationCollectionFilteringProvider;

    public AclEntryAfterInvocationCollectionFilteringProvider(AclService aclService, Permission[] requirePermission) {
        super(aclService, "AFTER_ACL_COLLECTION_READ", requirePermission);
    }

    public Object decide(Authentication authentication, Object object, ConfigAttributeDefinition config, Object returnedObject) throws AccessDeniedException {
        Iterator iter = config.getConfigAttributes();
        while (iter.hasNext()) {
            ConfigAttribute attr = (ConfigAttribute)iter.next();
            if (!this.supports(attr)) continue;
            if (returnedObject == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Return object is null, skipping");
                }
                return null;
            }
            Filterer filterer = null;
            if (returnedObject instanceof Collection) {
                Collection collection = (Collection)returnedObject;
                filterer = new CollectionFilterer(collection);
            } else if (returnedObject.getClass().isArray()) {
                Object[] array = (Object[])returnedObject;
                filterer = new ArrayFilterer(array);
            } else {
                throw new AuthorizationServiceException("A Collection or an array (or null) was required as the returnedObject, but the returnedObject was: " + returnedObject);
            }
            Iterator collectionIter = filterer.iterator();
            while (collectionIter.hasNext()) {
                Object domainObject = collectionIter.next();
                boolean hasPermission = false;
                if (domainObject == null) {
                    hasPermission = true;
                    continue;
                }
                if (!this.getProcessDomainObjectClass().isAssignableFrom(domainObject.getClass())) {
                    hasPermission = true;
                    continue;
                }
                hasPermission = this.hasPermission(authentication, domainObject);
                if (hasPermission) continue;
                filterer.remove(domainObject);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Principal is NOT authorised for element: " + domainObject));
            }
            return filterer.getFilteredObject();
        }
        return returnedObject;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

