/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.cas;

import org.acegisecurity.AcegiMessageSource;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.providers.AuthenticationProvider;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.cas.CasAuthenticationToken;
import org.acegisecurity.providers.cas.CasAuthoritiesPopulator;
import org.acegisecurity.providers.cas.CasProxyDecider;
import org.acegisecurity.providers.cas.StatelessTicketCache;
import org.acegisecurity.providers.cas.TicketResponse;
import org.acegisecurity.providers.cas.TicketValidator;
import org.acegisecurity.userdetails.UserDetails;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.util.Assert;

public class CasAuthenticationProvider
implements AuthenticationProvider,
InitializingBean,
MessageSourceAware {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$providers$cas$CasAuthenticationProvider == null ? (class$org$acegisecurity$providers$cas$CasAuthenticationProvider = CasAuthenticationProvider.class$("org.acegisecurity.providers.cas.CasAuthenticationProvider")) : class$org$acegisecurity$providers$cas$CasAuthenticationProvider));
    private CasAuthoritiesPopulator casAuthoritiesPopulator;
    private CasProxyDecider casProxyDecider;
    protected MessageSourceAccessor messages = AcegiMessageSource.getAccessor();
    private StatelessTicketCache statelessTicketCache;
    private String key;
    private TicketValidator ticketValidator;
    static /* synthetic */ Class class$org$acegisecurity$providers$cas$CasAuthenticationProvider;
    static /* synthetic */ Class class$org$acegisecurity$providers$UsernamePasswordAuthenticationToken;
    static /* synthetic */ Class class$org$acegisecurity$providers$cas$CasAuthenticationToken;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.casAuthoritiesPopulator, (String)"A casAuthoritiesPopulator must be set");
        Assert.notNull((Object)this.ticketValidator, (String)"A ticketValidator must be set");
        Assert.notNull((Object)this.casProxyDecider, (String)"A casProxyDecider must be set");
        Assert.notNull((Object)this.statelessTicketCache, (String)"A statelessTicketCache must be set");
        Assert.hasText((String)this.key, (String)"A Key is required so CasAuthenticationProvider can identify tokens it previously authenticated");
        Assert.notNull((Object)this.messages, (String)"A message source must be set");
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (!this.supports(authentication.getClass())) {
            return null;
        }
        if (authentication instanceof UsernamePasswordAuthenticationToken && !"_cas_stateful_".equals(authentication.getPrincipal().toString()) && !"_cas_stateless_".equals(authentication.getPrincipal().toString())) {
            return null;
        }
        if (authentication instanceof CasAuthenticationToken) {
            if (this.key.hashCode() == ((CasAuthenticationToken)authentication).getKeyHash()) {
                return authentication;
            }
            throw new BadCredentialsException(this.messages.getMessage("CasAuthenticationProvider.incorrectKey", "The presented CasAuthenticationToken does not contain the expected key"));
        }
        if (authentication.getCredentials() == null || "".equals(authentication.getCredentials())) {
            throw new BadCredentialsException(this.messages.getMessage("CasAuthenticationProvider.noServiceTicket", "Failed to provide a CAS service ticket to validate"));
        }
        boolean stateless = false;
        if (authentication instanceof UsernamePasswordAuthenticationToken && "_cas_stateless_".equals(authentication.getPrincipal())) {
            stateless = true;
        }
        CasAuthenticationToken result = null;
        if (stateless) {
            result = this.statelessTicketCache.getByTicketId(authentication.getCredentials().toString());
        }
        if (result == null) {
            result = this.authenticateNow(authentication);
        }
        if (stateless) {
            this.statelessTicketCache.putTicketInCache(result);
        }
        return result;
    }

    private CasAuthenticationToken authenticateNow(Authentication authentication) throws AuthenticationException {
        TicketResponse response = this.ticketValidator.confirmTicketValid(authentication.getCredentials().toString());
        this.casProxyDecider.confirmProxyListTrusted(response.getProxyList());
        UserDetails userDetails = this.casAuthoritiesPopulator.getUserDetails(response.getUser());
        return new CasAuthenticationToken(this.key, userDetails, authentication.getCredentials(), userDetails.getAuthorities(), userDetails, response.getProxyList(), response.getProxyGrantingTicketIou());
    }

    public CasAuthoritiesPopulator getCasAuthoritiesPopulator() {
        return this.casAuthoritiesPopulator;
    }

    public CasProxyDecider getCasProxyDecider() {
        return this.casProxyDecider;
    }

    public String getKey() {
        return this.key;
    }

    public StatelessTicketCache getStatelessTicketCache() {
        return this.statelessTicketCache;
    }

    public TicketValidator getTicketValidator() {
        return this.ticketValidator;
    }

    public void setCasAuthoritiesPopulator(CasAuthoritiesPopulator casAuthoritiesPopulator) {
        this.casAuthoritiesPopulator = casAuthoritiesPopulator;
    }

    public void setCasProxyDecider(CasProxyDecider casProxyDecider) {
        this.casProxyDecider = casProxyDecider;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messages = new MessageSourceAccessor(messageSource);
    }

    public void setStatelessTicketCache(StatelessTicketCache statelessTicketCache) {
        this.statelessTicketCache = statelessTicketCache;
    }

    public void setTicketValidator(TicketValidator ticketValidator) {
        this.ticketValidator = ticketValidator;
    }

    public boolean supports(Class authentication) {
        if ((class$org$acegisecurity$providers$UsernamePasswordAuthenticationToken == null ? (class$org$acegisecurity$providers$UsernamePasswordAuthenticationToken = CasAuthenticationProvider.class$("org.acegisecurity.providers.UsernamePasswordAuthenticationToken")) : class$org$acegisecurity$providers$UsernamePasswordAuthenticationToken).isAssignableFrom(authentication)) {
            return true;
        }
        return (class$org$acegisecurity$providers$cas$CasAuthenticationToken == null ? (class$org$acegisecurity$providers$cas$CasAuthenticationToken = CasAuthenticationProvider.class$("org.acegisecurity.providers.cas.CasAuthenticationToken")) : class$org$acegisecurity$providers$cas$CasAuthenticationToken).isAssignableFrom(authentication);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

