/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity;

import junit.framework.TestCase;
import org.acegisecurity.AbstractAuthenticationManager;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.providers.TestingAuthenticationToken;

public class AbstractAuthenticationManagerTests
extends TestCase {
    public AbstractAuthenticationManagerTests() {
    }

    public AbstractAuthenticationManagerTests(String arg0) {
        super(arg0);
    }

    private AuthenticationManager createAuthenticationManager(final Object resultDetails) {
        return new AbstractAuthenticationManager(){

            protected Authentication doAuthentication(Authentication authentication) throws AuthenticationException {
                TestingAuthenticationToken token = AbstractAuthenticationManagerTests.this.createAuthenticationToken();
                token.setDetails(resultDetails);
                return token;
            }
        };
    }

    private TestingAuthenticationToken createAuthenticationToken() {
        return new TestingAuthenticationToken((Object)"name", (Object)"password", (GrantedAuthority[])new GrantedAuthorityImpl[0]);
    }

    public void testDetailsAreNotSetOnAuthenticationTokenIfAlreadySetByProvider() {
        String requestDetails = new String("(Request Details)");
        String resultDetails = new String("(Result Details)");
        AuthenticationManager authMgr = this.createAuthenticationManager(resultDetails);
        TestingAuthenticationToken request = this.createAuthenticationToken();
        request.setDetails((Object)requestDetails);
        Authentication result = authMgr.authenticate((Authentication)request);
        AbstractAuthenticationManagerTests.assertEquals((Object)resultDetails, (Object)result.getDetails());
    }

    public void testDetailsAreSetOnAuthenticationTokenIfNotAlreadySetByProvider() {
        AuthenticationManager authMgr = this.createAuthenticationManager(null);
        Object details = new Object();
        TestingAuthenticationToken request = this.createAuthenticationToken();
        request.setDetails(details);
        Authentication result = authMgr.authenticate((Authentication)request);
        AbstractAuthenticationManagerTests.assertEquals((Object)details, (Object)result.getDetails());
    }
}

