/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity;

import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.ConfigAttributeEditor;
import org.acegisecurity.SecurityConfig;

public class ConfigAttributeEditorTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$ConfigAttributeEditorTests;

    public ConfigAttributeEditorTests() {
    }

    public ConfigAttributeEditorTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$ConfigAttributeEditorTests == null ? (class$org$acegisecurity$ConfigAttributeEditorTests = ConfigAttributeEditorTests.class$("org.acegisecurity.ConfigAttributeEditorTests")) : class$org$acegisecurity$ConfigAttributeEditorTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testCorrectOperation() {
        ConfigAttributeEditor editor = new ConfigAttributeEditor();
        editor.setAsText("HELLO,DOCTOR,NAME,YESTERDAY,TOMORROW");
        ConfigAttributeDefinition result = (ConfigAttributeDefinition)editor.getValue();
        Iterator iter = result.getConfigAttributes();
        int position = 0;
        while (iter.hasNext()) {
            ++position;
            iter.next();
        }
        ConfigAttributeEditorTests.assertEquals((int)5, (int)position);
        ConfigAttributeEditorTests.assertEquals((int)5, (int)result.size());
        ConfigAttributeEditorTests.assertTrue((boolean)result.contains((ConfigAttribute)new SecurityConfig("HELLO")));
        ConfigAttributeEditorTests.assertTrue((boolean)result.contains((ConfigAttribute)new SecurityConfig("TOMORROW")));
        ConfigAttributeEditorTests.assertFalse((boolean)result.contains((ConfigAttribute)new SecurityConfig("FOOBAR")));
    }

    public void testEmptyStringReturnsNull() {
        ConfigAttributeEditor editor = new ConfigAttributeEditor();
        editor.setAsText("");
        ConfigAttributeDefinition result = (ConfigAttributeDefinition)editor.getValue();
        ConfigAttributeEditorTests.assertTrue((result == null ? 1 : 0) != 0);
    }

    public void testEqualsHandlingWhenDifferentObjectTypes() {
        ConfigAttributeDefinition def1 = new ConfigAttributeDefinition();
        def1.addConfigAttribute((ConfigAttribute)new SecurityConfig("A"));
        def1.addConfigAttribute((ConfigAttribute)new SecurityConfig("B"));
        ConfigAttributeEditorTests.assertTrue((!def1.equals((Object)"A_STRING") ? 1 : 0) != 0);
    }

    public void testEqualsHandlingWhenExactlyEqual() {
        ConfigAttributeDefinition def1 = new ConfigAttributeDefinition();
        def1.addConfigAttribute((ConfigAttribute)new SecurityConfig("A"));
        def1.addConfigAttribute((ConfigAttribute)new SecurityConfig("B"));
        ConfigAttributeDefinition def2 = new ConfigAttributeDefinition();
        def2.addConfigAttribute((ConfigAttribute)new SecurityConfig("A"));
        def2.addConfigAttribute((ConfigAttribute)new SecurityConfig("B"));
        ConfigAttributeEditorTests.assertEquals((Object)def1, (Object)def2);
    }

    public void testEqualsHandlingWhenOrderingNotEqual() {
        ConfigAttributeDefinition def1 = new ConfigAttributeDefinition();
        def1.addConfigAttribute((ConfigAttribute)new SecurityConfig("A"));
        def1.addConfigAttribute((ConfigAttribute)new SecurityConfig("B"));
        ConfigAttributeDefinition def2 = new ConfigAttributeDefinition();
        def2.addConfigAttribute((ConfigAttribute)new SecurityConfig("B"));
        def2.addConfigAttribute((ConfigAttribute)new SecurityConfig("A"));
        ConfigAttributeEditorTests.assertTrue((!def1.equals((Object)def2) ? 1 : 0) != 0);
    }

    public void testEqualsHandlingWhenTestObjectHasNoAttributes() {
        ConfigAttributeDefinition def1 = new ConfigAttributeDefinition();
        def1.addConfigAttribute((ConfigAttribute)new SecurityConfig("A"));
        def1.addConfigAttribute((ConfigAttribute)new SecurityConfig("B"));
        ConfigAttributeDefinition def2 = new ConfigAttributeDefinition();
        ConfigAttributeEditorTests.assertTrue((!def1.equals((Object)def2) ? 1 : 0) != 0);
        ConfigAttributeEditorTests.assertTrue((!def2.equals((Object)def1) ? 1 : 0) != 0);
    }

    public void testNullReturnsNull() {
        ConfigAttributeEditor editor = new ConfigAttributeEditor();
        editor.setAsText(null);
        ConfigAttributeDefinition result = (ConfigAttributeDefinition)editor.getValue();
        ConfigAttributeEditorTests.assertTrue((result == null ? 1 : 0) != 0);
    }

    public void testStripsTrailingAndLeadingSpaces() {
        ConfigAttributeEditor editor = new ConfigAttributeEditor();
        editor.setAsText("  HELLO, DOCTOR,NAME,  YESTERDAY ,TOMORROW ");
        ConfigAttributeDefinition result = (ConfigAttributeDefinition)editor.getValue();
        Iterator iter = result.getConfigAttributes();
        ArrayList list = new ArrayList();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        ConfigAttributeEditorTests.assertEquals((String)"HELLO", (String)((ConfigAttribute)list.get(0)).getAttribute());
        ConfigAttributeEditorTests.assertEquals((String)"DOCTOR", (String)((ConfigAttribute)list.get(1)).getAttribute());
        ConfigAttributeEditorTests.assertEquals((String)"NAME", (String)((ConfigAttribute)list.get(2)).getAttribute());
        ConfigAttributeEditorTests.assertEquals((String)"YESTERDAY", (String)((ConfigAttribute)list.get(3)).getAttribute());
        ConfigAttributeEditorTests.assertEquals((String)"TOMORROW", (String)((ConfigAttribute)list.get(4)).getAttribute());
    }

    public void testToString() {
        ConfigAttributeEditor editor = new ConfigAttributeEditor();
        editor.setAsText("KOALA,KANGAROO,EMU,WOMBAT");
        ConfigAttributeDefinition result = (ConfigAttributeDefinition)editor.getValue();
        ConfigAttributeEditorTests.assertEquals((String)"[KOALA, KANGAROO, EMU, WOMBAT]", (String)result.toString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

