/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity;

import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

public class PopulatedDatabase {
    private static DriverManagerDataSource dataSource = null;

    private PopulatedDatabase() {
    }

    public static DataSource getDataSource() {
        if (dataSource == null) {
            PopulatedDatabase.setupDataSource();
        }
        return dataSource;
    }

    private static void setupDataSource() {
        dataSource = new DriverManagerDataSource();
        dataSource.setDriverClassName("org.hsqldb.jdbcDriver");
        dataSource.setUrl("jdbc:hsqldb:mem:acegisecuritytest");
        dataSource.setUsername("sa");
        dataSource.setPassword("");
        JdbcTemplate template = new JdbcTemplate((DataSource)dataSource);
        template.execute("CREATE TABLE USERS(USERNAME VARCHAR_IGNORECASE(50) NOT NULL PRIMARY KEY,PASSWORD VARCHAR_IGNORECASE(50) NOT NULL,ENABLED BOOLEAN NOT NULL)");
        template.execute("CREATE TABLE AUTHORITIES(USERNAME VARCHAR_IGNORECASE(50) NOT NULL,AUTHORITY VARCHAR_IGNORECASE(50) NOT NULL,CONSTRAINT FK_AUTHORITIES_USERS FOREIGN KEY(USERNAME) REFERENCES USERS(USERNAME))");
        template.execute("CREATE UNIQUE INDEX IX_AUTH_USERNAME ON AUTHORITIES(USERNAME,AUTHORITY)");
        template.execute("CREATE TABLE ACL_OBJECT_IDENTITY(ID BIGINT GENERATED BY DEFAULT AS IDENTITY(START WITH 0)  NOT NULL PRIMARY KEY,OBJECT_IDENTITY VARCHAR_IGNORECASE(250) NOT NULL,PARENT_OBJECT BIGINT,ACL_CLASS VARCHAR_IGNORECASE(250) NOT NULL,CONSTRAINT UNIQUE_OBJECT_IDENTITY UNIQUE(OBJECT_IDENTITY),CONSTRAINT SYS_FK_3 FOREIGN KEY(PARENT_OBJECT) REFERENCES ACL_OBJECT_IDENTITY(ID))");
        template.execute("CREATE TABLE ACL_PERMISSION(ID BIGINT GENERATED BY DEFAULT AS IDENTITY(START WITH 0)  NOT NULL PRIMARY KEY,ACL_OBJECT_IDENTITY BIGINT NOT NULL,RECIPIENT VARCHAR_IGNORECASE(100) NOT NULL,MASK INTEGER NOT NULL,CONSTRAINT UNIQUE_RECIPIENT UNIQUE(ACL_OBJECT_IDENTITY,RECIPIENT),CONSTRAINT SYS_FK_7 FOREIGN KEY(ACL_OBJECT_IDENTITY) REFERENCES ACL_OBJECT_IDENTITY(ID))");
        template.execute("SET IGNORECASE TRUE");
        template.execute("INSERT INTO USERS VALUES('dianne','emu',TRUE)");
        template.execute("INSERT INTO USERS VALUES('marissa','koala',TRUE)");
        template.execute("INSERT INTO USERS VALUES('peter','opal',FALSE)");
        template.execute("INSERT INTO USERS VALUES('scott','wombat',TRUE)");
        template.execute("INSERT INTO USERS VALUES('cooper','kookaburra',TRUE)");
        template.execute("INSERT INTO AUTHORITIES VALUES('marissa','ROLE_TELLER')");
        template.execute("INSERT INTO AUTHORITIES VALUES('marissa','ROLE_SUPERVISOR')");
        template.execute("INSERT INTO AUTHORITIES VALUES('dianne','ROLE_TELLER')");
        template.execute("INSERT INTO AUTHORITIES VALUES('scott','ROLE_TELLER')");
        template.execute("INSERT INTO AUTHORITIES VALUES('peter','ROLE_TELLER')");
        template.execute("INSERT INTO acl_object_identity VALUES (1, 'org.acegisecurity.acl.DomainObject:1', null, 'org.acegisecurity.acl.basic.SimpleAclEntry');");
        template.execute("INSERT INTO acl_object_identity VALUES (2, 'org.acegisecurity.acl.DomainObject:2', 1, 'org.acegisecurity.acl.basic.SimpleAclEntry');");
        template.execute("INSERT INTO acl_object_identity VALUES (3, 'org.acegisecurity.acl.DomainObject:3', 1, 'org.acegisecurity.acl.basic.SimpleAclEntry');");
        template.execute("INSERT INTO acl_object_identity VALUES (4, 'org.acegisecurity.acl.DomainObject:4', 1, 'org.acegisecurity.acl.basic.SimpleAclEntry');");
        template.execute("INSERT INTO acl_object_identity VALUES (5, 'org.acegisecurity.acl.DomainObject:5', 3, 'org.acegisecurity.acl.basic.SimpleAclEntry');");
        template.execute("INSERT INTO acl_object_identity VALUES (6, 'org.acegisecurity.acl.DomainObject:6', 3, 'org.acegisecurity.acl.basic.SimpleAclEntry');");
        template.execute("INSERT INTO acl_object_identity VALUES (7, 'org.acegisecurity.acl.DomainObject:7', 3, 'some.invalid.acl.entry.class');");
        template.execute("INSERT INTO acl_permission VALUES (null, 1, 'ROLE_SUPERVISOR', 1);");
        template.execute("INSERT INTO acl_permission VALUES (null, 2, 'ROLE_SUPERVISOR', 0);");
        template.execute("INSERT INTO acl_permission VALUES (null, 2, 'marissa', 2);");
        template.execute("INSERT INTO acl_permission VALUES (null, 3, 'scott', 14);");
        template.execute("INSERT INTO acl_permission VALUES (null, 6, 'scott', 1);");
    }
}

