/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.acl;

import java.util.Vector;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.acl.AclEntry;
import org.acegisecurity.acl.AclProvider;
import org.acegisecurity.acl.AclProviderManager;
import org.acegisecurity.acl.basic.AclObjectIdentity;
import org.acegisecurity.acl.basic.NamedEntityObjectIdentity;
import org.acegisecurity.acl.basic.SimpleAclEntry;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;

public class AclProviderManagerTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$acl$AclProviderManagerTests;

    public AclProviderManagerTests() {
    }

    public AclProviderManagerTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$acl$AclProviderManagerTests == null ? (class$org$acegisecurity$acl$AclProviderManagerTests = AclProviderManagerTests.class$("org.acegisecurity.acl.AclProviderManagerTests")) : class$org$acegisecurity$acl$AclProviderManagerTests));
    }

    private AclProviderManager makeProviderManager() {
        MockProvider provider1 = new MockProvider();
        Vector<MockProvider> providers = new Vector<MockProvider>();
        providers.add(provider1);
        AclProviderManager mgr = new AclProviderManager();
        mgr.setProviders(providers);
        return mgr;
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testAclLookupFails() {
        AclProviderManager mgr = this.makeProviderManager();
        AclProviderManagerTests.assertNull((Object)mgr.getAcls((Object)new Integer(5)));
    }

    public void testAclLookupForGivenAuthenticationSuccess() {
        AclProviderManager mgr = this.makeProviderManager();
        AclProviderManagerTests.assertNotNull((Object)mgr.getAcls((Object)"STRING", (Authentication)new UsernamePasswordAuthenticationToken((Object)"marissa", (Object)"not used")));
    }

    public void testAclLookupSuccess() {
        AclProviderManager mgr = this.makeProviderManager();
        AclProviderManagerTests.assertNotNull((Object)mgr.getAcls((Object)"STRING"));
    }

    public void testRejectsNulls() {
        AclProviderManager mgr = new AclProviderManager();
        try {
            mgr.getAcls(null);
            AclProviderManagerTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AclProviderManagerTests.assertTrue((boolean)true);
        }
        try {
            mgr.getAcls(null, (Authentication)new UsernamePasswordAuthenticationToken((Object)"marissa", (Object)"not used"));
            AclProviderManagerTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AclProviderManagerTests.assertTrue((boolean)true);
        }
        try {
            mgr.getAcls((Object)"SOME_DOMAIN_INSTANCE", null);
            AclProviderManagerTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AclProviderManagerTests.assertTrue((boolean)true);
        }
    }

    public void testReturnsNullIfNoSupportingProvider() {
        AclProviderManager mgr = this.makeProviderManager();
        AclProviderManagerTests.assertNull((Object)mgr.getAcls((Object)new Integer(4), (Authentication)new UsernamePasswordAuthenticationToken((Object)"marissa", (Object)"not used")));
        AclProviderManagerTests.assertNull((Object)mgr.getAcls((Object)new Integer(4)));
    }

    public void testStartupFailsIfProviderListNotContainingProviders() throws Exception {
        Vector<String> providers = new Vector<String>();
        providers.add("THIS_IS_NOT_A_PROVIDER");
        AclProviderManager mgr = new AclProviderManager();
        try {
            mgr.setProviders(providers);
            AclProviderManagerTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AclProviderManagerTests.assertTrue((boolean)true);
        }
    }

    public void testStartupFailsIfProviderListNotSet() throws Exception {
        AclProviderManager mgr = new AclProviderManager();
        try {
            mgr.afterPropertiesSet();
            AclProviderManagerTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AclProviderManagerTests.assertTrue((boolean)true);
        }
    }

    public void testStartupFailsIfProviderListNull() throws Exception {
        AclProviderManager mgr = new AclProviderManager();
        try {
            mgr.setProviders(null);
            AclProviderManagerTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AclProviderManagerTests.assertTrue((boolean)true);
        }
    }

    public void testSuccessfulStartup() throws Exception {
        AclProviderManager mgr = this.makeProviderManager();
        mgr.afterPropertiesSet();
        AclProviderManagerTests.assertTrue((boolean)true);
        AclProviderManagerTests.assertEquals((int)1, (int)mgr.getProviders().size());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MockProvider
    implements AclProvider {
        private UsernamePasswordAuthenticationToken marissa = new UsernamePasswordAuthenticationToken((Object)"marissa", (Object)"not used", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_FOO"), new GrantedAuthorityImpl("ROLE_BAR")});
        private SimpleAclEntry entry100Marissa = new SimpleAclEntry(this.marissa.getPrincipal(), (AclObjectIdentity)new NamedEntityObjectIdentity("OBJECT", "100"), null, 2);
        private UsernamePasswordAuthenticationToken scott = new UsernamePasswordAuthenticationToken((Object)"scott", (Object)"not used", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_FOO"), new GrantedAuthorityImpl("ROLE_MANAGER")});
        private SimpleAclEntry entry100Scott = new SimpleAclEntry(this.scott.getPrincipal(), (AclObjectIdentity)new NamedEntityObjectIdentity("OBJECT", "100"), null, 4);

        private MockProvider() {
        }

        public AclEntry[] getAcls(Object domainInstance, Authentication authentication) {
            if (authentication.getPrincipal().equals(this.scott.getPrincipal())) {
                return new AclEntry[]{this.entry100Scott};
            }
            if (authentication.getPrincipal().equals(this.marissa.getPrincipal())) {
                return new AclEntry[]{this.entry100Marissa};
            }
            return null;
        }

        public AclEntry[] getAcls(Object domainInstance) {
            return new AclEntry[]{this.entry100Marissa, this.entry100Scott};
        }

        public boolean supports(Object domainInstance) {
            return domainInstance instanceof String;
        }
    }
}

