/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.acl.basic;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.Authentication;
import org.acegisecurity.PopulatedDatabase;
import org.acegisecurity.acl.AclEntry;
import org.acegisecurity.acl.basic.AclObjectIdentity;
import org.acegisecurity.acl.basic.AclObjectIdentityAware;
import org.acegisecurity.acl.basic.BasicAclDao;
import org.acegisecurity.acl.basic.BasicAclEntry;
import org.acegisecurity.acl.basic.BasicAclEntryCache;
import org.acegisecurity.acl.basic.BasicAclProvider;
import org.acegisecurity.acl.basic.NamedEntityObjectIdentity;
import org.acegisecurity.acl.basic.SomeDomain;
import org.acegisecurity.acl.basic.cache.BasicAclEntryHolder;
import org.acegisecurity.acl.basic.jdbc.JdbcDaoImpl;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;

public class BasicAclProviderTests
extends TestCase {
    public static final String OBJECT_IDENTITY = "org.acegisecurity.acl.DomainObject";
    static /* synthetic */ Class class$org$acegisecurity$acl$basic$BasicAclProviderTests;
    static /* synthetic */ Class class$org$acegisecurity$acl$basic$cache$NullAclEntryCache;
    static /* synthetic */ Class class$org$acegisecurity$acl$basic$NamedEntityObjectIdentity;
    static /* synthetic */ Class class$org$acegisecurity$acl$basic$GrantedAuthorityEffectiveAclsResolver;
    static /* synthetic */ Class class$org$acegisecurity$acl$basic$SomeDomain;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$acegisecurity$acl$basic$MockAclObjectIdentity;

    public BasicAclProviderTests() {
    }

    public BasicAclProviderTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$acl$basic$BasicAclProviderTests == null ? (class$org$acegisecurity$acl$basic$BasicAclProviderTests = BasicAclProviderTests.class$("org.acegisecurity.acl.basic.BasicAclProviderTests")) : class$org$acegisecurity$acl$basic$BasicAclProviderTests));
    }

    private JdbcDaoImpl makePopulatedJdbcDao() throws Exception {
        JdbcDaoImpl dao = new JdbcDaoImpl();
        dao.setDataSource(PopulatedDatabase.getDataSource());
        dao.afterPropertiesSet();
        return dao;
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testCachingUsedProperly() throws Exception {
        BasicAclProvider provider = new BasicAclProvider();
        provider.setBasicAclDao((BasicAclDao)this.makePopulatedJdbcDao());
        MockCache cache = new MockCache();
        provider.setBasicAclEntryCache((BasicAclEntryCache)cache);
        BasicAclProviderTests.assertEquals((int)0, (int)cache.getGets());
        BasicAclProviderTests.assertEquals((int)0, (int)cache.getGetsHits());
        BasicAclProviderTests.assertEquals((int)0, (int)cache.getPuts());
        BasicAclProviderTests.assertEquals((int)0, (int)cache.getBackingMap().size());
        MockDomain object = new MockDomain(1);
        provider.getAcls((Object)object);
        BasicAclProviderTests.assertEquals((int)1, (int)cache.getGets());
        BasicAclProviderTests.assertEquals((int)0, (int)cache.getGetsHits());
        BasicAclProviderTests.assertEquals((int)1, (int)cache.getPuts());
        BasicAclProviderTests.assertEquals((int)1, (int)cache.getBackingMap().size());
        provider.getAcls((Object)object);
        BasicAclProviderTests.assertEquals((int)2, (int)cache.getGets());
        BasicAclProviderTests.assertEquals((int)1, (int)cache.getGetsHits());
        BasicAclProviderTests.assertEquals((int)1, (int)cache.getPuts());
        BasicAclProviderTests.assertEquals((int)1, (int)cache.getBackingMap().size());
        object = new MockDomain(1000);
        provider.getAcls((Object)object);
        BasicAclProviderTests.assertEquals((int)3, (int)cache.getGets());
        BasicAclProviderTests.assertEquals((int)1, (int)cache.getGetsHits());
        BasicAclProviderTests.assertEquals((int)2, (int)cache.getPuts());
        BasicAclProviderTests.assertEquals((int)2, (int)cache.getBackingMap().size());
        provider.getAcls((Object)object);
        BasicAclProviderTests.assertEquals((int)4, (int)cache.getGets());
        BasicAclProviderTests.assertEquals((int)2, (int)cache.getGetsHits());
        BasicAclProviderTests.assertEquals((int)2, (int)cache.getPuts());
        BasicAclProviderTests.assertEquals((int)2, (int)cache.getBackingMap().size());
        provider.getAcls((Object)object);
        BasicAclProviderTests.assertEquals((int)5, (int)cache.getGets());
        BasicAclProviderTests.assertEquals((int)3, (int)cache.getGetsHits());
        BasicAclProviderTests.assertEquals((int)2, (int)cache.getPuts());
        BasicAclProviderTests.assertEquals((int)2, (int)cache.getBackingMap().size());
    }

    public void testExceptionThrownIfUnsupportedObjectIsSubmitted() throws Exception {
        BasicAclProvider provider = new BasicAclProvider();
        provider.setBasicAclDao((BasicAclDao)this.makePopulatedJdbcDao());
        BasicAclProviderTests.assertFalse((boolean)provider.supports((Object)new Integer(34)));
        try {
            provider.getAcls((Object)new Integer(34));
            BasicAclProviderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            BasicAclProviderTests.assertTrue((boolean)true);
        }
    }

    public void testGetAclsForInstanceNotFound() throws Exception {
        BasicAclProvider provider = new BasicAclProvider();
        provider.setBasicAclDao((BasicAclDao)this.makePopulatedJdbcDao());
        MockDomain object = new MockDomain(546464646);
        AclEntry[] acls = provider.getAcls((Object)object);
        BasicAclProviderTests.assertNull((Object)acls);
    }

    public void testGetAclsForInstanceWithParentLevels() throws Exception {
        BasicAclProvider provider = new BasicAclProvider();
        provider.setBasicAclDao((BasicAclDao)this.makePopulatedJdbcDao());
        MockDomain object = new MockDomain(6);
        AclEntry[] acls = provider.getAcls((Object)object);
        BasicAclProviderTests.assertEquals((int)2, (int)acls.length);
        BasicAclProviderTests.assertEquals((Object)"scott", (Object)((BasicAclEntry)acls[0]).getRecipient());
        BasicAclProviderTests.assertEquals((int)1, (int)((BasicAclEntry)acls[0]).getMask());
        BasicAclProviderTests.assertEquals((Object)"ROLE_SUPERVISOR", (Object)((BasicAclEntry)acls[1]).getRecipient());
    }

    public void testGetAclsForInstanceWithParentLevelsButNoDirectAclsAgainstInstance() throws Exception {
        BasicAclProvider provider = new BasicAclProvider();
        provider.setBasicAclDao((BasicAclDao)this.makePopulatedJdbcDao());
        MockDomain object = new MockDomain(5);
        AclEntry[] acls = provider.getAcls((Object)object);
        BasicAclProviderTests.assertEquals((int)3, (int)acls.length);
        BasicAclProviderTests.assertEquals((Object)"scott", (Object)((BasicAclEntry)acls[0]).getRecipient());
        BasicAclProviderTests.assertEquals((int)14, (int)((BasicAclEntry)acls[0]).getMask());
        BasicAclProviderTests.assertEquals((Object)"ROLE_SUPERVISOR", (Object)((BasicAclEntry)acls[1]).getRecipient());
        BasicAclProviderTests.assertEquals((int)1, (int)((BasicAclEntry)acls[1]).getMask());
        BasicAclProviderTests.assertEquals((Object)"___INHERITENCE_MARKER_ONLY___", (Object)((BasicAclEntry)acls[2]).getRecipient());
    }

    public void testGetAclsWithAuthentication() throws Exception {
        BasicAclProvider provider = new BasicAclProvider();
        provider.setBasicAclDao((BasicAclDao)this.makePopulatedJdbcDao());
        UsernamePasswordAuthenticationToken scott = new UsernamePasswordAuthenticationToken((Object)"scott", (Object)"unused");
        MockDomain object = new MockDomain(6);
        AclEntry[] acls = provider.getAcls((Object)object, (Authentication)scott);
        BasicAclProviderTests.assertEquals((int)1, (int)acls.length);
        BasicAclProviderTests.assertEquals((Object)"scott", (Object)((BasicAclEntry)acls[0]).getRecipient());
    }

    public void testGettersSetters() {
        BasicAclProvider provider = new BasicAclProvider();
        BasicAclProviderTests.assertEquals((Object)(class$org$acegisecurity$acl$basic$cache$NullAclEntryCache == null ? (class$org$acegisecurity$acl$basic$cache$NullAclEntryCache = BasicAclProviderTests.class$("org.acegisecurity.acl.basic.cache.NullAclEntryCache")) : class$org$acegisecurity$acl$basic$cache$NullAclEntryCache), provider.getBasicAclEntryCache().getClass());
        BasicAclProviderTests.assertEquals((Object)(class$org$acegisecurity$acl$basic$NamedEntityObjectIdentity == null ? (class$org$acegisecurity$acl$basic$NamedEntityObjectIdentity = BasicAclProviderTests.class$("org.acegisecurity.acl.basic.NamedEntityObjectIdentity")) : class$org$acegisecurity$acl$basic$NamedEntityObjectIdentity), (Object)provider.getDefaultAclObjectIdentityClass());
        BasicAclProviderTests.assertEquals((Object)(class$org$acegisecurity$acl$basic$GrantedAuthorityEffectiveAclsResolver == null ? (class$org$acegisecurity$acl$basic$GrantedAuthorityEffectiveAclsResolver = BasicAclProviderTests.class$("org.acegisecurity.acl.basic.GrantedAuthorityEffectiveAclsResolver")) : class$org$acegisecurity$acl$basic$GrantedAuthorityEffectiveAclsResolver), provider.getEffectiveAclsResolver().getClass());
        provider.setBasicAclEntryCache(null);
        BasicAclProviderTests.assertNull((Object)provider.getBasicAclEntryCache());
        provider.setDefaultAclObjectIdentityClass(null);
        BasicAclProviderTests.assertNull((Object)provider.getDefaultAclObjectIdentityClass());
        provider.setEffectiveAclsResolver(null);
        BasicAclProviderTests.assertNull((Object)provider.getEffectiveAclsResolver());
        provider.setBasicAclDao((BasicAclDao)new MockDao());
        BasicAclProviderTests.assertNotNull((Object)provider.getBasicAclDao());
        BasicAclProviderTests.assertNull((Object)provider.getRestrictSupportToClass());
        provider.setRestrictSupportToClass(class$org$acegisecurity$acl$basic$SomeDomain == null ? (class$org$acegisecurity$acl$basic$SomeDomain = BasicAclProviderTests.class$("org.acegisecurity.acl.basic.SomeDomain")) : class$org$acegisecurity$acl$basic$SomeDomain);
        BasicAclProviderTests.assertEquals((Object)(class$org$acegisecurity$acl$basic$SomeDomain == null ? (class$org$acegisecurity$acl$basic$SomeDomain = BasicAclProviderTests.class$("org.acegisecurity.acl.basic.SomeDomain")) : class$org$acegisecurity$acl$basic$SomeDomain), (Object)provider.getRestrictSupportToClass());
    }

    public void testStartupFailsIfNullAclDao() throws Exception {
        BasicAclProvider provider = new BasicAclProvider();
        try {
            provider.afterPropertiesSet();
            BasicAclProviderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            BasicAclProviderTests.assertTrue((boolean)true);
        }
    }

    public void testStartupFailsIfNullEffectiveAclsResolver() throws Exception {
        BasicAclProvider provider = new BasicAclProvider();
        provider.setBasicAclDao((BasicAclDao)this.makePopulatedJdbcDao());
        provider.setEffectiveAclsResolver(null);
        try {
            provider.afterPropertiesSet();
            BasicAclProviderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            BasicAclProviderTests.assertTrue((boolean)true);
        }
    }

    public void testStartupFailsIfNullEntryCache() throws Exception {
        BasicAclProvider provider = new BasicAclProvider();
        provider.setBasicAclDao((BasicAclDao)this.makePopulatedJdbcDao());
        provider.setBasicAclEntryCache(null);
        try {
            provider.afterPropertiesSet();
            BasicAclProviderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            BasicAclProviderTests.assertTrue((boolean)true);
        }
    }

    public void testStartupFailsIfProblemWithAclObjectIdentityClass() throws Exception {
        BasicAclProvider provider = new BasicAclProvider();
        provider.setBasicAclDao((BasicAclDao)this.makePopulatedJdbcDao());
        provider.setDefaultAclObjectIdentityClass(null);
        try {
            provider.afterPropertiesSet();
            BasicAclProviderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            BasicAclProviderTests.assertTrue((boolean)true);
        }
        provider.setDefaultAclObjectIdentityClass(class$java$lang$String == null ? (class$java$lang$String = BasicAclProviderTests.class$("java.lang.String")) : class$java$lang$String);
        try {
            provider.afterPropertiesSet();
            BasicAclProviderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            BasicAclProviderTests.assertTrue((boolean)true);
        }
        provider.setDefaultAclObjectIdentityClass(class$org$acegisecurity$acl$basic$MockAclObjectIdentity == null ? (class$org$acegisecurity$acl$basic$MockAclObjectIdentity = BasicAclProviderTests.class$("org.acegisecurity.acl.basic.MockAclObjectIdentity")) : class$org$acegisecurity$acl$basic$MockAclObjectIdentity);
        try {
            provider.afterPropertiesSet();
            BasicAclProviderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            BasicAclProviderTests.assertEquals((String)"defaultAclObjectIdentityClass must provide a constructor that accepts the domain object instance!", (String)expected.getMessage());
        }
    }

    public void testSupports() throws Exception {
        BasicAclProvider provider = new BasicAclProvider();
        provider.setBasicAclDao((BasicAclDao)this.makePopulatedJdbcDao());
        BasicAclProviderTests.assertFalse((boolean)provider.supports((Object)new Integer(34)));
        BasicAclProviderTests.assertTrue((boolean)provider.supports((Object)new SomeDomain()));
        BasicAclProviderTests.assertTrue((boolean)provider.supports((Object)new MockDomain(4)));
        provider.setRestrictSupportToClass(class$org$acegisecurity$acl$basic$SomeDomain == null ? (class$org$acegisecurity$acl$basic$SomeDomain = BasicAclProviderTests.class$("org.acegisecurity.acl.basic.SomeDomain")) : class$org$acegisecurity$acl$basic$SomeDomain);
        BasicAclProviderTests.assertEquals((Object)(class$org$acegisecurity$acl$basic$SomeDomain == null ? (class$org$acegisecurity$acl$basic$SomeDomain = BasicAclProviderTests.class$("org.acegisecurity.acl.basic.SomeDomain")) : class$org$acegisecurity$acl$basic$SomeDomain), (Object)provider.getRestrictSupportToClass());
        BasicAclProviderTests.assertTrue((boolean)provider.supports((Object)new SomeDomain()));
        BasicAclProviderTests.assertFalse((boolean)provider.supports((Object)new MockDomain(4)));
    }

    public void testSupportsReturnsNullIfObjectNull() {
        BasicAclProvider provider = new BasicAclProvider();
        BasicAclProviderTests.assertFalse((boolean)provider.supports((Object)new Integer(34)));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MockDomain
    implements AclObjectIdentityAware {
        private int id;

        public MockDomain(int id) {
            this.id = id;
        }

        public AclObjectIdentity getAclObjectIdentity() {
            return new NamedEntityObjectIdentity(BasicAclProviderTests.OBJECT_IDENTITY, new Integer(this.id).toString());
        }
    }

    private class MockDao
    implements BasicAclDao {
        private MockDao() {
        }

        public BasicAclEntry[] getAcls(AclObjectIdentity aclObjectIdentity) {
            return null;
        }
    }

    private class MockCache
    implements BasicAclEntryCache {
        private Map map = new HashMap();
        private int gets = 0;
        private int getsHits = 0;
        private int puts = 0;

        private MockCache() {
        }

        public Map getBackingMap() {
            return this.map;
        }

        public BasicAclEntry[] getEntriesFromCache(AclObjectIdentity aclObjectIdentity) {
            ++this.gets;
            Object result = this.map.get(aclObjectIdentity);
            if (result == null) {
                return null;
            }
            ++this.getsHits;
            BasicAclEntryHolder holder = (BasicAclEntryHolder)result;
            return holder.getBasicAclEntries();
        }

        public int getGets() {
            return this.gets;
        }

        public int getGetsHits() {
            return this.getsHits;
        }

        public int getPuts() {
            return this.puts;
        }

        public void putEntriesInCache(BasicAclEntry[] basicAclEntry) {
            ++this.puts;
            BasicAclEntryHolder holder = new BasicAclEntryHolder(basicAclEntry);
            this.map.put(basicAclEntry[0].getAclObjectIdentity(), holder);
        }

        public void removeEntriesFromCache(AclObjectIdentity aclObjectIdentity) {
        }
    }
}

