/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.acl.basic;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.acl.basic.AclObjectIdentity;
import org.acegisecurity.acl.basic.NamedEntityObjectIdentity;
import org.acegisecurity.acl.basic.SimpleAclEntry;

public class SimpleAclEntryTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$acl$basic$SimpleAclEntryTests;
    static /* synthetic */ Class class$java$lang$IllegalArgumentException;

    public SimpleAclEntryTests() {
    }

    public SimpleAclEntryTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$acl$basic$SimpleAclEntryTests == null ? (class$org$acegisecurity$acl$basic$SimpleAclEntryTests = SimpleAclEntryTests.class$("org.acegisecurity.acl.basic.SimpleAclEntryTests")) : class$org$acegisecurity$acl$basic$SimpleAclEntryTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testCorrectOperation() {
        String recipient = "marissa";
        NamedEntityObjectIdentity objectIdentity = new NamedEntityObjectIdentity("domain", "12");
        SimpleAclEntry acl = new SimpleAclEntry((Object)recipient, (AclObjectIdentity)objectIdentity, null, 0);
        SimpleAclEntryTests.assertFalse((boolean)acl.isPermitted(SimpleAclEntry.ADMINISTRATION));
        acl.addPermission(SimpleAclEntry.ADMINISTRATION);
        SimpleAclEntryTests.assertTrue((boolean)acl.isPermitted(SimpleAclEntry.ADMINISTRATION));
        SimpleAclEntryTests.assertFalse((boolean)acl.isPermitted(SimpleAclEntry.CREATE));
        SimpleAclEntryTests.assertFalse((boolean)acl.isPermitted(SimpleAclEntry.DELETE));
        SimpleAclEntryTests.assertFalse((boolean)acl.isPermitted(SimpleAclEntry.READ));
        SimpleAclEntryTests.assertFalse((boolean)acl.isPermitted(SimpleAclEntry.WRITE));
        SimpleAclEntryTests.assertEquals((String)"A----", (String)acl.printPermissionsBlock());
        acl.deletePermission(SimpleAclEntry.ADMINISTRATION);
        SimpleAclEntryTests.assertFalse((boolean)acl.isPermitted(SimpleAclEntry.ADMINISTRATION));
        SimpleAclEntryTests.assertEquals((String)"-----", (String)acl.printPermissionsBlock());
        acl.addPermissions(new int[]{SimpleAclEntry.READ, SimpleAclEntry.WRITE});
        acl.addPermission(SimpleAclEntry.CREATE);
        SimpleAclEntryTests.assertFalse((boolean)acl.isPermitted(SimpleAclEntry.ADMINISTRATION));
        SimpleAclEntryTests.assertTrue((boolean)acl.isPermitted(SimpleAclEntry.CREATE));
        SimpleAclEntryTests.assertFalse((boolean)acl.isPermitted(SimpleAclEntry.DELETE));
        SimpleAclEntryTests.assertTrue((boolean)acl.isPermitted(SimpleAclEntry.READ));
        SimpleAclEntryTests.assertTrue((boolean)acl.isPermitted(SimpleAclEntry.WRITE));
        SimpleAclEntryTests.assertEquals((String)"-RWC-", (String)acl.printPermissionsBlock());
        acl.deletePermission(SimpleAclEntry.CREATE);
        acl.deletePermissions(new int[]{SimpleAclEntry.READ, SimpleAclEntry.WRITE});
        SimpleAclEntryTests.assertEquals((String)"-----", (String)acl.printPermissionsBlock());
        acl.togglePermission(SimpleAclEntry.CREATE);
        SimpleAclEntryTests.assertTrue((boolean)acl.isPermitted(SimpleAclEntry.CREATE));
        SimpleAclEntryTests.assertFalse((boolean)acl.isPermitted(SimpleAclEntry.ADMINISTRATION));
        acl.togglePermission(SimpleAclEntry.CREATE);
        SimpleAclEntryTests.assertFalse((boolean)acl.isPermitted(SimpleAclEntry.CREATE));
        acl.togglePermission(SimpleAclEntry.DELETE);
        SimpleAclEntryTests.assertTrue((boolean)acl.isPermitted(SimpleAclEntry.DELETE));
        SimpleAclEntryTests.assertEquals((String)"----D", (String)acl.printPermissionsBlock());
    }

    public void testDetectsNullOnMainConstructor() {
        String recipient = "marissa";
        NamedEntityObjectIdentity objectIdentity = new NamedEntityObjectIdentity("domain", "12");
        try {
            new SimpleAclEntry((Object)recipient, null, null, 2);
            SimpleAclEntryTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            SimpleAclEntryTests.assertTrue((boolean)true);
        }
        try {
            new SimpleAclEntry(null, (AclObjectIdentity)objectIdentity, null, 2);
            SimpleAclEntryTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            SimpleAclEntryTests.assertTrue((boolean)true);
        }
    }

    public void testGettersSetters() {
        SimpleAclEntry acl = new SimpleAclEntry();
        NamedEntityObjectIdentity objectIdentity = new NamedEntityObjectIdentity("domain", "693");
        acl.setAclObjectIdentity((AclObjectIdentity)objectIdentity);
        SimpleAclEntryTests.assertEquals((Object)objectIdentity, (Object)acl.getAclObjectIdentity());
        NamedEntityObjectIdentity parentObjectIdentity = new NamedEntityObjectIdentity("domain", "13");
        acl.setAclObjectParentIdentity((AclObjectIdentity)parentObjectIdentity);
        SimpleAclEntryTests.assertEquals((Object)parentObjectIdentity, (Object)acl.getAclObjectParentIdentity());
        acl.setMask(2);
        SimpleAclEntryTests.assertEquals((int)2, (int)acl.getMask());
        acl.setRecipient((Object)"scott");
        SimpleAclEntryTests.assertEquals((Object)"scott", (Object)acl.getRecipient());
    }

    public void testRejectsInvalidMasksInAddMethod() {
        String recipient = "marissa";
        NamedEntityObjectIdentity objectIdentity = new NamedEntityObjectIdentity("domain", "12");
        SimpleAclEntry acl = new SimpleAclEntry((Object)recipient, (AclObjectIdentity)objectIdentity, null, 4);
        try {
            acl.addPermission(Integer.MAX_VALUE);
            SimpleAclEntryTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            SimpleAclEntryTests.assertTrue((boolean)true);
        }
    }

    public void testRejectsInvalidMasksInDeleteMethod() {
        String recipient = "marissa";
        NamedEntityObjectIdentity objectIdentity = new NamedEntityObjectIdentity("domain", "12");
        SimpleAclEntry acl = new SimpleAclEntry((Object)recipient, (AclObjectIdentity)objectIdentity, null, 0);
        acl.addPermissions(new int[]{SimpleAclEntry.READ, SimpleAclEntry.WRITE, SimpleAclEntry.CREATE});
        try {
            acl.deletePermission(SimpleAclEntry.READ);
            SimpleAclEntryTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            SimpleAclEntryTests.assertTrue((boolean)true);
        }
    }

    public void testRejectsInvalidMasksInTogglePermissionMethod() {
        String recipient = "marissa";
        NamedEntityObjectIdentity objectIdentity = new NamedEntityObjectIdentity("domain", "12");
        SimpleAclEntry acl = new SimpleAclEntry((Object)recipient, (AclObjectIdentity)objectIdentity, null, 0);
        acl.addPermissions(new int[]{SimpleAclEntry.READ, SimpleAclEntry.WRITE, SimpleAclEntry.CREATE});
        try {
            acl.togglePermission(SimpleAclEntry.READ);
            SimpleAclEntryTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            SimpleAclEntryTests.assertTrue((boolean)true);
        }
    }

    public void testToString() {
        String recipient = "marissa";
        NamedEntityObjectIdentity objectIdentity = new NamedEntityObjectIdentity("domain", "12");
        SimpleAclEntry acl = new SimpleAclEntry((Object)recipient, (AclObjectIdentity)objectIdentity, null, 0);
        acl.addPermissions(new int[]{SimpleAclEntry.READ, SimpleAclEntry.WRITE, SimpleAclEntry.CREATE});
        SimpleAclEntryTests.assertTrue((boolean)acl.toString().endsWith("marissa=-RWC- ............................111. (14)]"));
    }

    public void testParsePermission() {
        this.assertPermission("NOTHING", 0);
        this.assertPermission("ADMINISTRATION", SimpleAclEntry.ADMINISTRATION);
        this.assertPermission("READ", SimpleAclEntry.READ);
        this.assertPermission("WRITE", SimpleAclEntry.WRITE);
        this.assertPermission("CREATE", SimpleAclEntry.CREATE);
        this.assertPermission("DELETE", SimpleAclEntry.DELETE);
        this.assertPermission("READ_WRITE_DELETE", SimpleAclEntry.READ_WRITE_DELETE);
    }

    public void testParsePermissionWrongValues() {
        try {
            SimpleAclEntry.parsePermission((String)"X");
            SimpleAclEntryTests.fail((String)((class$java$lang$IllegalArgumentException == null ? (class$java$lang$IllegalArgumentException = SimpleAclEntryTests.class$("java.lang.IllegalArgumentException")) : class$java$lang$IllegalArgumentException).getName() + " must have been thrown."));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void assertPermission(String permission, int value) {
        SimpleAclEntryTests.assertEquals((int)value, (int)SimpleAclEntry.parsePermission((String)permission));
    }

    public void testGetPermissions() {
        SimpleAclEntry acl = new SimpleAclEntry((Object)"", (AclObjectIdentity)new NamedEntityObjectIdentity("x", "x"), null, 0);
        int[] permissions = acl.getValidPermissions();
        int i = permissions[0];
        permissions[0] = permissions[0] - 100;
        SimpleAclEntryTests.assertEquals((String)"Value returned by getValidPermissions can be modified", (int)i, (int)acl.getValidPermissions()[0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

