/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.acls.jdbc;

import java.io.Serializable;
import java.util.Map;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.acls.AccessControlEntry;
import org.acegisecurity.acls.Acl;
import org.acegisecurity.acls.MutableAcl;
import org.acegisecurity.acls.NotFoundException;
import org.acegisecurity.acls.Permission;
import org.acegisecurity.acls.domain.BasePermission;
import org.acegisecurity.acls.jdbc.JdbcMutableAclService;
import org.acegisecurity.acls.objectidentity.ObjectIdentity;
import org.acegisecurity.acls.objectidentity.ObjectIdentityImpl;
import org.acegisecurity.acls.sid.PrincipalSid;
import org.acegisecurity.acls.sid.Sid;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.TestingAuthenticationToken;
import org.springframework.test.AbstractTransactionalDataSourceSpringContextTests;

public class JdbcAclServiceTests
extends AbstractTransactionalDataSourceSpringContextTests {
    private JdbcMutableAclService jdbcMutableAclService;

    protected String[] getConfigLocations() {
        return new String[]{"classpath:org/acegisecurity/acls/jdbc/applicationContext-test.xml"};
    }

    public void setJdbcMutableAclService(JdbcMutableAclService jdbcAclService) {
        this.jdbcMutableAclService = jdbcAclService;
    }

    public void testLifecycle() {
        this.setComplete();
        TestingAuthenticationToken auth = new TestingAuthenticationToken((Object)"ben", (Object)"ignored", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ADMINISTRATOR")});
        auth.setAuthenticated(true);
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        ObjectIdentityImpl topParentOid = new ObjectIdentityImpl("org.acegisecurity.TargetObject", (Serializable)new Long(100L));
        ObjectIdentityImpl middleParentOid = new ObjectIdentityImpl("org.acegisecurity.TargetObject", (Serializable)new Long(101L));
        ObjectIdentityImpl childOid = new ObjectIdentityImpl("org.acegisecurity.TargetObject", (Serializable)new Long(102L));
        MutableAcl topParent = this.jdbcMutableAclService.createAcl((ObjectIdentity)topParentOid);
        MutableAcl middleParent = this.jdbcMutableAclService.createAcl((ObjectIdentity)middleParentOid);
        MutableAcl child = this.jdbcMutableAclService.createAcl((ObjectIdentity)childOid);
        middleParent.setParent((Acl)topParent);
        child.setParent((Acl)middleParent);
        topParent.insertAce(null, BasePermission.READ, (Sid)new PrincipalSid((Authentication)auth), true);
        topParent.insertAce(null, BasePermission.WRITE, (Sid)new PrincipalSid((Authentication)auth), false);
        middleParent.insertAce(null, BasePermission.DELETE, (Sid)new PrincipalSid((Authentication)auth), true);
        child.insertAce(null, BasePermission.DELETE, (Sid)new PrincipalSid((Authentication)auth), false);
        this.jdbcMutableAclService.updateAcl(topParent);
        this.jdbcMutableAclService.updateAcl(middleParent);
        this.jdbcMutableAclService.updateAcl(child);
        Map map = this.jdbcMutableAclService.readAclsById(new ObjectIdentity[]{topParentOid, middleParentOid, childOid});
        JdbcAclServiceTests.assertEquals((int)3, (int)map.size());
        topParent = (MutableAcl)map.get(topParentOid);
        middleParent = (MutableAcl)map.get(middleParentOid);
        child = (MutableAcl)map.get(childOid);
        JdbcAclServiceTests.assertNotNull((Object)topParent.getId());
        JdbcAclServiceTests.assertNotNull((Object)middleParent.getId());
        JdbcAclServiceTests.assertNotNull((Object)child.getId());
        JdbcAclServiceTests.assertNull((Object)topParent.getParentAcl());
        JdbcAclServiceTests.assertEquals((Object)topParentOid, (Object)middleParent.getParentAcl().getObjectIdentity());
        JdbcAclServiceTests.assertEquals((Object)middleParentOid, (Object)child.getParentAcl().getObjectIdentity());
        JdbcAclServiceTests.assertEquals((int)2, (int)topParent.getEntries().length);
        JdbcAclServiceTests.assertEquals((int)1, (int)middleParent.getEntries().length);
        JdbcAclServiceTests.assertEquals((int)1, (int)child.getEntries().length);
        JdbcAclServiceTests.assertTrue((boolean)topParent.isGranted(new Permission[]{BasePermission.READ}, new Sid[]{new PrincipalSid((Authentication)auth)}, false));
        JdbcAclServiceTests.assertFalse((boolean)topParent.isGranted(new Permission[]{BasePermission.WRITE}, new Sid[]{new PrincipalSid((Authentication)auth)}, false));
        JdbcAclServiceTests.assertTrue((boolean)middleParent.isGranted(new Permission[]{BasePermission.DELETE}, new Sid[]{new PrincipalSid((Authentication)auth)}, false));
        JdbcAclServiceTests.assertFalse((boolean)child.isGranted(new Permission[]{BasePermission.DELETE}, new Sid[]{new PrincipalSid((Authentication)auth)}, false));
        try {
            child.isGranted(new Permission[]{BasePermission.ADMINISTRATION}, new Sid[]{new PrincipalSid((Authentication)auth)}, false);
            JdbcAclServiceTests.fail((String)"Should have thrown NotFoundException");
        }
        catch (NotFoundException expected) {
            JdbcAclServiceTests.assertTrue((boolean)true);
        }
        JdbcAclServiceTests.assertTrue((boolean)child.isGranted(new Permission[]{BasePermission.READ}, new Sid[]{new PrincipalSid((Authentication)auth)}, false));
        JdbcAclServiceTests.assertFalse((boolean)child.isGranted(new Permission[]{BasePermission.WRITE}, new Sid[]{new PrincipalSid((Authentication)auth)}, false));
        JdbcAclServiceTests.assertFalse((boolean)child.isGranted(new Permission[]{BasePermission.DELETE}, new Sid[]{new PrincipalSid((Authentication)auth)}, false));
        child.setEntriesInheriting(false);
        this.jdbcMutableAclService.updateAcl(child);
        child = (MutableAcl)this.jdbcMutableAclService.readAclById((ObjectIdentity)childOid);
        JdbcAclServiceTests.assertFalse((boolean)child.isEntriesInheriting());
        JdbcAclServiceTests.assertFalse((boolean)child.isGranted(new Permission[]{BasePermission.DELETE}, new Sid[]{new PrincipalSid((Authentication)auth)}, true));
        try {
            child.isGranted(new Permission[]{BasePermission.READ}, new Sid[]{new PrincipalSid((Authentication)auth)}, true);
            JdbcAclServiceTests.fail((String)"Should have thrown NotFoundException");
        }
        catch (NotFoundException expected) {
            JdbcAclServiceTests.assertTrue((boolean)true);
        }
        try {
            child.isGranted(new Permission[]{BasePermission.WRITE}, new Sid[]{new PrincipalSid((Authentication)auth)}, true);
            JdbcAclServiceTests.fail((String)"Should have thrown NotFoundException");
        }
        catch (NotFoundException expected) {
            JdbcAclServiceTests.assertTrue((boolean)true);
        }
        child.insertAce(null, BasePermission.DELETE, (Sid)new PrincipalSid((Authentication)auth), true);
        child.insertAce(null, BasePermission.CREATE, (Sid)new PrincipalSid((Authentication)auth), true);
        this.jdbcMutableAclService.updateAcl(child);
        child = (MutableAcl)this.jdbcMutableAclService.readAclById((ObjectIdentity)childOid);
        JdbcAclServiceTests.assertEquals((int)3, (int)child.getEntries().length);
        for (int i = 0; i < child.getEntries().length; ++i) {
            System.out.println(child.getEntries()[i]);
        }
        JdbcAclServiceTests.assertFalse((boolean)child.isGranted(new Permission[]{BasePermission.DELETE}, new Sid[]{new PrincipalSid((Authentication)auth)}, true));
        JdbcAclServiceTests.assertTrue((boolean)child.isGranted(new Permission[]{BasePermission.CREATE}, new Sid[]{new PrincipalSid((Authentication)auth)}, true));
        AccessControlEntry entry = child.getEntries()[0];
        JdbcAclServiceTests.assertEquals((int)BasePermission.DELETE.getMask(), (int)entry.getPermission().getMask());
        JdbcAclServiceTests.assertEquals((Object)new PrincipalSid((Authentication)auth), (Object)entry.getSid());
        JdbcAclServiceTests.assertFalse((boolean)entry.isGranting());
        JdbcAclServiceTests.assertNotNull((Object)entry.getId());
        child.deleteAce(entry.getId());
        child = this.jdbcMutableAclService.updateAcl(child);
        JdbcAclServiceTests.assertEquals((int)2, (int)child.getEntries().length);
        JdbcAclServiceTests.assertTrue((boolean)child.isGranted(new Permission[]{BasePermission.DELETE}, new Sid[]{new PrincipalSid((Authentication)auth)}, false));
        SecurityContextHolder.clearContext();
    }
}

