/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.adapters;

import java.security.Principal;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.adapters.HttpRequestIntegrationFilter;
import org.acegisecurity.adapters.PrincipalAcegiUserToken;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.util.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class HttpRequestIntegrationFilterTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$adapters$HttpRequestIntegrationFilterTests;

    public HttpRequestIntegrationFilterTests() {
    }

    public HttpRequestIntegrationFilterTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$adapters$HttpRequestIntegrationFilterTests == null ? (class$org$acegisecurity$adapters$HttpRequestIntegrationFilterTests = HttpRequestIntegrationFilterTests.class$("org.acegisecurity.adapters.HttpRequestIntegrationFilterTests")) : class$org$acegisecurity$adapters$HttpRequestIntegrationFilterTests));
    }

    protected void setUp() throws Exception {
        super.setUp();
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    public void testCorrectOperation() throws Exception {
        HttpRequestIntegrationFilter filter = new HttpRequestIntegrationFilter();
        PrincipalAcegiUserToken principal = new PrincipalAcegiUserToken("key", "someone", "password", new GrantedAuthority[]{new GrantedAuthorityImpl("SOME_ROLE")}, null);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setUserPrincipal((Principal)principal);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain(true);
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        if (!(SecurityContextHolder.getContext().getAuthentication() instanceof PrincipalAcegiUserToken)) {
            System.out.println(SecurityContextHolder.getContext().getAuthentication());
            HttpRequestIntegrationFilterTests.fail((String)"Should have returned PrincipalAcegiUserToken");
        }
        PrincipalAcegiUserToken castResult = (PrincipalAcegiUserToken)SecurityContextHolder.getContext().getAuthentication();
        HttpRequestIntegrationFilterTests.assertEquals((Object)principal, (Object)castResult);
    }

    public void testHandlesIfHttpRequestIsNullForSomeReason() throws Exception {
        HttpRequestIntegrationFilter filter = new HttpRequestIntegrationFilter();
        try {
            filter.doFilter(null, null, null);
            HttpRequestIntegrationFilterTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            HttpRequestIntegrationFilterTests.assertTrue((boolean)true);
        }
    }

    public void testHandlesIfThereIsNoPrincipal() throws Exception {
        HttpRequestIntegrationFilter filter = new HttpRequestIntegrationFilter();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain(true);
        HttpRequestIntegrationFilterTests.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        HttpRequestIntegrationFilterTests.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

