/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.afterinvocation;

import java.util.Vector;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.Authentication;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.SecurityConfig;
import org.acegisecurity.afterinvocation.AfterInvocationProvider;
import org.acegisecurity.afterinvocation.AfterInvocationProviderManager;
import org.acegisecurity.util.SimpleMethodInvocation;

public class AfterInvocationProviderManagerTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$afterinvocation$AfterInvocationProviderManagerTests;
    static /* synthetic */ Class class$org$aopalliance$intercept$MethodInvocation;
    static /* synthetic */ Class class$org$acegisecurity$intercept$web$FilterInvocation;

    public AfterInvocationProviderManagerTests() {
    }

    public AfterInvocationProviderManagerTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$afterinvocation$AfterInvocationProviderManagerTests == null ? (class$org$acegisecurity$afterinvocation$AfterInvocationProviderManagerTests = AfterInvocationProviderManagerTests.class$("org.acegisecurity.afterinvocation.AfterInvocationProviderManagerTests")) : class$org$acegisecurity$afterinvocation$AfterInvocationProviderManagerTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testCorrectOperation() throws Exception {
        AfterInvocationProviderManager manager = new AfterInvocationProviderManager();
        Vector<MockAfterInvocationProvider> list = new Vector<MockAfterInvocationProvider>();
        list.add(new MockAfterInvocationProvider("swap1", class$org$aopalliance$intercept$MethodInvocation == null ? (class$org$aopalliance$intercept$MethodInvocation = AfterInvocationProviderManagerTests.class$("org.aopalliance.intercept.MethodInvocation")) : class$org$aopalliance$intercept$MethodInvocation, (ConfigAttribute)new SecurityConfig("GIVE_ME_SWAP1")));
        list.add(new MockAfterInvocationProvider("swap2", class$org$aopalliance$intercept$MethodInvocation == null ? (class$org$aopalliance$intercept$MethodInvocation = AfterInvocationProviderManagerTests.class$("org.aopalliance.intercept.MethodInvocation")) : class$org$aopalliance$intercept$MethodInvocation, (ConfigAttribute)new SecurityConfig("GIVE_ME_SWAP2")));
        list.add(new MockAfterInvocationProvider("swap3", class$org$aopalliance$intercept$MethodInvocation == null ? (class$org$aopalliance$intercept$MethodInvocation = AfterInvocationProviderManagerTests.class$("org.aopalliance.intercept.MethodInvocation")) : class$org$aopalliance$intercept$MethodInvocation, (ConfigAttribute)new SecurityConfig("GIVE_ME_SWAP3")));
        manager.setProviders(list);
        AfterInvocationProviderManagerTests.assertEquals(list, (Object)manager.getProviders());
        manager.afterPropertiesSet();
        ConfigAttributeDefinition attr1 = new ConfigAttributeDefinition();
        attr1.addConfigAttribute((ConfigAttribute)new SecurityConfig("GIVE_ME_SWAP1"));
        ConfigAttributeDefinition attr2 = new ConfigAttributeDefinition();
        attr2.addConfigAttribute((ConfigAttribute)new SecurityConfig("GIVE_ME_SWAP2"));
        ConfigAttributeDefinition attr3 = new ConfigAttributeDefinition();
        attr3.addConfigAttribute((ConfigAttribute)new SecurityConfig("GIVE_ME_SWAP3"));
        ConfigAttributeDefinition attr2and3 = new ConfigAttributeDefinition();
        attr2and3.addConfigAttribute((ConfigAttribute)new SecurityConfig("GIVE_ME_SWAP2"));
        attr2and3.addConfigAttribute((ConfigAttribute)new SecurityConfig("GIVE_ME_SWAP3"));
        ConfigAttributeDefinition attr4 = new ConfigAttributeDefinition();
        attr4.addConfigAttribute((ConfigAttribute)new SecurityConfig("NEVER_CAUSES_SWAP"));
        AfterInvocationProviderManagerTests.assertEquals((Object)"swap1", (Object)manager.decide(null, (Object)new SimpleMethodInvocation(), attr1, (Object)"content-before-swapping"));
        AfterInvocationProviderManagerTests.assertEquals((Object)"swap2", (Object)manager.decide(null, (Object)new SimpleMethodInvocation(), attr2, (Object)"content-before-swapping"));
        AfterInvocationProviderManagerTests.assertEquals((Object)"swap3", (Object)manager.decide(null, (Object)new SimpleMethodInvocation(), attr3, (Object)"content-before-swapping"));
        AfterInvocationProviderManagerTests.assertEquals((Object)"content-before-swapping", (Object)manager.decide(null, (Object)new SimpleMethodInvocation(), attr4, (Object)"content-before-swapping"));
        AfterInvocationProviderManagerTests.assertEquals((Object)"swap3", (Object)manager.decide(null, (Object)new SimpleMethodInvocation(), attr2and3, (Object)"content-before-swapping"));
    }

    public void testRejectsEmptyProvidersList() {
        AfterInvocationProviderManager manager = new AfterInvocationProviderManager();
        Vector list = new Vector();
        try {
            manager.setProviders(list);
            AfterInvocationProviderManagerTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AfterInvocationProviderManagerTests.assertTrue((boolean)true);
        }
    }

    public void testRejectsNonAfterInvocationProviders() {
        AfterInvocationProviderManager manager = new AfterInvocationProviderManager();
        Vector<Object> list = new Vector<Object>();
        list.add(new MockAfterInvocationProvider("swap1", class$org$aopalliance$intercept$MethodInvocation == null ? (class$org$aopalliance$intercept$MethodInvocation = AfterInvocationProviderManagerTests.class$("org.aopalliance.intercept.MethodInvocation")) : class$org$aopalliance$intercept$MethodInvocation, (ConfigAttribute)new SecurityConfig("GIVE_ME_SWAP1")));
        list.add(new Integer(45));
        list.add(new MockAfterInvocationProvider("swap3", class$org$aopalliance$intercept$MethodInvocation == null ? (class$org$aopalliance$intercept$MethodInvocation = AfterInvocationProviderManagerTests.class$("org.aopalliance.intercept.MethodInvocation")) : class$org$aopalliance$intercept$MethodInvocation, (ConfigAttribute)new SecurityConfig("GIVE_ME_SWAP3")));
        try {
            manager.setProviders(list);
            AfterInvocationProviderManagerTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AfterInvocationProviderManagerTests.assertTrue((boolean)true);
        }
    }

    public void testRejectsNullProvidersList() throws Exception {
        AfterInvocationProviderManager manager = new AfterInvocationProviderManager();
        try {
            manager.afterPropertiesSet();
            AfterInvocationProviderManagerTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AfterInvocationProviderManagerTests.assertTrue((boolean)true);
        }
    }

    public void testSupportsConfigAttributeIteration() throws Exception {
        AfterInvocationProviderManager manager = new AfterInvocationProviderManager();
        Vector<MockAfterInvocationProvider> list = new Vector<MockAfterInvocationProvider>();
        list.add(new MockAfterInvocationProvider("swap1", class$org$aopalliance$intercept$MethodInvocation == null ? (class$org$aopalliance$intercept$MethodInvocation = AfterInvocationProviderManagerTests.class$("org.aopalliance.intercept.MethodInvocation")) : class$org$aopalliance$intercept$MethodInvocation, (ConfigAttribute)new SecurityConfig("GIVE_ME_SWAP1")));
        list.add(new MockAfterInvocationProvider("swap2", class$org$aopalliance$intercept$MethodInvocation == null ? (class$org$aopalliance$intercept$MethodInvocation = AfterInvocationProviderManagerTests.class$("org.aopalliance.intercept.MethodInvocation")) : class$org$aopalliance$intercept$MethodInvocation, (ConfigAttribute)new SecurityConfig("GIVE_ME_SWAP2")));
        list.add(new MockAfterInvocationProvider("swap3", class$org$aopalliance$intercept$MethodInvocation == null ? (class$org$aopalliance$intercept$MethodInvocation = AfterInvocationProviderManagerTests.class$("org.aopalliance.intercept.MethodInvocation")) : class$org$aopalliance$intercept$MethodInvocation, (ConfigAttribute)new SecurityConfig("GIVE_ME_SWAP3")));
        manager.setProviders(list);
        manager.afterPropertiesSet();
        AfterInvocationProviderManagerTests.assertFalse((boolean)manager.supports((ConfigAttribute)new SecurityConfig("UNKNOWN_ATTRIB")));
        AfterInvocationProviderManagerTests.assertTrue((boolean)manager.supports((ConfigAttribute)new SecurityConfig("GIVE_ME_SWAP2")));
    }

    public void testSupportsSecureObjectIteration() throws Exception {
        AfterInvocationProviderManager manager = new AfterInvocationProviderManager();
        Vector<MockAfterInvocationProvider> list = new Vector<MockAfterInvocationProvider>();
        list.add(new MockAfterInvocationProvider("swap1", class$org$aopalliance$intercept$MethodInvocation == null ? (class$org$aopalliance$intercept$MethodInvocation = AfterInvocationProviderManagerTests.class$("org.aopalliance.intercept.MethodInvocation")) : class$org$aopalliance$intercept$MethodInvocation, (ConfigAttribute)new SecurityConfig("GIVE_ME_SWAP1")));
        list.add(new MockAfterInvocationProvider("swap2", class$org$aopalliance$intercept$MethodInvocation == null ? (class$org$aopalliance$intercept$MethodInvocation = AfterInvocationProviderManagerTests.class$("org.aopalliance.intercept.MethodInvocation")) : class$org$aopalliance$intercept$MethodInvocation, (ConfigAttribute)new SecurityConfig("GIVE_ME_SWAP2")));
        list.add(new MockAfterInvocationProvider("swap3", class$org$aopalliance$intercept$MethodInvocation == null ? (class$org$aopalliance$intercept$MethodInvocation = AfterInvocationProviderManagerTests.class$("org.aopalliance.intercept.MethodInvocation")) : class$org$aopalliance$intercept$MethodInvocation, (ConfigAttribute)new SecurityConfig("GIVE_ME_SWAP3")));
        manager.setProviders(list);
        manager.afterPropertiesSet();
        AfterInvocationProviderManagerTests.assertFalse((boolean)manager.supports(class$org$acegisecurity$intercept$web$FilterInvocation == null ? (class$org$acegisecurity$intercept$web$FilterInvocation = AfterInvocationProviderManagerTests.class$("org.acegisecurity.intercept.web.FilterInvocation")) : class$org$acegisecurity$intercept$web$FilterInvocation));
        AfterInvocationProviderManagerTests.assertTrue((boolean)manager.supports(class$org$aopalliance$intercept$MethodInvocation == null ? (class$org$aopalliance$intercept$MethodInvocation = AfterInvocationProviderManagerTests.class$("org.aopalliance.intercept.MethodInvocation")) : class$org$aopalliance$intercept$MethodInvocation));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MockAfterInvocationProvider
    implements AfterInvocationProvider {
        private Class secureObject;
        private ConfigAttribute configAttribute;
        private Object forceReturnObject;

        public MockAfterInvocationProvider(Object forceReturnObject, Class secureObject, ConfigAttribute configAttribute) {
            this.forceReturnObject = forceReturnObject;
            this.secureObject = secureObject;
            this.configAttribute = configAttribute;
        }

        private MockAfterInvocationProvider() {
        }

        public Object decide(Authentication authentication, Object object, ConfigAttributeDefinition config, Object returnedObject) throws AccessDeniedException {
            if (config.contains(this.configAttribute)) {
                return this.forceReturnObject;
            }
            return returnedObject;
        }

        public boolean supports(Class clazz) {
            return this.secureObject.isAssignableFrom(clazz);
        }

        public boolean supports(ConfigAttribute attribute) {
            return attribute.equals(this.configAttribute);
        }
    }
}

