/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.afterinvocation;

import java.util.List;
import java.util.Vector;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthorizationServiceException;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.MockAclManager;
import org.acegisecurity.SecurityConfig;
import org.acegisecurity.acl.AclEntry;
import org.acegisecurity.acl.AclManager;
import org.acegisecurity.acl.basic.AclObjectIdentity;
import org.acegisecurity.acl.basic.MockAclObjectIdentity;
import org.acegisecurity.acl.basic.SimpleAclEntry;
import org.acegisecurity.afterinvocation.BasicAclEntryAfterInvocationCollectionFilteringProvider;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.util.SimpleMethodInvocation;

public class BasicAclEntryAfterInvocationCollectionFilteringProviderTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$afterinvocation$BasicAclEntryAfterInvocationCollectionFilteringProviderTests;
    static /* synthetic */ Class class$java$lang$String;

    public BasicAclEntryAfterInvocationCollectionFilteringProviderTests() {
    }

    public BasicAclEntryAfterInvocationCollectionFilteringProviderTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$afterinvocation$BasicAclEntryAfterInvocationCollectionFilteringProviderTests == null ? (class$org$acegisecurity$afterinvocation$BasicAclEntryAfterInvocationCollectionFilteringProviderTests = BasicAclEntryAfterInvocationCollectionFilteringProviderTests.class$("org.acegisecurity.afterinvocation.BasicAclEntryAfterInvocationCollectionFilteringProviderTests")) : class$org$acegisecurity$afterinvocation$BasicAclEntryAfterInvocationCollectionFilteringProviderTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testCorrectOperationWhenPrincipalHasIncorrectPermissionToDomainObject() throws Exception {
        MockAclManager aclManager = new MockAclManager("belmont", "scott", new AclEntry[]{new SimpleAclEntry((Object)"scott", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.ADMINISTRATION)});
        BasicAclEntryAfterInvocationCollectionFilteringProvider provider = new BasicAclEntryAfterInvocationCollectionFilteringProvider();
        provider.setAclManager((AclManager)aclManager);
        provider.afterPropertiesSet();
        Vector<String> list = new Vector<String>();
        list.add("sydney");
        list.add("melbourne");
        list.add("belmont");
        list.add("brisbane");
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"scott", (Object)"NOT_USED");
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition();
        attr.addConfigAttribute((ConfigAttribute)new SecurityConfig("AFTER_ACL_COLLECTION_READ"));
        List filteredList = (List)provider.decide((Authentication)auth, (Object)new SimpleMethodInvocation(), attr, list);
        BasicAclEntryAfterInvocationCollectionFilteringProviderTests.assertEquals((int)0, (int)filteredList.size());
    }

    public void testCorrectOperationWhenPrincipalHasNoPermissionToDomainObject() throws Exception {
        MockAclManager aclManager = new MockAclManager("belmont", "marissa", new AclEntry[]{new MockAclEntry(), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.ADMINISTRATION), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.READ), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.DELETE)});
        BasicAclEntryAfterInvocationCollectionFilteringProvider provider = new BasicAclEntryAfterInvocationCollectionFilteringProvider();
        provider.setAclManager((AclManager)aclManager);
        provider.afterPropertiesSet();
        Vector<String> list = new Vector<String>();
        list.add("sydney");
        list.add("melbourne");
        list.add("belmont");
        list.add("brisbane");
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"scott", (Object)"NOT_USED");
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition();
        attr.addConfigAttribute((ConfigAttribute)new SecurityConfig("AFTER_ACL_COLLECTION_READ"));
        List filteredList = (List)provider.decide((Authentication)auth, (Object)new SimpleMethodInvocation(), attr, list);
        BasicAclEntryAfterInvocationCollectionFilteringProviderTests.assertEquals((int)0, (int)filteredList.size());
    }

    public void testCorrectOperationWhenPrincipalIsAuthorised() throws Exception {
        MockAclManager aclManager = new MockAclManager("belmont", "marissa", new AclEntry[]{new MockAclEntry(), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.ADMINISTRATION), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.READ), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.DELETE)});
        BasicAclEntryAfterInvocationCollectionFilteringProvider provider = new BasicAclEntryAfterInvocationCollectionFilteringProvider();
        provider.setAclManager((AclManager)aclManager);
        BasicAclEntryAfterInvocationCollectionFilteringProviderTests.assertEquals((Object)aclManager, (Object)provider.getAclManager());
        provider.afterPropertiesSet();
        Vector<String> list = new Vector<String>();
        list.add("sydney");
        list.add("melbourne");
        list.add("belmont");
        list.add("brisbane");
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"marissa", (Object)"NOT_USED");
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition();
        attr.addConfigAttribute((ConfigAttribute)new SecurityConfig("AFTER_ACL_COLLECTION_READ"));
        List filteredList = (List)provider.decide((Authentication)auth, (Object)new SimpleMethodInvocation(), attr, list);
        BasicAclEntryAfterInvocationCollectionFilteringProviderTests.assertEquals((int)1, (int)filteredList.size());
        BasicAclEntryAfterInvocationCollectionFilteringProviderTests.assertEquals((Object)"belmont", filteredList.get(0));
    }

    public void testCorrectOperationWhenReturnedObjectIsArray() throws Exception {
        MockAclManager aclManager = new MockAclManager("belmont", "marissa", new AclEntry[]{new MockAclEntry(), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.ADMINISTRATION), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.READ), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.DELETE)});
        BasicAclEntryAfterInvocationCollectionFilteringProvider provider = new BasicAclEntryAfterInvocationCollectionFilteringProvider();
        provider.setAclManager((AclManager)aclManager);
        BasicAclEntryAfterInvocationCollectionFilteringProviderTests.assertEquals((Object)aclManager, (Object)provider.getAclManager());
        provider.afterPropertiesSet();
        String[] list = new String[]{"sydney", "melbourne", "belmont", "brisbane"};
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"marissa", (Object)"NOT_USED");
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition();
        attr.addConfigAttribute((ConfigAttribute)new SecurityConfig("AFTER_ACL_COLLECTION_READ"));
        String[] filteredList = (String[])provider.decide((Authentication)auth, (Object)new SimpleMethodInvocation(), attr, (Object)list);
        BasicAclEntryAfterInvocationCollectionFilteringProviderTests.assertEquals((int)1, (int)filteredList.length);
        BasicAclEntryAfterInvocationCollectionFilteringProviderTests.assertEquals((String)"belmont", (String)filteredList[0]);
    }

    public void testDetectsIfReturnedObjectIsNotACollection() throws Exception {
        MockAclManager aclManager = new MockAclManager("belmont", "marissa", new AclEntry[]{new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.ADMINISTRATION), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.READ), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.DELETE), new MockAclEntry()});
        BasicAclEntryAfterInvocationCollectionFilteringProvider provider = new BasicAclEntryAfterInvocationCollectionFilteringProvider();
        provider.setAclManager((AclManager)aclManager);
        provider.afterPropertiesSet();
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"marissa", (Object)"NOT_USED");
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition();
        attr.addConfigAttribute((ConfigAttribute)new SecurityConfig("AFTER_ACL_COLLECTION_READ"));
        try {
            provider.decide((Authentication)auth, (Object)new SimpleMethodInvocation(), attr, (Object)new String("RETURN_OBJECT_NOT_COLLECTION"));
            BasicAclEntryAfterInvocationCollectionFilteringProviderTests.fail((String)"Should have thrown AuthorizationServiceException");
        }
        catch (AuthorizationServiceException expected) {
            BasicAclEntryAfterInvocationCollectionFilteringProviderTests.assertTrue((boolean)true);
        }
    }

    public void testGrantsAccessIfReturnedObjectIsNull() throws Exception {
        MockAclManager aclManager = new MockAclManager("belmont", "marissa", new AclEntry[]{new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.ADMINISTRATION), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.READ), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.DELETE), new MockAclEntry()});
        BasicAclEntryAfterInvocationCollectionFilteringProvider provider = new BasicAclEntryAfterInvocationCollectionFilteringProvider();
        provider.setAclManager((AclManager)aclManager);
        provider.afterPropertiesSet();
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"marissa", (Object)"NOT_USED");
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition();
        attr.addConfigAttribute((ConfigAttribute)new SecurityConfig("AFTER_ACL_COLLECTION_READ"));
        List filteredList = (List)provider.decide((Authentication)auth, (Object)new SimpleMethodInvocation(), attr, null);
        BasicAclEntryAfterInvocationCollectionFilteringProviderTests.assertNull((Object)filteredList);
    }

    public void testRespectsModificationsToProcessConfigAttribute() throws Exception {
        MockAclManager aclManager = new MockAclManager("sydney", "marissa", new AclEntry[]{new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.READ), new MockAclEntry()});
        BasicAclEntryAfterInvocationCollectionFilteringProvider provider = new BasicAclEntryAfterInvocationCollectionFilteringProvider();
        provider.setAclManager((AclManager)aclManager);
        BasicAclEntryAfterInvocationCollectionFilteringProviderTests.assertEquals((String)"AFTER_ACL_COLLECTION_READ", (String)provider.getProcessConfigAttribute());
        provider.setProcessConfigAttribute("AFTER_ACL_COLLECTION_ADMIN");
        BasicAclEntryAfterInvocationCollectionFilteringProviderTests.assertEquals((String)"AFTER_ACL_COLLECTION_ADMIN", (String)provider.getProcessConfigAttribute());
        provider.afterPropertiesSet();
        Vector<String> list = new Vector<String>();
        list.add("sydney");
        list.add("melbourne");
        list.add("belmont");
        list.add("brisbane");
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"marissa", (Object)"NOT_USED");
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition();
        attr.addConfigAttribute((ConfigAttribute)new SecurityConfig("AFTER_ACL_COLLECTION_READ"));
        BasicAclEntryAfterInvocationCollectionFilteringProviderTests.assertEquals((int)4, (int)((List)provider.decide((Authentication)auth, (Object)new SimpleMethodInvocation(), attr, list)).size());
        attr.addConfigAttribute((ConfigAttribute)new SecurityConfig("AFTER_ACL_COLLECTION_ADMIN"));
        List filteredList = (List)provider.decide((Authentication)auth, (Object)new SimpleMethodInvocation(), attr, list);
        BasicAclEntryAfterInvocationCollectionFilteringProviderTests.assertEquals((int)1, (int)filteredList.size());
        BasicAclEntryAfterInvocationCollectionFilteringProviderTests.assertEquals((Object)"sydney", filteredList.get(0));
    }

    public void testRespectsModificationsToRequirePermissions() throws Exception {
        MockAclManager aclManager = new MockAclManager("sydney", "marissa", new AclEntry[]{new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.ADMINISTRATION), new MockAclEntry()});
        BasicAclEntryAfterInvocationCollectionFilteringProvider provider = new BasicAclEntryAfterInvocationCollectionFilteringProvider();
        provider.setAclManager((AclManager)aclManager);
        BasicAclEntryAfterInvocationCollectionFilteringProviderTests.assertEquals((int)SimpleAclEntry.READ, (int)provider.getRequirePermission()[0]);
        provider.setRequirePermission(new int[]{SimpleAclEntry.ADMINISTRATION});
        BasicAclEntryAfterInvocationCollectionFilteringProviderTests.assertEquals((int)SimpleAclEntry.ADMINISTRATION, (int)provider.getRequirePermission()[0]);
        provider.afterPropertiesSet();
        Vector<String> list = new Vector<String>();
        list.add("sydney");
        list.add("melbourne");
        list.add("belmont");
        list.add("brisbane");
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"marissa", (Object)"NOT_USED");
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition();
        attr.addConfigAttribute((ConfigAttribute)new SecurityConfig("AFTER_ACL_COLLECTION_READ"));
        List filteredList = (List)provider.decide((Authentication)auth, (Object)new SimpleMethodInvocation(), attr, list);
        BasicAclEntryAfterInvocationCollectionFilteringProviderTests.assertEquals((int)1, (int)filteredList.size());
        BasicAclEntryAfterInvocationCollectionFilteringProviderTests.assertEquals((Object)"sydney", filteredList.get(0));
    }

    public void testStartupDetectsMissingAclManager() throws Exception {
        BasicAclEntryAfterInvocationCollectionFilteringProvider provider = new BasicAclEntryAfterInvocationCollectionFilteringProvider();
        try {
            provider.afterPropertiesSet();
            BasicAclEntryAfterInvocationCollectionFilteringProviderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            BasicAclEntryAfterInvocationCollectionFilteringProviderTests.assertEquals((String)"An aclManager is mandatory", (String)expected.getMessage());
        }
    }

    public void testStartupDetectsMissingProcessConfigAttribute() throws Exception {
        BasicAclEntryAfterInvocationCollectionFilteringProvider provider = new BasicAclEntryAfterInvocationCollectionFilteringProvider();
        MockAclManager aclManager = new MockAclManager("sydney", "marissa", new AclEntry[]{new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.ADMINISTRATION), new MockAclEntry()});
        provider.setAclManager((AclManager)aclManager);
        provider.setProcessConfigAttribute(null);
        try {
            provider.afterPropertiesSet();
            BasicAclEntryAfterInvocationCollectionFilteringProviderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            BasicAclEntryAfterInvocationCollectionFilteringProviderTests.assertEquals((String)"A processConfigAttribute is mandatory", (String)expected.getMessage());
        }
    }

    public void testStartupDetectsMissingRequirePermission() throws Exception {
        BasicAclEntryAfterInvocationCollectionFilteringProvider provider = new BasicAclEntryAfterInvocationCollectionFilteringProvider();
        MockAclManager aclManager = new MockAclManager("sydney", "marissa", new AclEntry[]{new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.ADMINISTRATION), new MockAclEntry()});
        provider.setAclManager((AclManager)aclManager);
        provider.setRequirePermission(null);
        try {
            provider.afterPropertiesSet();
            BasicAclEntryAfterInvocationCollectionFilteringProviderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            BasicAclEntryAfterInvocationCollectionFilteringProviderTests.assertEquals((String)"One or more requirePermission entries is mandatory", (String)expected.getMessage());
        }
    }

    public void testSupportsAnything() {
        BasicAclEntryAfterInvocationCollectionFilteringProviderTests.assertTrue((boolean)new BasicAclEntryAfterInvocationCollectionFilteringProvider().supports(class$java$lang$String == null ? (class$java$lang$String = BasicAclEntryAfterInvocationCollectionFilteringProviderTests.class$("java.lang.String")) : class$java$lang$String));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MockAclEntry
    implements AclEntry {
        private MockAclEntry() {
        }
    }
}

