/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.afterinvocation;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.Authentication;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.MockAclManager;
import org.acegisecurity.SecurityConfig;
import org.acegisecurity.acl.AclEntry;
import org.acegisecurity.acl.AclManager;
import org.acegisecurity.acl.basic.AclObjectIdentity;
import org.acegisecurity.acl.basic.MockAclObjectIdentity;
import org.acegisecurity.acl.basic.SimpleAclEntry;
import org.acegisecurity.afterinvocation.BasicAclEntryAfterInvocationProvider;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.util.SimpleMethodInvocation;

public class BasicAclEntryAfterInvocationProviderTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$afterinvocation$BasicAclEntryAfterInvocationProviderTests;
    static /* synthetic */ Class class$java$lang$String;

    public BasicAclEntryAfterInvocationProviderTests() {
    }

    public BasicAclEntryAfterInvocationProviderTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$afterinvocation$BasicAclEntryAfterInvocationProviderTests == null ? (class$org$acegisecurity$afterinvocation$BasicAclEntryAfterInvocationProviderTests = BasicAclEntryAfterInvocationProviderTests.class$("org.acegisecurity.afterinvocation.BasicAclEntryAfterInvocationProviderTests")) : class$org$acegisecurity$afterinvocation$BasicAclEntryAfterInvocationProviderTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testCorrectOperationWhenPrincipalHasIncorrectPermissionToDomainObject() throws Exception {
        MockAclManager aclManager = new MockAclManager("belmont", "scott", new AclEntry[]{new SimpleAclEntry((Object)"scott", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.ADMINISTRATION)});
        BasicAclEntryAfterInvocationProvider provider = new BasicAclEntryAfterInvocationProvider();
        provider.setAclManager((AclManager)aclManager);
        provider.afterPropertiesSet();
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"scott", (Object)"NOT_USED");
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition();
        attr.addConfigAttribute((ConfigAttribute)new SecurityConfig("AFTER_ACL_READ"));
        try {
            provider.decide((Authentication)auth, (Object)new SimpleMethodInvocation(), attr, (Object)"belmont");
            BasicAclEntryAfterInvocationProviderTests.fail((String)"Should have thrown AccessDeniedException");
        }
        catch (AccessDeniedException expected) {
            BasicAclEntryAfterInvocationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testCorrectOperationWhenPrincipalHasNoPermissionToDomainObject() throws Exception {
        MockAclManager aclManager = new MockAclManager("belmont", "marissa", new AclEntry[]{new MockAclEntry(), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.ADMINISTRATION), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.READ), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.DELETE)});
        BasicAclEntryAfterInvocationProvider provider = new BasicAclEntryAfterInvocationProvider();
        provider.setAclManager((AclManager)aclManager);
        provider.afterPropertiesSet();
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"scott", (Object)"NOT_USED");
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition();
        attr.addConfigAttribute((ConfigAttribute)new SecurityConfig("AFTER_ACL_READ"));
        try {
            provider.decide((Authentication)auth, (Object)new SimpleMethodInvocation(), attr, (Object)"belmont");
            BasicAclEntryAfterInvocationProviderTests.fail((String)"Should have thrown AccessDeniedException");
        }
        catch (AccessDeniedException expected) {
            BasicAclEntryAfterInvocationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testCorrectOperationWhenPrincipalIsAuthorised() throws Exception {
        MockAclManager aclManager = new MockAclManager("belmont", "marissa", new AclEntry[]{new MockAclEntry(), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.ADMINISTRATION), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.READ), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.DELETE)});
        BasicAclEntryAfterInvocationProvider provider = new BasicAclEntryAfterInvocationProvider();
        provider.setAclManager((AclManager)aclManager);
        BasicAclEntryAfterInvocationProviderTests.assertEquals((Object)aclManager, (Object)provider.getAclManager());
        provider.afterPropertiesSet();
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"marissa", (Object)"NOT_USED");
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition();
        attr.addConfigAttribute((ConfigAttribute)new SecurityConfig("AFTER_ACL_READ"));
        BasicAclEntryAfterInvocationProviderTests.assertEquals((Object)"belmont", (Object)provider.decide((Authentication)auth, (Object)new SimpleMethodInvocation(), attr, (Object)"belmont"));
    }

    public void testGrantsAccessIfReturnedObjectIsNull() throws Exception {
        MockAclManager aclManager = new MockAclManager("belmont", "marissa", new AclEntry[]{new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.ADMINISTRATION), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.READ), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.DELETE), new MockAclEntry()});
        BasicAclEntryAfterInvocationProvider provider = new BasicAclEntryAfterInvocationProvider();
        provider.setAclManager((AclManager)aclManager);
        provider.afterPropertiesSet();
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"marissa", (Object)"NOT_USED");
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition();
        attr.addConfigAttribute((ConfigAttribute)new SecurityConfig("AFTER_ACL_READ"));
        BasicAclEntryAfterInvocationProviderTests.assertNull((Object)provider.decide((Authentication)auth, (Object)new SimpleMethodInvocation(), attr, null));
    }

    public void testRespectsModificationsToProcessConfigAttribute() throws Exception {
        MockAclManager aclManager = new MockAclManager("sydney", "marissa", new AclEntry[]{new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.READ), new MockAclEntry()});
        BasicAclEntryAfterInvocationProvider provider = new BasicAclEntryAfterInvocationProvider();
        provider.setAclManager((AclManager)aclManager);
        BasicAclEntryAfterInvocationProviderTests.assertEquals((String)"AFTER_ACL_READ", (String)provider.getProcessConfigAttribute());
        provider.setProcessConfigAttribute("AFTER_ACL_ADMIN");
        BasicAclEntryAfterInvocationProviderTests.assertEquals((String)"AFTER_ACL_ADMIN", (String)provider.getProcessConfigAttribute());
        provider.afterPropertiesSet();
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"marissa", (Object)"NOT_USED");
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition();
        attr.addConfigAttribute((ConfigAttribute)new SecurityConfig("AFTER_ACL_READ"));
        BasicAclEntryAfterInvocationProviderTests.assertEquals((Object)"sydney", (Object)provider.decide((Authentication)auth, (Object)new SimpleMethodInvocation(), attr, (Object)"sydney"));
        attr.addConfigAttribute((ConfigAttribute)new SecurityConfig("AFTER_ACL_ADMIN"));
        BasicAclEntryAfterInvocationProviderTests.assertEquals((Object)"sydney", (Object)provider.decide((Authentication)auth, (Object)new SimpleMethodInvocation(), attr, (Object)"sydney"));
    }

    public void testRespectsModificationsToRequirePermissions() throws Exception {
        MockAclManager aclManager = new MockAclManager("sydney", "marissa", new AclEntry[]{new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.ADMINISTRATION), new MockAclEntry()});
        BasicAclEntryAfterInvocationProvider provider = new BasicAclEntryAfterInvocationProvider();
        provider.setAclManager((AclManager)aclManager);
        BasicAclEntryAfterInvocationProviderTests.assertEquals((int)SimpleAclEntry.READ, (int)provider.getRequirePermission()[0]);
        provider.setRequirePermission(new int[]{SimpleAclEntry.ADMINISTRATION});
        BasicAclEntryAfterInvocationProviderTests.assertEquals((int)SimpleAclEntry.ADMINISTRATION, (int)provider.getRequirePermission()[0]);
        provider.afterPropertiesSet();
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"marissa", (Object)"NOT_USED");
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition();
        attr.addConfigAttribute((ConfigAttribute)new SecurityConfig("AFTER_ACL_READ"));
        BasicAclEntryAfterInvocationProviderTests.assertEquals((Object)"sydney", (Object)provider.decide((Authentication)auth, (Object)new SimpleMethodInvocation(), attr, (Object)"sydney"));
    }

    public void testStartupDetectsMissingAclManager() throws Exception {
        BasicAclEntryAfterInvocationProvider provider = new BasicAclEntryAfterInvocationProvider();
        try {
            provider.afterPropertiesSet();
            BasicAclEntryAfterInvocationProviderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            BasicAclEntryAfterInvocationProviderTests.assertEquals((String)"An aclManager is mandatory", (String)expected.getMessage());
        }
    }

    public void testStartupDetectsMissingProcessConfigAttribute() throws Exception {
        BasicAclEntryAfterInvocationProvider provider = new BasicAclEntryAfterInvocationProvider();
        MockAclManager aclManager = new MockAclManager("sydney", "marissa", new AclEntry[]{new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.ADMINISTRATION), new MockAclEntry()});
        provider.setAclManager((AclManager)aclManager);
        provider.setProcessConfigAttribute(null);
        try {
            provider.afterPropertiesSet();
            BasicAclEntryAfterInvocationProviderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            BasicAclEntryAfterInvocationProviderTests.assertEquals((String)"A processConfigAttribute is mandatory", (String)expected.getMessage());
        }
    }

    public void testStartupDetectsMissingRequirePermission() throws Exception {
        BasicAclEntryAfterInvocationProvider provider = new BasicAclEntryAfterInvocationProvider();
        MockAclManager aclManager = new MockAclManager("sydney", "marissa", new AclEntry[]{new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.ADMINISTRATION), new MockAclEntry()});
        provider.setAclManager((AclManager)aclManager);
        provider.setRequirePermission(null);
        try {
            provider.afterPropertiesSet();
            BasicAclEntryAfterInvocationProviderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            BasicAclEntryAfterInvocationProviderTests.assertEquals((String)"One or more requirePermission entries is mandatory", (String)expected.getMessage());
        }
    }

    public void testSupportsAnything() {
        BasicAclEntryAfterInvocationProviderTests.assertTrue((boolean)new BasicAclEntryAfterInvocationProvider().supports(class$java$lang$String == null ? (class$java$lang$String = BasicAclEntryAfterInvocationProviderTests.class$("java.lang.String")) : class$java$lang$String));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MockAclEntry
    implements AclEntry {
        private MockAclEntry() {
        }
    }
}

