/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.captcha;

import java.net.URLEncoder;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.MockPortResolver;
import org.acegisecurity.captcha.CaptchaEntryPoint;
import org.acegisecurity.util.PortMapper;
import org.acegisecurity.util.PortMapperImpl;
import org.acegisecurity.util.PortResolver;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class CaptchaEntryPointTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$captcha$CaptchaEntryPointTests;

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$captcha$CaptchaEntryPointTests == null ? (class$org$acegisecurity$captcha$CaptchaEntryPointTests = CaptchaEntryPointTests.class$("org.acegisecurity.captcha.CaptchaEntryPointTests")) : class$org$acegisecurity$captcha$CaptchaEntryPointTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testDetectsMissingCaptchaFormUrl() throws Exception {
        CaptchaEntryPoint ep = new CaptchaEntryPoint();
        ep.setPortMapper((PortMapper)new PortMapperImpl());
        ep.setPortResolver((PortResolver)new MockPortResolver(80, 443));
        try {
            ep.afterPropertiesSet();
            CaptchaEntryPointTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            CaptchaEntryPointTests.assertEquals((String)"captchaFormUrl must be specified", (String)expected.getMessage());
        }
    }

    public void testDetectsMissingPortMapper() throws Exception {
        CaptchaEntryPoint ep = new CaptchaEntryPoint();
        ep.setCaptchaFormUrl("xxx");
        ep.setPortMapper(null);
        try {
            ep.afterPropertiesSet();
            CaptchaEntryPointTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            CaptchaEntryPointTests.assertEquals((String)"portMapper must be specified", (String)expected.getMessage());
        }
    }

    public void testDetectsMissingPortResolver() throws Exception {
        CaptchaEntryPoint ep = new CaptchaEntryPoint();
        ep.setCaptchaFormUrl("xxx");
        ep.setPortResolver(null);
        try {
            ep.afterPropertiesSet();
            CaptchaEntryPointTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            CaptchaEntryPointTests.assertEquals((String)"portResolver must be specified", (String)expected.getMessage());
        }
    }

    public void testGettersSetters() {
        CaptchaEntryPoint ep = new CaptchaEntryPoint();
        ep.setCaptchaFormUrl("/hello");
        ep.setPortMapper((PortMapper)new PortMapperImpl());
        ep.setPortResolver((PortResolver)new MockPortResolver(8080, 8443));
        CaptchaEntryPointTests.assertEquals((String)"/hello", (String)ep.getCaptchaFormUrl());
        CaptchaEntryPointTests.assertTrue((ep.getPortMapper() != null ? 1 : 0) != 0);
        CaptchaEntryPointTests.assertTrue((ep.getPortResolver() != null ? 1 : 0) != 0);
        CaptchaEntryPointTests.assertEquals((String)"original_requestUrl", (String)ep.getOriginalRequestUrlParameterName());
        ep.setOriginalRequestUrlParameterName("Z");
        CaptchaEntryPointTests.assertEquals((String)"Z", (String)ep.getOriginalRequestUrlParameterName());
        CaptchaEntryPointTests.assertEquals((boolean)true, (boolean)ep.isIncludeOriginalRequest());
        ep.setIncludeOriginalRequest(false);
        CaptchaEntryPointTests.assertEquals((boolean)false, (boolean)ep.isIncludeOriginalRequest());
        CaptchaEntryPointTests.assertEquals((boolean)false, (boolean)ep.isOutsideWebApp());
        ep.setOutsideWebApp(true);
        CaptchaEntryPointTests.assertEquals((boolean)true, (boolean)ep.isOutsideWebApp());
        ep.setForceHttps(false);
        CaptchaEntryPointTests.assertFalse((boolean)ep.getForceHttps());
        ep.setForceHttps(true);
        CaptchaEntryPointTests.assertTrue((boolean)ep.getForceHttps());
    }

    public void testHttpsOperationFromOriginalHttpUrl() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/some_path");
        request.setScheme("http");
        request.setServerName("www.example.com");
        request.setContextPath("/bigWebApp");
        request.setServerPort(80);
        MockHttpServletResponse response = new MockHttpServletResponse();
        CaptchaEntryPoint ep = new CaptchaEntryPoint();
        ep.setIncludeOriginalRequest(false);
        ep.setCaptchaFormUrl("/hello");
        ep.setPortMapper((PortMapper)new PortMapperImpl());
        ep.setForceHttps(true);
        ep.setPortMapper((PortMapper)new PortMapperImpl());
        ep.setPortResolver((PortResolver)new MockPortResolver(80, 443));
        ep.afterPropertiesSet();
        ep.commence((ServletRequest)request, (ServletResponse)response);
        CaptchaEntryPointTests.assertEquals((String)"https://www.example.com/bigWebApp/hello", (String)response.getRedirectedUrl());
        request.setServerPort(8080);
        response = new MockHttpServletResponse();
        ep.setPortResolver((PortResolver)new MockPortResolver(8080, 8443));
        ep.commence((ServletRequest)request, (ServletResponse)response);
        CaptchaEntryPointTests.assertEquals((String)"https://www.example.com:8443/bigWebApp/hello", (String)response.getRedirectedUrl());
        request.setServerPort(8888);
        response = new MockHttpServletResponse();
        ep.commence((ServletRequest)request, (ServletResponse)response);
        CaptchaEntryPointTests.assertEquals((String)"https://www.example.com:8443/bigWebApp/hello", (String)response.getRedirectedUrl());
        PortMapperImpl portMapper = new PortMapperImpl();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("8888", "9999");
        portMapper.setPortMappings(map);
        response = new MockHttpServletResponse();
        ep = new CaptchaEntryPoint();
        ep.setCaptchaFormUrl("/hello");
        ep.setPortMapper((PortMapper)new PortMapperImpl());
        ep.setForceHttps(true);
        ep.setPortMapper((PortMapper)portMapper);
        ep.setPortResolver((PortResolver)new MockPortResolver(8888, 9999));
        ep.setIncludeOriginalRequest(false);
        ep.afterPropertiesSet();
        ep.commence((ServletRequest)request, (ServletResponse)response);
        CaptchaEntryPointTests.assertEquals((String)"https://www.example.com:9999/bigWebApp/hello", (String)response.getRedirectedUrl());
    }

    public void testHttpsOperationFromOriginalHttpsUrl() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/some_path");
        request.setScheme("https");
        request.setServerName("www.example.com");
        request.setContextPath("/bigWebApp");
        request.setServerPort(443);
        MockHttpServletResponse response = new MockHttpServletResponse();
        CaptchaEntryPoint ep = new CaptchaEntryPoint();
        ep.setIncludeOriginalRequest(false);
        ep.setCaptchaFormUrl("/hello");
        ep.setPortMapper((PortMapper)new PortMapperImpl());
        ep.setForceHttps(true);
        ep.setPortMapper((PortMapper)new PortMapperImpl());
        ep.setPortResolver((PortResolver)new MockPortResolver(80, 443));
        ep.afterPropertiesSet();
        ep.commence((ServletRequest)request, (ServletResponse)response);
        CaptchaEntryPointTests.assertEquals((String)"https://www.example.com/bigWebApp/hello", (String)response.getRedirectedUrl());
        request.setServerPort(8443);
        response = new MockHttpServletResponse();
        ep.setPortResolver((PortResolver)new MockPortResolver(8080, 8443));
        ep.commence((ServletRequest)request, (ServletResponse)response);
        CaptchaEntryPointTests.assertEquals((String)"https://www.example.com:8443/bigWebApp/hello", (String)response.getRedirectedUrl());
    }

    public void testNormalOperation() throws Exception {
        CaptchaEntryPoint ep = new CaptchaEntryPoint();
        ep.setCaptchaFormUrl("/hello");
        ep.setPortMapper((PortMapper)new PortMapperImpl());
        ep.setPortResolver((PortResolver)new MockPortResolver(80, 443));
        ep.afterPropertiesSet();
        ep.setIncludeOriginalRequest(false);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/some_path");
        request.setContextPath("/bigWebApp");
        request.setScheme("http");
        request.setServerName("www.example.com");
        request.setContextPath("/bigWebApp");
        request.setServerPort(80);
        MockHttpServletResponse response = new MockHttpServletResponse();
        ep.afterPropertiesSet();
        ep.commence((ServletRequest)request, (ServletResponse)response);
        CaptchaEntryPointTests.assertEquals((String)"http://www.example.com/bigWebApp/hello", (String)response.getRedirectedUrl());
    }

    public void testOperationWhenHttpsRequestsButHttpsPortUnknown() throws Exception {
        CaptchaEntryPoint ep = new CaptchaEntryPoint();
        ep.setCaptchaFormUrl("/hello");
        ep.setPortMapper((PortMapper)new PortMapperImpl());
        ep.setPortResolver((PortResolver)new MockPortResolver(8888, 1234));
        ep.setForceHttps(true);
        ep.setIncludeOriginalRequest(false);
        ep.afterPropertiesSet();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/some_path");
        request.setContextPath("/bigWebApp");
        request.setScheme("http");
        request.setServerName("www.example.com");
        request.setContextPath("/bigWebApp");
        request.setServerPort(8888);
        MockHttpServletResponse response = new MockHttpServletResponse();
        ep.afterPropertiesSet();
        ep.commence((ServletRequest)request, (ServletResponse)response);
        CaptchaEntryPointTests.assertEquals((String)"http://www.example.com:8888/bigWebApp/hello", (String)response.getRedirectedUrl());
    }

    public void testOperationWithOriginalRequestIncludes() throws Exception {
        CaptchaEntryPoint ep = new CaptchaEntryPoint();
        ep.setCaptchaFormUrl("/hello");
        PortMapperImpl mapper = new PortMapperImpl();
        mapper.getTranslatedPortMappings().put(new Integer(8888), new Integer(1234));
        ep.setPortMapper((PortMapper)mapper);
        ep.setPortResolver((PortResolver)new MockPortResolver(8888, 1234));
        ep.setIncludeOriginalRequest(true);
        ep.afterPropertiesSet();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setMethod("post");
        request.setRequestURI("/some_path");
        request.setScheme("http");
        request.setServerName("www.example.com");
        request.setServerPort(8888);
        MockHttpServletResponse response = new MockHttpServletResponse();
        ep.afterPropertiesSet();
        ep.commence((ServletRequest)request, (ServletResponse)response);
        CaptchaEntryPointTests.assertEquals((String)("http://www.example.com:8888/hello?original_requestUrl=" + URLEncoder.encode("http://www.example.com:8888/some_path", "UTF-8") + "&original_request_method=post"), (String)response.getRedirectedUrl());
        request.addParameter("name", "value");
        response = new MockHttpServletResponse();
        ep.commence((ServletRequest)request, (ServletResponse)response);
        CaptchaEntryPointTests.assertEquals((String)("http://www.example.com:8888/hello?original_requestUrl=" + URLEncoder.encode("http://www.example.com:8888/some_path", "UTF-8") + "&original_request_method=post"), (String)response.getRedirectedUrl());
        ep.setIncludeOriginalParameters(true);
        request.addParameter("name", "value");
        request.addParameter("name1", "value2");
        response = new MockHttpServletResponse();
        ep.commence((ServletRequest)request, (ServletResponse)response);
        CaptchaEntryPointTests.assertEquals((String)("http://www.example.com:8888/hello?original_requestUrl=" + URLEncoder.encode("http://www.example.com:8888/some_path", "UTF-8") + "&original_request_method=post" + "&original_request_parameters=" + URLEncoder.encode("name__value;;name1__value2", "UTF-8")), (String)response.getRedirectedUrl());
        ep.setCaptchaFormUrl("/hello?toto=titi");
        response = new MockHttpServletResponse();
        ep.commence((ServletRequest)request, (ServletResponse)response);
        CaptchaEntryPointTests.assertEquals((String)("http://www.example.com:8888/hello?toto=titi&original_requestUrl=" + URLEncoder.encode("http://www.example.com:8888/some_path", "UTF-8") + "&original_request_method=post" + "&original_request_parameters=" + URLEncoder.encode("name__value;;name1__value2", "UTF-8")), (String)response.getRedirectedUrl());
        ep.setForceHttps(true);
        response = new MockHttpServletResponse();
        ep.commence((ServletRequest)request, (ServletResponse)response);
        CaptchaEntryPointTests.assertEquals((String)("https://www.example.com:1234/hello?toto=titi&original_requestUrl=" + URLEncoder.encode("http://www.example.com:8888/some_path", "UTF-8") + "&original_request_method=post" + "&original_request_parameters=" + URLEncoder.encode("name__value;;name1__value2", "UTF-8")), (String)response.getRedirectedUrl());
    }

    public void testOperationWithOutsideWebApp() throws Exception {
        CaptchaEntryPoint ep = new CaptchaEntryPoint();
        ep.setCaptchaFormUrl("https://www.jcaptcha.net/dotest/");
        PortMapperImpl mapper = new PortMapperImpl();
        mapper.getTranslatedPortMappings().put(new Integer(8888), new Integer(1234));
        ep.setPortMapper((PortMapper)mapper);
        ep.setPortResolver((PortResolver)new MockPortResolver(8888, 1234));
        ep.setIncludeOriginalRequest(true);
        ep.setOutsideWebApp(true);
        ep.afterPropertiesSet();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/some_path");
        request.setScheme("http");
        request.setServerName("www.example.com");
        request.setMethod("post");
        request.setServerPort(8888);
        MockHttpServletResponse response = new MockHttpServletResponse();
        ep.afterPropertiesSet();
        ep.commence((ServletRequest)request, (ServletResponse)response);
        CaptchaEntryPointTests.assertEquals((String)("https://www.jcaptcha.net/dotest/?original_requestUrl=" + URLEncoder.encode("http://www.example.com:8888/some_path", "UTF-8") + "&original_request_method=post"), (String)response.getRedirectedUrl());
        request.addParameter("name", "value");
        response = new MockHttpServletResponse();
        ep.commence((ServletRequest)request, (ServletResponse)response);
        CaptchaEntryPointTests.assertEquals((String)("https://www.jcaptcha.net/dotest/?original_requestUrl=" + URLEncoder.encode("http://www.example.com:8888/some_path", "UTF-8") + "&original_request_method=post"), (String)response.getRedirectedUrl());
        ep.setIncludeOriginalParameters(true);
        request.addParameter("name", "value");
        request.addParameter("name1", "value2");
        response = new MockHttpServletResponse();
        ep.commence((ServletRequest)request, (ServletResponse)response);
        CaptchaEntryPointTests.assertEquals((String)("https://www.jcaptcha.net/dotest/?original_requestUrl=" + URLEncoder.encode("http://www.example.com:8888/some_path", "UTF-8") + "&original_request_method=post" + "&original_request_parameters=" + URLEncoder.encode("name__value;;name1__value2", "UTF-8")), (String)response.getRedirectedUrl());
        ep.setCaptchaFormUrl("https://www.jcaptcha.net/dotest/?toto=titi");
        response = new MockHttpServletResponse();
        ep.commence((ServletRequest)request, (ServletResponse)response);
        CaptchaEntryPointTests.assertEquals((String)("https://www.jcaptcha.net/dotest/?toto=titi&original_requestUrl=" + URLEncoder.encode("http://www.example.com:8888/some_path", "UTF-8") + "&original_request_method=post" + "&original_request_parameters=" + URLEncoder.encode("name__value;;name1__value2", "UTF-8")), (String)response.getRedirectedUrl());
        ep.setForceHttps(true);
        response = new MockHttpServletResponse();
        ep.commence((ServletRequest)request, (ServletResponse)response);
        CaptchaEntryPointTests.assertEquals((String)("https://www.jcaptcha.net/dotest/?toto=titi&original_requestUrl=" + URLEncoder.encode("http://www.example.com:8888/some_path", "UTF-8") + "&original_request_method=post" + "&original_request_parameters=" + URLEncoder.encode("name__value;;name1__value2", "UTF-8")), (String)response.getRedirectedUrl());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

