/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.captcha;

import org.acegisecurity.captcha.CaptchaSecurityContextImpl;
import org.acegisecurity.context.SecurityContextImplTests;

public class CaptchaSecurityContextImplTests
extends SecurityContextImplTests {
    public void testDefaultValues() {
        CaptchaSecurityContextImpl context = new CaptchaSecurityContextImpl();
        CaptchaSecurityContextImplTests.assertEquals((String)"should not be human", (boolean)false, (boolean)context.isHuman());
        CaptchaSecurityContextImplTests.assertEquals((String)"should be 0", (long)0L, (long)context.getLastPassedCaptchaDateInMillis());
        CaptchaSecurityContextImplTests.assertEquals((String)"should be 0", (int)0, (int)context.getHumanRestrictedResourcesRequestsCount());
    }

    public void testEquals() {
        CaptchaSecurityContextImpl context1 = new CaptchaSecurityContextImpl();
        CaptchaSecurityContextImpl context2 = new CaptchaSecurityContextImpl();
        CaptchaSecurityContextImplTests.assertEquals((Object)context1, (Object)context2);
        CaptchaSecurityContextImplTests.assertFalse((boolean)context1.isHuman());
        context1.setHuman();
        CaptchaSecurityContextImplTests.assertNotSame((Object)context1, (Object)context2);
        context1 = new CaptchaSecurityContextImpl();
        CaptchaSecurityContextImplTests.assertEquals((Object)context1, (Object)context2);
        context1.incrementHumanRestrictedRessoucesRequestsCount();
        CaptchaSecurityContextImplTests.assertNotSame((Object)context1, (Object)context2);
    }

    public void testHashcode() {
        CaptchaSecurityContextImpl context1 = new CaptchaSecurityContextImpl();
        CaptchaSecurityContextImpl context2 = new CaptchaSecurityContextImpl();
        CaptchaSecurityContextImplTests.assertEquals((int)context1.hashCode(), (int)context2.hashCode());
        CaptchaSecurityContextImplTests.assertFalse((boolean)context1.isHuman());
        context1.setHuman();
        CaptchaSecurityContextImplTests.assertTrue((context1.hashCode() != context2.hashCode() ? 1 : 0) != 0);
        context1 = new CaptchaSecurityContextImpl();
        CaptchaSecurityContextImplTests.assertEquals((int)context1.hashCode(), (int)context2.hashCode());
        context1.incrementHumanRestrictedRessoucesRequestsCount();
        CaptchaSecurityContextImplTests.assertTrue((context1 != context2 ? 1 : 0) != 0);
    }

    public void testIncrementRequests() {
        CaptchaSecurityContextImpl context = new CaptchaSecurityContextImpl();
        context.setHuman();
        CaptchaSecurityContextImplTests.assertEquals((String)"should be human", (boolean)true, (boolean)context.isHuman());
        CaptchaSecurityContextImplTests.assertEquals((String)"should be 0", (int)0, (int)context.getHumanRestrictedResourcesRequestsCount());
        context.incrementHumanRestrictedRessoucesRequestsCount();
        CaptchaSecurityContextImplTests.assertEquals((String)"should be 1", (int)1, (int)context.getHumanRestrictedResourcesRequestsCount());
    }

    public void testResetHuman() {
        CaptchaSecurityContextImpl context = new CaptchaSecurityContextImpl();
        context.setHuman();
        CaptchaSecurityContextImplTests.assertEquals((String)"should be human", (boolean)true, (boolean)context.isHuman());
        CaptchaSecurityContextImplTests.assertEquals((String)"should be 0", (int)0, (int)context.getHumanRestrictedResourcesRequestsCount());
        context.incrementHumanRestrictedRessoucesRequestsCount();
        CaptchaSecurityContextImplTests.assertEquals((String)"should be 1", (int)1, (int)context.getHumanRestrictedResourcesRequestsCount());
        long now = System.currentTimeMillis();
        context.setHuman();
        CaptchaSecurityContextImplTests.assertEquals((String)"should be 0", (int)0, (int)context.getHumanRestrictedResourcesRequestsCount());
        CaptchaSecurityContextImplTests.assertTrue((String)"should be more than 0", (context.getLastPassedCaptchaDateInMillis() - now >= 0L ? 1 : 0) != 0);
        CaptchaSecurityContextImplTests.assertTrue((String)"should be less than 0,1 seconde", (context.getLastPassedCaptchaDateInMillis() - now < 100L ? 1 : 0) != 0);
    }

    public void testSetHuman() {
        CaptchaSecurityContextImpl context = new CaptchaSecurityContextImpl();
        long now = System.currentTimeMillis();
        context.setHuman();
        CaptchaSecurityContextImplTests.assertEquals((String)"should be human", (boolean)true, (boolean)context.isHuman());
        CaptchaSecurityContextImplTests.assertTrue((String)"should be more than 0", (context.getLastPassedCaptchaDateInMillis() - now >= 0L ? 1 : 0) != 0);
        CaptchaSecurityContextImplTests.assertTrue((String)"should be less than 0,1 seconde", (context.getLastPassedCaptchaDateInMillis() - now < 100L ? 1 : 0) != 0);
        CaptchaSecurityContextImplTests.assertEquals((String)"should be 0", (int)0, (int)context.getHumanRestrictedResourcesRequestsCount());
    }
}

