/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.captcha;

import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import junit.framework.TestCase;
import org.acegisecurity.captcha.CaptchaSecurityContextImpl;
import org.acegisecurity.captcha.CaptchaServiceProxy;
import org.acegisecurity.captcha.CaptchaValidationProcessingFilter;
import org.acegisecurity.captcha.MockCaptchaServiceProxy;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.util.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;

public class CaptchaValidationProcessingFilterTests
extends TestCase {
    static /* synthetic */ Class class$java$lang$IllegalArgumentException;

    public void testAfterPropertiesSet() throws Exception {
        CaptchaValidationProcessingFilter filter = new CaptchaValidationProcessingFilter();
        try {
            filter.afterPropertiesSet();
            CaptchaValidationProcessingFilterTests.fail((String)"should have thrown an invalid argument exception");
        }
        catch (Exception e) {
            CaptchaValidationProcessingFilterTests.assertTrue((String)"should be an InvalidArgumentException", (boolean)(class$java$lang$IllegalArgumentException == null ? (class$java$lang$IllegalArgumentException = CaptchaValidationProcessingFilterTests.class$("java.lang.IllegalArgumentException")) : class$java$lang$IllegalArgumentException).isAssignableFrom(e.getClass()));
        }
        filter.setCaptchaService((CaptchaServiceProxy)new MockCaptchaServiceProxy());
        filter.afterPropertiesSet();
        filter.setCaptchaValidationParameter(null);
        try {
            filter.afterPropertiesSet();
            CaptchaValidationProcessingFilterTests.fail((String)"should have thrown an invalid argument exception");
        }
        catch (Exception e) {
            CaptchaValidationProcessingFilterTests.assertTrue((String)"should be an InvalidArgumentException", (boolean)(class$java$lang$IllegalArgumentException == null ? (class$java$lang$IllegalArgumentException = CaptchaValidationProcessingFilterTests.class$("java.lang.IllegalArgumentException")) : class$java$lang$IllegalArgumentException).isAssignableFrom(e.getClass()));
        }
    }

    public void testDoFilterWithRequestParameter() throws Exception {
        CaptchaSecurityContextImpl context = new CaptchaSecurityContextImpl();
        SecurityContextHolder.setContext((SecurityContext)context);
        MockHttpServletRequest request = new MockHttpServletRequest();
        CaptchaValidationProcessingFilter filter = new CaptchaValidationProcessingFilter();
        request.addParameter(filter.getCaptchaValidationParameter(), "");
        MockCaptchaServiceProxy service = new MockCaptchaServiceProxy();
        MockFilterChain chain = new MockFilterChain(true);
        filter.setCaptchaService((CaptchaServiceProxy)service);
        filter.doFilter((ServletRequest)request, null, (FilterChain)chain);
        CaptchaValidationProcessingFilterTests.assertTrue((String)"should have been called", (boolean)service.hasBeenCalled);
        CaptchaValidationProcessingFilterTests.assertFalse((String)"context should not have been updated", (boolean)context.isHuman());
        service.valid = true;
        filter.doFilter((ServletRequest)request, null, (FilterChain)chain);
        CaptchaValidationProcessingFilterTests.assertTrue((String)"should have been called", (boolean)service.hasBeenCalled);
        CaptchaValidationProcessingFilterTests.assertTrue((String)"context should have been updated", (boolean)context.isHuman());
    }

    public void testDoFilterWithoutRequestParameter() throws Exception {
        CaptchaSecurityContextImpl context = new CaptchaSecurityContextImpl();
        SecurityContextHolder.setContext((SecurityContext)context);
        MockHttpServletRequest request = new MockHttpServletRequest();
        CaptchaValidationProcessingFilter filter = new CaptchaValidationProcessingFilter();
        MockCaptchaServiceProxy service = new MockCaptchaServiceProxy();
        MockFilterChain chain = new MockFilterChain(true);
        filter.setCaptchaService((CaptchaServiceProxy)service);
        filter.doFilter((ServletRequest)request, null, (FilterChain)chain);
        CaptchaValidationProcessingFilterTests.assertFalse((String)"proxy should not have been called", (boolean)service.hasBeenCalled);
        CaptchaValidationProcessingFilterTests.assertFalse((String)"context should not have been updated", (boolean)context.isHuman());
        service.valid = true;
        filter.doFilter((ServletRequest)request, null, (FilterChain)chain);
        CaptchaValidationProcessingFilterTests.assertFalse((String)"proxy should not have been called", (boolean)service.hasBeenCalled);
        CaptchaValidationProcessingFilterTests.assertFalse((String)"context should not have been updated", (boolean)context.isHuman());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

