/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.concurrent;

import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import junit.framework.TestCase;
import org.acegisecurity.Authentication;
import org.acegisecurity.concurrent.ConcurrentLoginException;
import org.acegisecurity.concurrent.ConcurrentSessionControllerImpl;
import org.acegisecurity.concurrent.SessionRegistry;
import org.acegisecurity.concurrent.SessionRegistryImpl;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.ui.WebAuthenticationDetails;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpSession;

public class ConcurrentSessionControllerImplTests
extends TestCase {
    private Authentication createAuthentication(String user, String password) {
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)user, (Object)password);
        auth.setDetails((Object)this.createWebDetails((Authentication)auth));
        return auth;
    }

    private WebAuthenticationDetails createWebDetails(Authentication auth) {
        MockHttpSession session = new MockHttpSession();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setSession((HttpSession)session);
        request.setUserPrincipal((Principal)auth);
        return new WebAuthenticationDetails((HttpServletRequest)request);
    }

    public void testLifecycle() throws Exception {
        ConcurrentSessionControllerImpl sc = new ConcurrentSessionControllerImpl();
        SessionRegistryImpl registry = new SessionRegistryImpl();
        sc.setSessionRegistry((SessionRegistry)registry);
        Authentication auth = this.createAuthentication("bob", "1212");
        sc.checkAuthenticationAllowed(auth);
        sc.registerSuccessfulAuthentication(auth);
        String sessionId1 = ((WebAuthenticationDetails)auth.getDetails()).getSessionId();
        ConcurrentSessionControllerImplTests.assertFalse((boolean)registry.getSessionInformation(sessionId1).isExpired());
        sc.checkAuthenticationAllowed(auth);
        sc.registerSuccessfulAuthentication(auth);
        sc.setExceptionIfMaximumExceeded(true);
        Authentication auth2 = this.createAuthentication("bob", "1212");
        ConcurrentSessionControllerImplTests.assertFalse((boolean)registry.getSessionInformation(sessionId1).isExpired());
        try {
            sc.checkAuthenticationAllowed(auth2);
            ConcurrentSessionControllerImplTests.fail((String)"Should have thrown ConcurrentLoginException");
        }
        catch (ConcurrentLoginException expected) {
            ConcurrentSessionControllerImplTests.assertTrue((boolean)true);
        }
        sc.setExceptionIfMaximumExceeded(false);
        Authentication auth3 = this.createAuthentication("bob", "1212");
        sc.checkAuthenticationAllowed(auth3);
        sc.registerSuccessfulAuthentication(auth3);
        String sessionId3 = ((WebAuthenticationDetails)auth3.getDetails()).getSessionId();
        ConcurrentSessionControllerImplTests.assertTrue((boolean)registry.getSessionInformation(sessionId1).isExpired());
        ConcurrentSessionControllerImplTests.assertFalse((boolean)registry.getSessionInformation(sessionId3).isExpired());
    }

    public void testStartupDetectsInvalidMaximumSessions() throws Exception {
        ConcurrentSessionControllerImpl sc = new ConcurrentSessionControllerImpl();
        sc.setMaximumSessions(0);
        try {
            sc.afterPropertiesSet();
            ConcurrentSessionControllerImplTests.fail((String)"Should have thrown IAE");
        }
        catch (IllegalArgumentException expected) {
            ConcurrentSessionControllerImplTests.assertTrue((boolean)true);
        }
    }

    public void testStartupDetectsInvalidSessionRegistry() throws Exception {
        ConcurrentSessionControllerImpl sc = new ConcurrentSessionControllerImpl();
        sc.setSessionRegistry(null);
        try {
            sc.afterPropertiesSet();
            ConcurrentSessionControllerImplTests.fail((String)"Should have thrown IAE");
        }
        catch (IllegalArgumentException expected) {
            ConcurrentSessionControllerImplTests.assertTrue((boolean)true);
        }
    }
}

