/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.context;

import java.util.Random;
import junit.framework.ComparisonFailure;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.context.SecurityContextImpl;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;

public class SecurityContextHolderTests
extends TestCase {
    private static int errors = 0;
    private static final int NUM_OPS = 25;
    private static final int NUM_THREADS = 10;
    static /* synthetic */ Class class$org$acegisecurity$context$SecurityContextHolderTests;
    static /* synthetic */ Class class$org$acegisecurity$context$InheritableThreadLocalSecurityContextHolderStrategy;

    public SecurityContextHolderTests() {
    }

    public SecurityContextHolderTests(String arg0) {
        super(arg0);
    }

    private void loadStartAndWaitForThreads(boolean topLevelThread, String prefix, int createThreads, boolean expectAllThreadsToUseIdenticalAuthentication, boolean expectChildrenToShareAuthenticationWithParent) {
        Thread[] threads = new Thread[createThreads];
        errors = 0;
        if (topLevelThread) {
            if (expectChildrenToShareAuthenticationWithParent) {
                for (int i = 0; i < threads.length; ++i) {
                    threads[i] = i % 2 == 0 ? this.makeThread(prefix + "Unauth_Parent_" + i, true, false, false, true, null) : this.makeThread(prefix + "Auth_Parent_" + i, true, true, false, true, prefix + "Auth_Parent_" + i);
                }
            } else if (expectAllThreadsToUseIdenticalAuthentication) {
                SecurityContextHolder.getContext().setAuthentication((Authentication)new UsernamePasswordAuthenticationToken((Object)"GLOBAL_USERNAME", (Object)"pass"));
                for (int i = 0; i < threads.length; ++i) {
                    threads[i] = i % 2 == 0 ? this.makeThread(prefix + "Unauth_Parent_" + i, true, false, true, true, "GLOBAL_USERNAME") : this.makeThread(prefix + "Auth_Parent_" + i, true, true, true, true, "GLOBAL_USERNAME");
                }
            } else {
                for (int i = 0; i < threads.length; ++i) {
                    threads[i] = i % 2 == 0 ? this.makeThread(prefix + "Unauth_Parent_" + i, true, false, false, false, null) : this.makeThread(prefix + "Auth_Parent_" + i, true, true, false, false, prefix + "Auth_Parent_" + i);
                }
            }
        } else if (expectChildrenToShareAuthenticationWithParent || expectAllThreadsToUseIdenticalAuthentication) {
            for (int i = 0; i < threads.length; ++i) {
                String expectedUsername = prefix;
                if (expectAllThreadsToUseIdenticalAuthentication) {
                    expectedUsername = "GLOBAL_USERNAME";
                }
                threads[i] = this.makeThread(prefix + "->child->Inherited_Auth_Child_" + i, false, false, expectAllThreadsToUseIdenticalAuthentication, false, expectedUsername);
            }
        } else {
            for (int i = 0; i < threads.length; ++i) {
                threads[i] = this.makeThread(prefix + "->child->Unauth_Child_" + i, false, false, false, false, null);
            }
        }
        this.startAndRun(threads);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$context$SecurityContextHolderTests == null ? (class$org$acegisecurity$context$SecurityContextHolderTests = SecurityContextHolderTests.class$("org.acegisecurity.context.SecurityContextHolderTests")) : class$org$acegisecurity$context$SecurityContextHolderTests));
    }

    private Thread makeThread(final String threadIdentifier, final boolean topLevelThread, final boolean injectAuthIntoCurrentThread, final boolean expectAllThreadsToUseIdenticalAuthentication, final boolean expectChildrenToShareAuthenticationWithParent, final String expectedUsername) {
        final Random rnd = new Random();
        Thread t = new Thread(new Runnable(){

            public void run() {
                if (injectAuthIntoCurrentThread) {
                    SecurityContextHolder.getContext().setAuthentication((Authentication)new UsernamePasswordAuthenticationToken((Object)expectedUsername, (Object)"pass"));
                }
                for (int i = 0; i < 25; ++i) {
                    String currentUsername;
                    String string = currentUsername = SecurityContextHolder.getContext().getAuthentication() == null ? null : SecurityContextHolder.getContext().getAuthentication().getName();
                    if (i % 7 == 0) {
                        System.out.println(threadIdentifier + " at " + i + " username " + currentUsername);
                    }
                    try {
                        TestCase.assertEquals((String)("Failed on iteration " + i + "; Authentication was '" + currentUsername + "' but principal was expected to contain username '" + expectedUsername + "'"), (String)expectedUsername, (String)currentUsername);
                    }
                    catch (ComparisonFailure err) {
                        errors++;
                        throw err;
                    }
                    try {
                        Thread.sleep(rnd.nextInt(250));
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (topLevelThread) {
                    if (injectAuthIntoCurrentThread && expectChildrenToShareAuthenticationWithParent) {
                        SecurityContextHolderTests.this.loadStartAndWaitForThreads(false, threadIdentifier, 4, expectAllThreadsToUseIdenticalAuthentication, true);
                    } else {
                        SecurityContextHolderTests.this.loadStartAndWaitForThreads(false, threadIdentifier, 4, expectAllThreadsToUseIdenticalAuthentication, false);
                    }
                }
            }
        }, threadIdentifier);
        return t;
    }

    public final void setUp() throws Exception {
        SecurityContextHolder.setStrategyName((String)"MODE_INHERITABLETHREADLOCAL");
    }

    private void startAndRun(Thread[] threads) {
        for (int i = 0; i < threads.length; ++i) {
            threads[i].start();
        }
        while (this.stillRunning(threads)) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private boolean stillRunning(Thread[] threads) {
        for (int i = 0; i < threads.length; ++i) {
            if (!threads[i].isAlive()) continue;
            return true;
        }
        return false;
    }

    public void testContextHolderGetterSetterClearer() {
        SecurityContextImpl sc = new SecurityContextImpl();
        sc.setAuthentication((Authentication)new UsernamePasswordAuthenticationToken((Object)"Foobar", (Object)"pass"));
        SecurityContextHolder.setContext((SecurityContext)sc);
        SecurityContextHolderTests.assertEquals((Object)sc, (Object)SecurityContextHolder.getContext());
        SecurityContextHolder.clearContext();
        SecurityContextHolderTests.assertNotSame((Object)sc, (Object)SecurityContextHolder.getContext());
        SecurityContextHolder.clearContext();
    }

    public void testNeverReturnsNull() {
        SecurityContextHolderTests.assertNotNull((Object)SecurityContextHolder.getContext());
        SecurityContextHolder.clearContext();
    }

    public void testRejectsNulls() {
        try {
            SecurityContextHolder.setContext(null);
            SecurityContextHolderTests.fail((String)"Should have rejected null");
        }
        catch (IllegalArgumentException expected) {
            SecurityContextHolderTests.assertTrue((boolean)true);
        }
    }

    public void testSynchronizationCustomStrategyLoading() {
        SecurityContextHolder.setStrategyName((String)(class$org$acegisecurity$context$InheritableThreadLocalSecurityContextHolderStrategy == null ? (class$org$acegisecurity$context$InheritableThreadLocalSecurityContextHolderStrategy = SecurityContextHolderTests.class$("org.acegisecurity.context.InheritableThreadLocalSecurityContextHolderStrategy")) : class$org$acegisecurity$context$InheritableThreadLocalSecurityContextHolderStrategy).getName());
        SecurityContextHolderTests.assertTrue((new SecurityContextHolder().toString().lastIndexOf("SecurityContextHolder[strategy='org.acegisecurity.context.InheritableThreadLocalSecurityContextHolderStrategy'") != -1 ? 1 : 0) != 0);
        this.loadStartAndWaitForThreads(true, "Main_", 10, false, true);
        SecurityContextHolderTests.assertEquals((String)"Thread errors detected; review log output for details", (int)0, (int)errors);
    }

    public void testSynchronizationGlobal() throws Exception {
        SecurityContextHolder.clearContext();
        SecurityContextHolder.setStrategyName((String)"MODE_GLOBAL");
        this.loadStartAndWaitForThreads(true, "Main_", 10, true, false);
        SecurityContextHolderTests.assertEquals((String)"Thread errors detected; review log output for details", (int)0, (int)errors);
    }

    public void testSynchronizationInheritableThreadLocal() throws Exception {
        SecurityContextHolder.clearContext();
        SecurityContextHolder.setStrategyName((String)"MODE_INHERITABLETHREADLOCAL");
        this.loadStartAndWaitForThreads(true, "Main_", 10, false, true);
        SecurityContextHolderTests.assertEquals((String)"Thread errors detected; review log output for details", (int)0, (int)errors);
    }

    public void testSynchronizationThreadLocal() throws Exception {
        SecurityContextHolder.clearContext();
        SecurityContextHolder.setStrategyName((String)"MODE_THREADLOCAL");
        this.loadStartAndWaitForThreads(true, "Main_", 10, false, false);
        SecurityContextHolderTests.assertEquals((String)"Thread errors detected; review log output for details", (int)0, (int)errors);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

