/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.context.httpinvoker;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.context.httpinvoker.AuthenticationSimpleHttpInvokerRequestExecutor;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;

public class AuthenticationSimpleHttpInvokerRequestExecutorTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$context$httpinvoker$AuthenticationSimpleHttpInvokerRequestExecutorTests;

    public AuthenticationSimpleHttpInvokerRequestExecutorTests() {
    }

    public AuthenticationSimpleHttpInvokerRequestExecutorTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$context$httpinvoker$AuthenticationSimpleHttpInvokerRequestExecutorTests == null ? (class$org$acegisecurity$context$httpinvoker$AuthenticationSimpleHttpInvokerRequestExecutorTests = AuthenticationSimpleHttpInvokerRequestExecutorTests.class$("org.acegisecurity.context.httpinvoker.AuthenticationSimpleHttpInvokerRequestExecutorTests")) : class$org$acegisecurity$context$httpinvoker$AuthenticationSimpleHttpInvokerRequestExecutorTests));
    }

    public void testNormalOperation() throws Exception {
        UsernamePasswordAuthenticationToken clientSideAuthentication = new UsernamePasswordAuthenticationToken((Object)"Aladdin", (Object)"open sesame");
        SecurityContextHolder.getContext().setAuthentication((Authentication)clientSideAuthentication);
        AuthenticationSimpleHttpInvokerRequestExecutor executor = new AuthenticationSimpleHttpInvokerRequestExecutor();
        MockHttpURLConnection conn = new MockHttpURLConnection(new URL("http://localhost/"));
        executor.prepareConnection((HttpURLConnection)conn, 10);
        AuthenticationSimpleHttpInvokerRequestExecutorTests.assertEquals((String)"Basic QWxhZGRpbjpvcGVuIHNlc2FtZQ==", (String)((URLConnection)conn).getRequestProperty("Authorization"));
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    public void testNullContextHolderIsNull() throws Exception {
        SecurityContextHolder.getContext().setAuthentication(null);
        AuthenticationSimpleHttpInvokerRequestExecutor executor = new AuthenticationSimpleHttpInvokerRequestExecutor();
        MockHttpURLConnection conn = new MockHttpURLConnection(new URL("http://localhost/"));
        executor.prepareConnection((HttpURLConnection)conn, 10);
        AuthenticationSimpleHttpInvokerRequestExecutorTests.assertNull((Object)((URLConnection)conn).getRequestProperty("Authorization"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MockHttpURLConnection
    extends HttpURLConnection {
        private Map requestProperties = new HashMap();

        public MockHttpURLConnection(URL u) {
            super(u);
        }

        public void connect() throws IOException {
            throw new UnsupportedOperationException("mock not implemented");
        }

        public void disconnect() {
            throw new UnsupportedOperationException("mock not implemented");
        }

        public String getRequestProperty(String key) {
            return (String)this.requestProperties.get(key);
        }

        public void setRequestProperty(String key, String value) {
            this.requestProperties.put(key, value);
        }

        public boolean usingProxy() {
            throw new UnsupportedOperationException("mock not implemented");
        }
    }
}

