/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.event.authentication;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.DisabledException;
import org.acegisecurity.event.authentication.AuthenticationFailureDisabledEvent;
import org.acegisecurity.event.authentication.AuthenticationSuccessEvent;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;

public class AuthenticationEventTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$event$authentication$AuthenticationEventTests;

    private Authentication getAuthentication() {
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)"Principal", (Object)"Credentials");
        authentication.setDetails((Object)"127.0.0.1");
        return authentication;
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$event$authentication$AuthenticationEventTests == null ? (class$org$acegisecurity$event$authentication$AuthenticationEventTests = AuthenticationEventTests.class$("org.acegisecurity.event.authentication.AuthenticationEventTests")) : class$org$acegisecurity$event$authentication$AuthenticationEventTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testAbstractAuthenticationEvent() {
        Authentication auth = this.getAuthentication();
        AuthenticationSuccessEvent event = new AuthenticationSuccessEvent(auth);
        AuthenticationEventTests.assertEquals((Object)auth, (Object)event.getAuthentication());
    }

    public void testAbstractAuthenticationFailureEvent() {
        Authentication auth = this.getAuthentication();
        DisabledException exception = new DisabledException("TEST");
        AuthenticationFailureDisabledEvent event = new AuthenticationFailureDisabledEvent(auth, (AuthenticationException)exception);
        AuthenticationEventTests.assertEquals((Object)auth, (Object)event.getAuthentication());
        AuthenticationEventTests.assertEquals((Object)exception, (Object)event.getException());
    }

    public void testRejectsNullAuthentication() {
        DisabledException exception = new DisabledException("TEST");
        try {
            AuthenticationFailureDisabledEvent event = new AuthenticationFailureDisabledEvent(null, (AuthenticationException)exception);
            AuthenticationEventTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AuthenticationEventTests.assertTrue((boolean)true);
        }
    }

    public void testRejectsNullAuthenticationException() {
        try {
            new AuthenticationFailureDisabledEvent(this.getAuthentication(), null);
            AuthenticationEventTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AuthenticationEventTests.assertTrue((boolean)true);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

