/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.intercept;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.MockAccessDecisionManager;
import org.acegisecurity.MockAfterInvocationManager;
import org.acegisecurity.MockAuthenticationManager;
import org.acegisecurity.MockRunAsManager;
import org.acegisecurity.intercept.AbstractSecurityInterceptor;
import org.acegisecurity.intercept.ObjectDefinitionSource;
import org.acegisecurity.intercept.method.MockMethodDefinitionSource;
import org.acegisecurity.util.SimpleMethodInvocation;

public class AbstractSecurityInterceptorTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$intercept$AbstractSecurityInterceptorTests;
    static /* synthetic */ Class class$java$lang$String;

    public AbstractSecurityInterceptorTests() {
    }

    public AbstractSecurityInterceptorTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$intercept$AbstractSecurityInterceptorTests == null ? (class$org$acegisecurity$intercept$AbstractSecurityInterceptorTests = AbstractSecurityInterceptorTests.class$("org.acegisecurity.intercept.AbstractSecurityInterceptorTests")) : class$org$acegisecurity$intercept$AbstractSecurityInterceptorTests));
    }

    public void testDetectsIfInvocationPassedIncompatibleSecureObject() throws Exception {
        MockSecurityInterceptorWhichOnlySupportsStrings si = new MockSecurityInterceptorWhichOnlySupportsStrings();
        si.setRunAsManager(new MockRunAsManager());
        si.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        si.setAfterInvocationManager(new MockAfterInvocationManager());
        si.setAccessDecisionManager(new MockAccessDecisionManager());
        si.setObjectDefinitionSource((ObjectDefinitionSource)new MockMethodDefinitionSource(false, true));
        try {
            si.beforeInvocation(new SimpleMethodInvocation());
            AbstractSecurityInterceptorTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AbstractSecurityInterceptorTests.assertTrue((boolean)expected.getMessage().startsWith("Security invocation attempted for object"));
        }
    }

    public void testDetectsViolationOfGetSecureObjectClassMethod() throws Exception {
        MockSecurityInterceptorReturnsNull si = new MockSecurityInterceptorReturnsNull();
        si.setRunAsManager(new MockRunAsManager());
        si.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        si.setAfterInvocationManager(new MockAfterInvocationManager());
        si.setAccessDecisionManager(new MockAccessDecisionManager());
        si.setObjectDefinitionSource((ObjectDefinitionSource)new MockMethodDefinitionSource(false, true));
        try {
            si.afterPropertiesSet();
            AbstractSecurityInterceptorTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AbstractSecurityInterceptorTests.assertEquals((String)"Subclass must provide a non-null response to getSecureObjectClass()", (String)expected.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MockSecurityInterceptorWhichOnlySupportsStrings
    extends AbstractSecurityInterceptor {
        private ObjectDefinitionSource objectDefinitionSource;

        private MockSecurityInterceptorWhichOnlySupportsStrings() {
        }

        public Class getSecureObjectClass() {
            return class$java$lang$String == null ? (class$java$lang$String = AbstractSecurityInterceptorTests.class$("java.lang.String")) : class$java$lang$String;
        }

        public ObjectDefinitionSource obtainObjectDefinitionSource() {
            return this.objectDefinitionSource;
        }

        public void setObjectDefinitionSource(ObjectDefinitionSource objectDefinitionSource) {
            this.objectDefinitionSource = objectDefinitionSource;
        }
    }

    private class MockSecurityInterceptorReturnsNull
    extends AbstractSecurityInterceptor {
        private ObjectDefinitionSource objectDefinitionSource;

        private MockSecurityInterceptorReturnsNull() {
        }

        public Class getSecureObjectClass() {
            return null;
        }

        public ObjectDefinitionSource obtainObjectDefinitionSource() {
            return this.objectDefinitionSource;
        }

        public void setObjectDefinitionSource(ObjectDefinitionSource objectDefinitionSource) {
            this.objectDefinitionSource = objectDefinitionSource;
        }
    }
}

