/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.intercept.method;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.Authentication;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.ITargetObject;
import org.acegisecurity.SecurityConfig;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.intercept.method.MethodDefinitionAttributes;
import org.acegisecurity.intercept.method.MockAttributes;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.util.SimpleMethodInvocation;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.metadata.Attributes;

public class MethodDefinitionAttributesTests
extends TestCase {
    ClassPathXmlApplicationContext applicationContext;
    static /* synthetic */ Class class$org$acegisecurity$intercept$method$MethodDefinitionAttributesTests;
    static /* synthetic */ Class class$org$acegisecurity$ITargetObject;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$acegisecurity$OtherTargetObject;
    static /* synthetic */ Class class$org$acegisecurity$TargetObject;
    static /* synthetic */ Class class$org$acegisecurity$acl$basic$SomeDomain;

    public MethodDefinitionAttributesTests(String a) {
        super(a);
    }

    private ConfigAttributeDefinition getConfigAttributeDefinition(Class clazz, String methodName, Class[] args) throws Exception {
        final Method method = clazz.getMethod(methodName, args);
        MethodDefinitionAttributes source = new MethodDefinitionAttributes();
        source.setAttributes((Attributes)new MockAttributes());
        ConfigAttributeDefinition config = source.getAttributes((Object)new SimpleMethodInvocation(){

            public Method getMethod() {
                return method;
            }
        });
        return config;
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$intercept$method$MethodDefinitionAttributesTests == null ? (class$org$acegisecurity$intercept$method$MethodDefinitionAttributesTests = MethodDefinitionAttributesTests.class$("org.acegisecurity.intercept.method.MethodDefinitionAttributesTests")) : class$org$acegisecurity$intercept$method$MethodDefinitionAttributesTests));
    }

    private ITargetObject makeInterceptedTarget() {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("org/acegisecurity/intercept/method/applicationContext.xml");
        return (ITargetObject)context.getBean("target");
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testAttributesForInterfaceTargetObject() throws Exception {
        ConfigAttributeDefinition def1 = this.getConfigAttributeDefinition(class$org$acegisecurity$ITargetObject == null ? (class$org$acegisecurity$ITargetObject = MethodDefinitionAttributesTests.class$("org.acegisecurity.ITargetObject")) : class$org$acegisecurity$ITargetObject, "countLength", new Class[]{class$java$lang$String == null ? (class$java$lang$String = MethodDefinitionAttributesTests.class$("java.lang.String")) : class$java$lang$String});
        Set set1 = this.toSet(def1);
        MethodDefinitionAttributesTests.assertTrue((boolean)set1.contains(new SecurityConfig("MOCK_INTERFACE")));
        MethodDefinitionAttributesTests.assertTrue((boolean)set1.contains(new SecurityConfig("MOCK_INTERFACE_METHOD_COUNT_LENGTH")));
        ConfigAttributeDefinition def2 = this.getConfigAttributeDefinition(class$org$acegisecurity$ITargetObject == null ? (class$org$acegisecurity$ITargetObject = MethodDefinitionAttributesTests.class$("org.acegisecurity.ITargetObject")) : class$org$acegisecurity$ITargetObject, "makeLowerCase", new Class[]{class$java$lang$String == null ? (class$java$lang$String = MethodDefinitionAttributesTests.class$("java.lang.String")) : class$java$lang$String});
        Set set2 = this.toSet(def2);
        MethodDefinitionAttributesTests.assertTrue((boolean)set2.contains(new SecurityConfig("MOCK_INTERFACE")));
        MethodDefinitionAttributesTests.assertTrue((boolean)set2.contains(new SecurityConfig("MOCK_INTERFACE_METHOD_MAKE_LOWER_CASE")));
        ConfigAttributeDefinition def3 = this.getConfigAttributeDefinition(class$org$acegisecurity$ITargetObject == null ? (class$org$acegisecurity$ITargetObject = MethodDefinitionAttributesTests.class$("org.acegisecurity.ITargetObject")) : class$org$acegisecurity$ITargetObject, "makeUpperCase", new Class[]{class$java$lang$String == null ? (class$java$lang$String = MethodDefinitionAttributesTests.class$("java.lang.String")) : class$java$lang$String});
        Set set3 = this.toSet(def3);
        MethodDefinitionAttributesTests.assertTrue((boolean)set3.contains(new SecurityConfig("MOCK_INTERFACE")));
        MethodDefinitionAttributesTests.assertTrue((boolean)set3.contains(new SecurityConfig("MOCK_INTERFACE_METHOD_MAKE_UPPER_CASE")));
    }

    public void testAttributesForOtherTargetObject() throws Exception {
        ConfigAttributeDefinition def1 = this.getConfigAttributeDefinition(class$org$acegisecurity$OtherTargetObject == null ? (class$org$acegisecurity$OtherTargetObject = MethodDefinitionAttributesTests.class$("org.acegisecurity.OtherTargetObject")) : class$org$acegisecurity$OtherTargetObject, "countLength", new Class[]{class$java$lang$String == null ? (class$java$lang$String = MethodDefinitionAttributesTests.class$("java.lang.String")) : class$java$lang$String});
        Set set1 = this.toSet(def1);
        MethodDefinitionAttributesTests.assertTrue((boolean)set1.contains(new SecurityConfig("MOCK_INTERFACE")));
        MethodDefinitionAttributesTests.assertTrue((boolean)set1.contains(new SecurityConfig("MOCK_INTERFACE_METHOD_COUNT_LENGTH")));
        MethodDefinitionAttributesTests.assertEquals((int)2, (int)set1.size());
        ConfigAttributeDefinition def2 = this.getConfigAttributeDefinition(class$org$acegisecurity$OtherTargetObject == null ? (class$org$acegisecurity$OtherTargetObject = MethodDefinitionAttributesTests.class$("org.acegisecurity.OtherTargetObject")) : class$org$acegisecurity$OtherTargetObject, "makeLowerCase", new Class[]{class$java$lang$String == null ? (class$java$lang$String = MethodDefinitionAttributesTests.class$("java.lang.String")) : class$java$lang$String});
        Set set2 = this.toSet(def2);
        MethodDefinitionAttributesTests.assertTrue((boolean)set2.contains(new SecurityConfig("MOCK_INTERFACE")));
        MethodDefinitionAttributesTests.assertTrue((boolean)set2.contains(new SecurityConfig("MOCK_INTERFACE_METHOD_MAKE_LOWER_CASE")));
        MethodDefinitionAttributesTests.assertTrue((boolean)set2.contains(new SecurityConfig("MOCK_CLASS_METHOD_MAKE_LOWER_CASE")));
        MethodDefinitionAttributesTests.assertEquals((int)3, (int)set2.size());
        ConfigAttributeDefinition def3 = this.getConfigAttributeDefinition(class$org$acegisecurity$OtherTargetObject == null ? (class$org$acegisecurity$OtherTargetObject = MethodDefinitionAttributesTests.class$("org.acegisecurity.OtherTargetObject")) : class$org$acegisecurity$OtherTargetObject, "makeUpperCase", new Class[]{class$java$lang$String == null ? (class$java$lang$String = MethodDefinitionAttributesTests.class$("java.lang.String")) : class$java$lang$String});
        Set set3 = this.toSet(def3);
        MethodDefinitionAttributesTests.assertTrue((boolean)set3.contains(new SecurityConfig("MOCK_INTERFACE")));
        MethodDefinitionAttributesTests.assertTrue((boolean)set3.contains(new SecurityConfig("MOCK_INTERFACE_METHOD_MAKE_UPPER_CASE")));
        MethodDefinitionAttributesTests.assertTrue((boolean)set3.contains(new SecurityConfig("RUN_AS")));
        MethodDefinitionAttributesTests.assertEquals((int)3, (int)set3.size());
    }

    public void testAttributesForTargetObject() throws Exception {
        ConfigAttributeDefinition def1 = this.getConfigAttributeDefinition(class$org$acegisecurity$TargetObject == null ? (class$org$acegisecurity$TargetObject = MethodDefinitionAttributesTests.class$("org.acegisecurity.TargetObject")) : class$org$acegisecurity$TargetObject, "countLength", new Class[]{class$java$lang$String == null ? (class$java$lang$String = MethodDefinitionAttributesTests.class$("java.lang.String")) : class$java$lang$String});
        Set set1 = this.toSet(def1);
        MethodDefinitionAttributesTests.assertTrue((boolean)set1.contains(new SecurityConfig("MOCK_INTERFACE")));
        MethodDefinitionAttributesTests.assertTrue((boolean)set1.contains(new SecurityConfig("MOCK_INTERFACE_METHOD_COUNT_LENGTH")));
        MethodDefinitionAttributesTests.assertTrue((boolean)set1.contains(new SecurityConfig("MOCK_CLASS")));
        MethodDefinitionAttributesTests.assertEquals((int)3, (int)set1.size());
        ConfigAttributeDefinition def2 = this.getConfigAttributeDefinition(class$org$acegisecurity$TargetObject == null ? (class$org$acegisecurity$TargetObject = MethodDefinitionAttributesTests.class$("org.acegisecurity.TargetObject")) : class$org$acegisecurity$TargetObject, "makeLowerCase", new Class[]{class$java$lang$String == null ? (class$java$lang$String = MethodDefinitionAttributesTests.class$("java.lang.String")) : class$java$lang$String});
        Set set2 = this.toSet(def2);
        MethodDefinitionAttributesTests.assertTrue((boolean)set2.contains(new SecurityConfig("MOCK_INTERFACE")));
        MethodDefinitionAttributesTests.assertTrue((boolean)set2.contains(new SecurityConfig("MOCK_INTERFACE_METHOD_MAKE_LOWER_CASE")));
        MethodDefinitionAttributesTests.assertTrue((boolean)set2.contains(new SecurityConfig("MOCK_CLASS")));
        MethodDefinitionAttributesTests.assertTrue((boolean)set2.contains(new SecurityConfig("MOCK_CLASS_METHOD_MAKE_LOWER_CASE")));
        MethodDefinitionAttributesTests.assertEquals((int)4, (int)set2.size());
        ConfigAttributeDefinition def3 = this.getConfigAttributeDefinition(class$org$acegisecurity$TargetObject == null ? (class$org$acegisecurity$TargetObject = MethodDefinitionAttributesTests.class$("org.acegisecurity.TargetObject")) : class$org$acegisecurity$TargetObject, "makeUpperCase", new Class[]{class$java$lang$String == null ? (class$java$lang$String = MethodDefinitionAttributesTests.class$("java.lang.String")) : class$java$lang$String});
        Set set3 = this.toSet(def3);
        MethodDefinitionAttributesTests.assertTrue((boolean)set3.contains(new SecurityConfig("MOCK_INTERFACE")));
        MethodDefinitionAttributesTests.assertTrue((boolean)set3.contains(new SecurityConfig("MOCK_INTERFACE_METHOD_MAKE_UPPER_CASE")));
        MethodDefinitionAttributesTests.assertTrue((boolean)set3.contains(new SecurityConfig("MOCK_CLASS")));
        MethodDefinitionAttributesTests.assertTrue((boolean)set3.contains(new SecurityConfig("MOCK_CLASS_METHOD_MAKE_UPPER_CASE")));
        MethodDefinitionAttributesTests.assertTrue((boolean)set3.contains(new SecurityConfig("RUN_AS")));
        MethodDefinitionAttributesTests.assertEquals((int)5, (int)set3.size());
    }

    public void testMethodCallWithRunAsReplacement() throws Exception {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("MOCK_INTERFACE_METHOD_MAKE_UPPER_CASE")});
        SecurityContextHolder.getContext().setAuthentication((Authentication)token);
        ITargetObject target = this.makeInterceptedTarget();
        String result = target.makeUpperCase("hello");
        MethodDefinitionAttributesTests.assertEquals((String)"HELLO org.acegisecurity.MockRunAsAuthenticationToken true", (String)result);
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    public void testMethodCallWithoutRunAsReplacement() throws Exception {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("MOCK_INTERFACE_METHOD_MAKE_LOWER_CASE")});
        SecurityContextHolder.getContext().setAuthentication((Authentication)token);
        ITargetObject target = this.makeInterceptedTarget();
        String result = target.makeLowerCase("HELLO");
        MethodDefinitionAttributesTests.assertEquals((String)"hello org.acegisecurity.providers.UsernamePasswordAuthenticationToken true", (String)result);
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    public void testNullReturnedIfZeroAttributesDefinedForMethodInvocation() throws Exception {
        ConfigAttributeDefinition def = this.getConfigAttributeDefinition(class$org$acegisecurity$acl$basic$SomeDomain == null ? (class$org$acegisecurity$acl$basic$SomeDomain = MethodDefinitionAttributesTests.class$("org.acegisecurity.acl.basic.SomeDomain")) : class$org$acegisecurity$acl$basic$SomeDomain, "getId", null);
        MethodDefinitionAttributesTests.assertNull((Object)def);
    }

    private Set toSet(ConfigAttributeDefinition def) {
        HashSet<ConfigAttribute> set = new HashSet<ConfigAttribute>();
        Iterator i = def.getConfigAttributes();
        while (i.hasNext()) {
            ConfigAttribute a = (ConfigAttribute)i.next();
            set.add(a);
        }
        return set;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

