/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.intercept.method;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.Iterator;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.MockJoinPoint;
import org.acegisecurity.SecurityConfig;
import org.acegisecurity.TargetObject;
import org.acegisecurity.intercept.method.MethodDefinitionMap;
import org.acegisecurity.intercept.method.MethodDefinitionSourceEditor;
import org.aopalliance.intercept.MethodInvocation;

public class MethodDefinitionSourceEditorTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$intercept$method$MethodDefinitionSourceEditorTests;
    static /* synthetic */ Class class$org$acegisecurity$TargetObject;
    static /* synthetic */ Class class$java$lang$String;

    public MethodDefinitionSourceEditorTests() {
    }

    public MethodDefinitionSourceEditorTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$intercept$method$MethodDefinitionSourceEditorTests == null ? (class$org$acegisecurity$intercept$method$MethodDefinitionSourceEditorTests = MethodDefinitionSourceEditorTests.class$("org.acegisecurity.intercept.method.MethodDefinitionSourceEditorTests")) : class$org$acegisecurity$intercept$method$MethodDefinitionSourceEditorTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testAspectJJointPointLookup() throws Exception {
        MethodDefinitionSourceEditor editor = new MethodDefinitionSourceEditor();
        editor.setAsText("org.acegisecurity.TargetObject.countLength=ROLE_ONE,ROLE_TWO,RUN_AS_ENTRY");
        MethodDefinitionMap map = (MethodDefinitionMap)editor.getValue();
        Class clazz = class$org$acegisecurity$TargetObject == null ? (class$org$acegisecurity$TargetObject = MethodDefinitionSourceEditorTests.class$("org.acegisecurity.TargetObject")) : class$org$acegisecurity$TargetObject;
        Method method = clazz.getMethod("countLength", class$java$lang$String == null ? (class$java$lang$String = MethodDefinitionSourceEditorTests.class$("java.lang.String")) : class$java$lang$String);
        MockJoinPoint joinPoint = new MockJoinPoint(new TargetObject(), method);
        ConfigAttributeDefinition returnedCountLength = map.getAttributes((Object)joinPoint);
        ConfigAttributeDefinition expectedCountLength = new ConfigAttributeDefinition();
        expectedCountLength.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_ONE"));
        expectedCountLength.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_TWO"));
        expectedCountLength.addConfigAttribute((ConfigAttribute)new SecurityConfig("RUN_AS_ENTRY"));
        MethodDefinitionSourceEditorTests.assertEquals((Object)expectedCountLength, (Object)returnedCountLength);
    }

    public void testClassNameNotFoundResultsInException() {
        MethodDefinitionSourceEditor editor = new MethodDefinitionSourceEditor();
        try {
            editor.setAsText("org.acegisecurity.DOES_NOT_EXIST_NAME=FOO,BAR");
            MethodDefinitionSourceEditorTests.fail((String)"Should have given IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            MethodDefinitionSourceEditorTests.assertTrue((boolean)true);
        }
    }

    public void testClassNameNotInProperFormatResultsInException() {
        MethodDefinitionSourceEditor editor = new MethodDefinitionSourceEditor();
        try {
            editor.setAsText("DOES_NOT_EXIST_NAME=FOO,BAR");
            MethodDefinitionSourceEditorTests.fail((String)"Should have given IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            MethodDefinitionSourceEditorTests.assertTrue((boolean)true);
        }
    }

    public void testClassNameValidButMethodNameInvalidResultsInException() {
        MethodDefinitionSourceEditor editor = new MethodDefinitionSourceEditor();
        try {
            editor.setAsText("org.acegisecurity.TargetObject.INVALID_METHOD=FOO,BAR");
            MethodDefinitionSourceEditorTests.fail((String)"Should have given IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            MethodDefinitionSourceEditorTests.assertTrue((boolean)true);
        }
    }

    public void testConcreteClassInvocationsAlsoReturnDefinitionsAgainstInterface() throws Exception {
        MethodDefinitionSourceEditor editor = new MethodDefinitionSourceEditor();
        editor.setAsText("org.acegisecurity.ITargetObject.makeLower*=ROLE_FROM_INTERFACE\r\norg.acegisecurity.ITargetObject.makeUpper*=ROLE_FROM_INTERFACE\r\norg.acegisecurity.TargetObject.makeUpper*=ROLE_FROM_IMPLEMENTATION");
        MethodDefinitionMap map = (MethodDefinitionMap)editor.getValue();
        MethodDefinitionSourceEditorTests.assertEquals((int)3, (int)map.getMethodMapSize());
        ConfigAttributeDefinition returnedMakeLower = map.getAttributes((Object)new MockMethodInvocation(class$org$acegisecurity$TargetObject == null ? (class$org$acegisecurity$TargetObject = MethodDefinitionSourceEditorTests.class$("org.acegisecurity.TargetObject")) : class$org$acegisecurity$TargetObject, "makeLowerCase", new Class[]{class$java$lang$String == null ? (class$java$lang$String = MethodDefinitionSourceEditorTests.class$("java.lang.String")) : class$java$lang$String}));
        ConfigAttributeDefinition expectedMakeLower = new ConfigAttributeDefinition();
        expectedMakeLower.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_FROM_INTERFACE"));
        MethodDefinitionSourceEditorTests.assertEquals((Object)expectedMakeLower, (Object)returnedMakeLower);
        ConfigAttributeDefinition returnedMakeUpper = map.getAttributes((Object)new MockMethodInvocation(class$org$acegisecurity$TargetObject == null ? (class$org$acegisecurity$TargetObject = MethodDefinitionSourceEditorTests.class$("org.acegisecurity.TargetObject")) : class$org$acegisecurity$TargetObject, "makeUpperCase", new Class[]{class$java$lang$String == null ? (class$java$lang$String = MethodDefinitionSourceEditorTests.class$("java.lang.String")) : class$java$lang$String}));
        ConfigAttributeDefinition expectedMakeUpper = new ConfigAttributeDefinition();
        expectedMakeUpper.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_FROM_IMPLEMENTATION"));
        expectedMakeUpper.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_FROM_INTERFACE"));
        MethodDefinitionSourceEditorTests.assertEquals((Object)expectedMakeUpper, (Object)returnedMakeUpper);
    }

    public void testEmptyStringReturnsEmptyMap() {
        MethodDefinitionSourceEditor editor = new MethodDefinitionSourceEditor();
        editor.setAsText("");
        MethodDefinitionMap map = (MethodDefinitionMap)editor.getValue();
        MethodDefinitionSourceEditorTests.assertEquals((int)0, (int)map.getMethodMapSize());
    }

    public void testIterator() {
        MethodDefinitionSourceEditor editor = new MethodDefinitionSourceEditor();
        editor.setAsText("org.acegisecurity.TargetObject.countLength=ROLE_ONE,ROLE_TWO,RUN_AS_ENTRY\r\norg.acegisecurity.TargetObject.make*=ROLE_NINE,ROLE_SUPERVISOR");
        MethodDefinitionMap map = (MethodDefinitionMap)editor.getValue();
        Iterator iter = map.getConfigAttributeDefinitions();
        int counter = 0;
        while (iter.hasNext()) {
            iter.next();
            ++counter;
        }
        MethodDefinitionSourceEditorTests.assertEquals((int)3, (int)counter);
    }

    public void testMultiMethodParsing() {
        MethodDefinitionSourceEditor editor = new MethodDefinitionSourceEditor();
        editor.setAsText("org.acegisecurity.TargetObject.countLength=ROLE_ONE,ROLE_TWO,RUN_AS_ENTRY\r\norg.acegisecurity.TargetObject.make*=ROLE_NINE,ROLE_SUPERVISOR");
        MethodDefinitionMap map = (MethodDefinitionMap)editor.getValue();
        MethodDefinitionSourceEditorTests.assertEquals((int)3, (int)map.getMethodMapSize());
    }

    public void testMultiMethodParsingWhereLaterMethodsOverrideEarlierMethods() throws Exception {
        MethodDefinitionSourceEditor editor = new MethodDefinitionSourceEditor();
        editor.setAsText("org.acegisecurity.TargetObject.*=ROLE_GENERAL\r\norg.acegisecurity.TargetObject.makeLower*=ROLE_LOWER\r\norg.acegisecurity.TargetObject.make*=ROLE_MAKE\r\norg.acegisecurity.TargetObject.makeUpper*=ROLE_UPPER");
        MethodDefinitionMap map = (MethodDefinitionMap)editor.getValue();
        MethodDefinitionSourceEditorTests.assertEquals((int)5, (int)map.getMethodMapSize());
        ConfigAttributeDefinition returnedMakeLower = map.getAttributes((Object)new MockMethodInvocation(class$org$acegisecurity$TargetObject == null ? (class$org$acegisecurity$TargetObject = MethodDefinitionSourceEditorTests.class$("org.acegisecurity.TargetObject")) : class$org$acegisecurity$TargetObject, "makeLowerCase", new Class[]{class$java$lang$String == null ? (class$java$lang$String = MethodDefinitionSourceEditorTests.class$("java.lang.String")) : class$java$lang$String}));
        ConfigAttributeDefinition expectedMakeLower = new ConfigAttributeDefinition();
        expectedMakeLower.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_LOWER"));
        MethodDefinitionSourceEditorTests.assertEquals((Object)expectedMakeLower, (Object)returnedMakeLower);
        ConfigAttributeDefinition returnedMakeUpper = map.getAttributes((Object)new MockMethodInvocation(class$org$acegisecurity$TargetObject == null ? (class$org$acegisecurity$TargetObject = MethodDefinitionSourceEditorTests.class$("org.acegisecurity.TargetObject")) : class$org$acegisecurity$TargetObject, "makeUpperCase", new Class[]{class$java$lang$String == null ? (class$java$lang$String = MethodDefinitionSourceEditorTests.class$("java.lang.String")) : class$java$lang$String}));
        ConfigAttributeDefinition expectedMakeUpper = new ConfigAttributeDefinition();
        expectedMakeUpper.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_UPPER"));
        MethodDefinitionSourceEditorTests.assertEquals((Object)expectedMakeUpper, (Object)returnedMakeUpper);
        ConfigAttributeDefinition returnedCountLength = map.getAttributes((Object)new MockMethodInvocation(class$org$acegisecurity$TargetObject == null ? (class$org$acegisecurity$TargetObject = MethodDefinitionSourceEditorTests.class$("org.acegisecurity.TargetObject")) : class$org$acegisecurity$TargetObject, "countLength", new Class[]{class$java$lang$String == null ? (class$java$lang$String = MethodDefinitionSourceEditorTests.class$("java.lang.String")) : class$java$lang$String}));
        ConfigAttributeDefinition expectedCountLength = new ConfigAttributeDefinition();
        expectedCountLength.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_GENERAL"));
        MethodDefinitionSourceEditorTests.assertEquals((Object)expectedCountLength, (Object)returnedCountLength);
    }

    public void testNullIsReturnedByMethodDefinitionSourceWhenMethodInvocationNotDefined() throws Exception {
        MethodDefinitionSourceEditor editor = new MethodDefinitionSourceEditor();
        editor.setAsText("org.acegisecurity.TargetObject.countLength=ROLE_ONE,ROLE_TWO,RUN_AS_ENTRY");
        MethodDefinitionMap map = (MethodDefinitionMap)editor.getValue();
        ConfigAttributeDefinition configAttributeDefinition = map.getAttributes((Object)new MockMethodInvocation(class$org$acegisecurity$TargetObject == null ? (class$org$acegisecurity$TargetObject = MethodDefinitionSourceEditorTests.class$("org.acegisecurity.TargetObject")) : class$org$acegisecurity$TargetObject, "makeLowerCase", new Class[]{class$java$lang$String == null ? (class$java$lang$String = MethodDefinitionSourceEditorTests.class$("java.lang.String")) : class$java$lang$String}));
        MethodDefinitionSourceEditorTests.assertNull((Object)configAttributeDefinition);
    }

    public void testNullReturnsEmptyMap() {
        MethodDefinitionSourceEditor editor = new MethodDefinitionSourceEditor();
        editor.setAsText(null);
        MethodDefinitionMap map = (MethodDefinitionMap)editor.getValue();
        MethodDefinitionSourceEditorTests.assertEquals((int)0, (int)map.getMethodMapSize());
    }

    public void testSingleMethodParsing() throws Exception {
        MethodDefinitionSourceEditor editor = new MethodDefinitionSourceEditor();
        editor.setAsText("org.acegisecurity.TargetObject.countLength=ROLE_ONE,ROLE_TWO,RUN_AS_ENTRY");
        MethodDefinitionMap map = (MethodDefinitionMap)editor.getValue();
        ConfigAttributeDefinition returnedCountLength = map.getAttributes((Object)new MockMethodInvocation(class$org$acegisecurity$TargetObject == null ? (class$org$acegisecurity$TargetObject = MethodDefinitionSourceEditorTests.class$("org.acegisecurity.TargetObject")) : class$org$acegisecurity$TargetObject, "countLength", new Class[]{class$java$lang$String == null ? (class$java$lang$String = MethodDefinitionSourceEditorTests.class$("java.lang.String")) : class$java$lang$String}));
        ConfigAttributeDefinition expectedCountLength = new ConfigAttributeDefinition();
        expectedCountLength.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_ONE"));
        expectedCountLength.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_TWO"));
        expectedCountLength.addConfigAttribute((ConfigAttribute)new SecurityConfig("RUN_AS_ENTRY"));
        MethodDefinitionSourceEditorTests.assertEquals((Object)expectedCountLength, (Object)returnedCountLength);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MockMethodInvocation
    implements MethodInvocation {
        Method method;

        private MockMethodInvocation() {
        }

        public MockMethodInvocation(Class clazz, String methodName, Class[] parameterTypes) throws NoSuchMethodException {
            this.method = clazz.getMethod(methodName, parameterTypes);
        }

        public Object[] getArguments() {
            return null;
        }

        public Method getMethod() {
            return this.method;
        }

        public AccessibleObject getStaticPart() {
            return null;
        }

        public Object getThis() {
            return null;
        }

        public Object proceed() throws Throwable {
            return null;
        }
    }
}

