/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.intercept.method;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.intercept.AbstractSecurityInterceptor;
import org.acegisecurity.intercept.method.MethodInvocationPrivilegeEvaluator;
import org.acegisecurity.intercept.method.aopalliance.MethodSecurityInterceptor;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.util.MethodInvocationUtils;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class MethodInvocationPrivilegeEvaluatorTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$intercept$method$MethodInvocationPrivilegeEvaluatorTests;
    static /* synthetic */ Class class$org$acegisecurity$ITargetObject;
    static /* synthetic */ Class class$java$lang$String;

    public MethodInvocationPrivilegeEvaluatorTests() {
    }

    public MethodInvocationPrivilegeEvaluatorTests(String arg0) {
        super(arg0);
    }

    private Object lookupTargetObject() {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("org/acegisecurity/intercept/method/aopalliance/applicationContext.xml");
        return context.getBean("target");
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$intercept$method$MethodInvocationPrivilegeEvaluatorTests == null ? (class$org$acegisecurity$intercept$method$MethodInvocationPrivilegeEvaluatorTests = MethodInvocationPrivilegeEvaluatorTests.class$("org.acegisecurity.intercept.method.MethodInvocationPrivilegeEvaluatorTests")) : class$org$acegisecurity$intercept$method$MethodInvocationPrivilegeEvaluatorTests));
    }

    private MethodSecurityInterceptor makeSecurityInterceptor() {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("org/acegisecurity/intercept/method/aopalliance/applicationContext.xml");
        return (MethodSecurityInterceptor)context.getBean("securityInterceptor");
    }

    public void testAllowsAccessUsingCreate() throws Exception {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("MOCK_LOWER")});
        Object object = this.lookupTargetObject();
        MethodInvocation mi = MethodInvocationUtils.create((Object)object, (String)"makeLowerCase", (Object[])new Object[]{"foobar"});
        MethodSecurityInterceptor interceptor = this.makeSecurityInterceptor();
        MethodInvocationPrivilegeEvaluator mipe = new MethodInvocationPrivilegeEvaluator();
        mipe.setSecurityInterceptor((AbstractSecurityInterceptor)interceptor);
        mipe.afterPropertiesSet();
        MethodInvocationPrivilegeEvaluatorTests.assertTrue((boolean)mipe.isAllowed(mi, (Authentication)token));
    }

    public void testAllowsAccessUsingCreateFromClass() throws Exception {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("MOCK_LOWER")});
        MethodInvocation mi = MethodInvocationUtils.createFromClass((Class)(class$org$acegisecurity$ITargetObject == null ? (class$org$acegisecurity$ITargetObject = MethodInvocationPrivilegeEvaluatorTests.class$("org.acegisecurity.ITargetObject")) : class$org$acegisecurity$ITargetObject), (String)"makeLowerCase", (Class[])new Class[]{class$java$lang$String == null ? (class$java$lang$String = MethodInvocationPrivilegeEvaluatorTests.class$("java.lang.String")) : class$java$lang$String}, (Object[])new Object[]{"Hello world"});
        MethodSecurityInterceptor interceptor = this.makeSecurityInterceptor();
        MethodInvocationPrivilegeEvaluator mipe = new MethodInvocationPrivilegeEvaluator();
        mipe.setSecurityInterceptor((AbstractSecurityInterceptor)interceptor);
        mipe.afterPropertiesSet();
        MethodInvocationPrivilegeEvaluatorTests.assertTrue((boolean)mipe.isAllowed(mi, (Authentication)token));
    }

    public void testDeclinesAccessUsingCreate() throws Exception {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_NOT_HELD")});
        Object object = this.lookupTargetObject();
        MethodInvocation mi = MethodInvocationUtils.create((Object)object, (String)"makeLowerCase", (Object[])new Object[]{"foobar"});
        MethodSecurityInterceptor interceptor = this.makeSecurityInterceptor();
        MethodInvocationPrivilegeEvaluator mipe = new MethodInvocationPrivilegeEvaluator();
        mipe.setSecurityInterceptor((AbstractSecurityInterceptor)interceptor);
        mipe.afterPropertiesSet();
        MethodInvocationPrivilegeEvaluatorTests.assertFalse((boolean)mipe.isAllowed(mi, (Authentication)token));
    }

    public void testDeclinesAccessUsingCreateFromClass() throws Exception {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_NOT_HELD")});
        MethodInvocation mi = MethodInvocationUtils.createFromClass((Class)(class$org$acegisecurity$ITargetObject == null ? (class$org$acegisecurity$ITargetObject = MethodInvocationPrivilegeEvaluatorTests.class$("org.acegisecurity.ITargetObject")) : class$org$acegisecurity$ITargetObject), (String)"makeLowerCase", (Class[])new Class[]{class$java$lang$String == null ? (class$java$lang$String = MethodInvocationPrivilegeEvaluatorTests.class$("java.lang.String")) : class$java$lang$String}, (Object[])new Object[]{"helloWorld"});
        MethodSecurityInterceptor interceptor = this.makeSecurityInterceptor();
        MethodInvocationPrivilegeEvaluator mipe = new MethodInvocationPrivilegeEvaluator();
        mipe.setSecurityInterceptor((AbstractSecurityInterceptor)interceptor);
        mipe.afterPropertiesSet();
        MethodInvocationPrivilegeEvaluatorTests.assertFalse((boolean)mipe.isAllowed(mi, (Authentication)token));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

