/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.intercept.method.aopalliance;

import java.lang.reflect.Method;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.intercept.method.MethodDefinitionMap;
import org.acegisecurity.intercept.method.MethodDefinitionSource;
import org.acegisecurity.intercept.method.MethodDefinitionSourceEditor;
import org.acegisecurity.intercept.method.aopalliance.MethodDefinitionSourceAdvisor;
import org.acegisecurity.intercept.method.aopalliance.MethodSecurityInterceptor;
import org.springframework.aop.framework.AopConfigException;

public class MethodDefinitionSourceAdvisorTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$intercept$method$aopalliance$MethodDefinitionSourceAdvisorTests;
    static /* synthetic */ Class class$org$acegisecurity$TargetObject;
    static /* synthetic */ Class class$java$lang$String;

    public MethodDefinitionSourceAdvisorTests() {
    }

    public MethodDefinitionSourceAdvisorTests(String arg0) {
        super(arg0);
    }

    private MethodSecurityInterceptor getInterceptor() {
        MethodDefinitionSourceEditor editor = new MethodDefinitionSourceEditor();
        editor.setAsText("org.acegisecurity.TargetObject.countLength=ROLE_NOT_USED");
        MethodDefinitionMap map = (MethodDefinitionMap)editor.getValue();
        MethodSecurityInterceptor msi = new MethodSecurityInterceptor();
        msi.setObjectDefinitionSource((MethodDefinitionSource)map);
        return msi;
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$intercept$method$aopalliance$MethodDefinitionSourceAdvisorTests == null ? (class$org$acegisecurity$intercept$method$aopalliance$MethodDefinitionSourceAdvisorTests = MethodDefinitionSourceAdvisorTests.class$("org.acegisecurity.intercept.method.aopalliance.MethodDefinitionSourceAdvisorTests")) : class$org$acegisecurity$intercept$method$aopalliance$MethodDefinitionSourceAdvisorTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testAdvisorReturnsFalseWhenMethodInvocationNotDefined() throws Exception {
        Class clazz = class$org$acegisecurity$TargetObject == null ? (class$org$acegisecurity$TargetObject = MethodDefinitionSourceAdvisorTests.class$("org.acegisecurity.TargetObject")) : class$org$acegisecurity$TargetObject;
        Method method = clazz.getMethod("makeLowerCase", class$java$lang$String == null ? (class$java$lang$String = MethodDefinitionSourceAdvisorTests.class$("java.lang.String")) : class$java$lang$String);
        MethodDefinitionSourceAdvisor advisor = new MethodDefinitionSourceAdvisor(this.getInterceptor());
        MethodDefinitionSourceAdvisorTests.assertFalse((boolean)advisor.matches(method, clazz));
    }

    public void testAdvisorReturnsTrueWhenMethodInvocationIsDefined() throws Exception {
        Class clazz = class$org$acegisecurity$TargetObject == null ? (class$org$acegisecurity$TargetObject = MethodDefinitionSourceAdvisorTests.class$("org.acegisecurity.TargetObject")) : class$org$acegisecurity$TargetObject;
        Method method = clazz.getMethod("countLength", class$java$lang$String == null ? (class$java$lang$String = MethodDefinitionSourceAdvisorTests.class$("java.lang.String")) : class$java$lang$String);
        MethodDefinitionSourceAdvisor advisor = new MethodDefinitionSourceAdvisor(this.getInterceptor());
        MethodDefinitionSourceAdvisorTests.assertTrue((boolean)advisor.matches(method, clazz));
    }

    public void testDetectsImproperlyConfiguredAdvice() {
        MethodSecurityInterceptor msi = new MethodSecurityInterceptor();
        try {
            new MethodDefinitionSourceAdvisor(msi);
            MethodDefinitionSourceAdvisorTests.fail((String)"Should have detected null ObjectDefinitionSource and thrown AopConfigException");
        }
        catch (AopConfigException expected) {
            MethodDefinitionSourceAdvisorTests.assertTrue((boolean)true);
        }
    }

    public void testUnsupportedOperations() throws Throwable {
        Class clazz = class$org$acegisecurity$TargetObject == null ? (class$org$acegisecurity$TargetObject = MethodDefinitionSourceAdvisorTests.class$("org.acegisecurity.TargetObject")) : class$org$acegisecurity$TargetObject;
        Method method = clazz.getMethod("countLength", class$java$lang$String == null ? (class$java$lang$String = MethodDefinitionSourceAdvisorTests.class$("java.lang.String")) : class$java$lang$String);
        MethodDefinitionSourceAdvisor methodDefinitionSourceAdvisor = new MethodDefinitionSourceAdvisor(this.getInterceptor());
        methodDefinitionSourceAdvisor.getClass();
        MethodDefinitionSourceAdvisor.InternalMethodInvocation imi = new MethodDefinitionSourceAdvisor.InternalMethodInvocation(methodDefinitionSourceAdvisor, method);
        try {
            imi.getArguments();
            MethodDefinitionSourceAdvisorTests.fail((String)"Should have thrown UnsupportedOperationException");
        }
        catch (UnsupportedOperationException expected) {
            MethodDefinitionSourceAdvisorTests.assertTrue((boolean)true);
        }
        try {
            imi.getStaticPart();
            MethodDefinitionSourceAdvisorTests.fail((String)"Should have thrown UnsupportedOperationException");
        }
        catch (UnsupportedOperationException expected) {
            MethodDefinitionSourceAdvisorTests.assertTrue((boolean)true);
        }
        try {
            imi.getThis();
            MethodDefinitionSourceAdvisorTests.fail((String)"Should have thrown UnsupportedOperationException");
        }
        catch (UnsupportedOperationException expected) {
            MethodDefinitionSourceAdvisorTests.assertTrue((boolean)true);
        }
        try {
            imi.proceed();
            MethodDefinitionSourceAdvisorTests.fail((String)"Should have thrown UnsupportedOperationException");
        }
        catch (UnsupportedOperationException expected) {
            MethodDefinitionSourceAdvisorTests.assertTrue((boolean)true);
        }
        try {
            new MethodDefinitionSourceAdvisor.InternalMethodInvocation(new MethodDefinitionSourceAdvisor(this.getInterceptor()));
            MethodDefinitionSourceAdvisorTests.fail((String)"Should have thrown UnsupportedOperationException");
        }
        catch (UnsupportedOperationException expected) {
            MethodDefinitionSourceAdvisorTests.assertTrue((boolean)true);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

