/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.intercept.method.aspectj;

import java.lang.reflect.Method;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.AccessDecisionManager;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.MockAccessDecisionManager;
import org.acegisecurity.MockApplicationContext;
import org.acegisecurity.MockAuthenticationManager;
import org.acegisecurity.MockJoinPoint;
import org.acegisecurity.MockRunAsManager;
import org.acegisecurity.RunAsManager;
import org.acegisecurity.TargetObject;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.intercept.method.MethodDefinitionMap;
import org.acegisecurity.intercept.method.MethodDefinitionSource;
import org.acegisecurity.intercept.method.MethodDefinitionSourceEditor;
import org.acegisecurity.intercept.method.aspectj.AspectJCallback;
import org.acegisecurity.intercept.method.aspectj.AspectJSecurityInterceptor;
import org.acegisecurity.providers.TestingAuthenticationToken;
import org.aspectj.lang.JoinPoint;
import org.springframework.context.ApplicationEventPublisher;

public class AspectJSecurityInterceptorTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$intercept$method$aspectj$AspectJSecurityInterceptorTests;
    static /* synthetic */ Class class$org$acegisecurity$TargetObject;
    static /* synthetic */ Class class$java$lang$String;

    public AspectJSecurityInterceptorTests() {
    }

    public AspectJSecurityInterceptorTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$intercept$method$aspectj$AspectJSecurityInterceptorTests == null ? (class$org$acegisecurity$intercept$method$aspectj$AspectJSecurityInterceptorTests = AspectJSecurityInterceptorTests.class$("org.acegisecurity.intercept.method.aspectj.AspectJSecurityInterceptorTests")) : class$org$acegisecurity$intercept$method$aspectj$AspectJSecurityInterceptorTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testCallbackIsInvokedWhenPermissionGranted() throws Exception {
        AspectJSecurityInterceptor si = new AspectJSecurityInterceptor();
        si.setApplicationEventPublisher((ApplicationEventPublisher)MockApplicationContext.getContext());
        si.setAccessDecisionManager((AccessDecisionManager)new MockAccessDecisionManager());
        si.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        si.setRunAsManager((RunAsManager)new MockRunAsManager());
        MethodDefinitionSourceEditor editor = new MethodDefinitionSourceEditor();
        editor.setAsText("org.acegisecurity.TargetObject.countLength=MOCK_ONE,MOCK_TWO");
        MethodDefinitionMap map = (MethodDefinitionMap)editor.getValue();
        si.setObjectDefinitionSource((MethodDefinitionSource)map);
        AspectJSecurityInterceptorTests.assertEquals((Object)map, (Object)si.getObjectDefinitionSource());
        si.afterPropertiesSet();
        Class clazz = class$org$acegisecurity$TargetObject == null ? (class$org$acegisecurity$TargetObject = AspectJSecurityInterceptorTests.class$("org.acegisecurity.TargetObject")) : class$org$acegisecurity$TargetObject;
        Method method = clazz.getMethod("countLength", class$java$lang$String == null ? (class$java$lang$String = AspectJSecurityInterceptorTests.class$("java.lang.String")) : class$java$lang$String);
        MockJoinPoint joinPoint = new MockJoinPoint(new TargetObject(), method);
        MockAspectJCallback aspectJCallback = new MockAspectJCallback();
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)"marissa", (Object)"koala", new GrantedAuthority[]{new GrantedAuthorityImpl("MOCK_ONE")}));
        Object result = si.invoke((JoinPoint)joinPoint, (AspectJCallback)aspectJCallback);
        AspectJSecurityInterceptorTests.assertEquals((Object)"object proceeded", (Object)result);
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    public void testCallbackIsNotInvokedWhenPermissionDenied() throws Exception {
        AspectJSecurityInterceptor si = new AspectJSecurityInterceptor();
        si.setApplicationEventPublisher((ApplicationEventPublisher)MockApplicationContext.getContext());
        si.setAccessDecisionManager((AccessDecisionManager)new MockAccessDecisionManager());
        si.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        si.setRunAsManager((RunAsManager)new MockRunAsManager());
        MethodDefinitionSourceEditor editor = new MethodDefinitionSourceEditor();
        editor.setAsText("org.acegisecurity.TargetObject.countLength=MOCK_ONE,MOCK_TWO");
        MethodDefinitionMap map = (MethodDefinitionMap)editor.getValue();
        si.setObjectDefinitionSource((MethodDefinitionSource)map);
        si.afterPropertiesSet();
        Class clazz = class$org$acegisecurity$TargetObject == null ? (class$org$acegisecurity$TargetObject = AspectJSecurityInterceptorTests.class$("org.acegisecurity.TargetObject")) : class$org$acegisecurity$TargetObject;
        Method method = clazz.getMethod("countLength", class$java$lang$String == null ? (class$java$lang$String = AspectJSecurityInterceptorTests.class$("java.lang.String")) : class$java$lang$String);
        MockJoinPoint joinPoint = new MockJoinPoint(new TargetObject(), method);
        MockAspectJCallback aspectJCallback = new MockAspectJCallback();
        aspectJCallback.setThrowExceptionIfInvoked(true);
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)"marissa", (Object)"koala", new GrantedAuthority[0]));
        try {
            si.invoke((JoinPoint)joinPoint, (AspectJCallback)aspectJCallback);
            AspectJSecurityInterceptorTests.fail((String)"Should have thrown AccessDeniedException");
        }
        catch (AccessDeniedException expected) {
            AspectJSecurityInterceptorTests.assertTrue((boolean)true);
        }
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MockAspectJCallback
    implements AspectJCallback {
        private boolean throwExceptionIfInvoked = false;

        private MockAspectJCallback() {
        }

        public Object proceedWithObject() {
            if (this.throwExceptionIfInvoked) {
                throw new IllegalStateException("AspectJCallback proceeded");
            }
            return "object proceeded";
        }

        public void setThrowExceptionIfInvoked(boolean throwExceptionIfInvoked) {
            this.throwExceptionIfInvoked = throwExceptionIfInvoked;
        }
    }
}

