/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.intercept.web;

import java.util.Iterator;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.MockFilterChain;
import org.acegisecurity.SecurityConfig;
import org.acegisecurity.intercept.web.FilterInvocation;
import org.acegisecurity.intercept.web.FilterInvocationDefinitionMap;
import org.acegisecurity.intercept.web.FilterInvocationDefinitionSourceEditor;
import org.acegisecurity.intercept.web.PathBasedFilterInvocationDefinitionMap;
import org.acegisecurity.intercept.web.RegExpBasedFilterInvocationDefinitionMap;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class FilterInvocationDefinitionSourceEditorTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$intercept$web$FilterInvocationDefinitionSourceEditorTests;
    static /* synthetic */ Class class$org$acegisecurity$intercept$web$RegExpBasedFilterInvocationDefinitionMap$EntryHolder;

    public FilterInvocationDefinitionSourceEditorTests() {
    }

    public FilterInvocationDefinitionSourceEditorTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$intercept$web$FilterInvocationDefinitionSourceEditorTests == null ? (class$org$acegisecurity$intercept$web$FilterInvocationDefinitionSourceEditorTests = FilterInvocationDefinitionSourceEditorTests.class$("org.acegisecurity.intercept.web.FilterInvocationDefinitionSourceEditorTests")) : class$org$acegisecurity$intercept$web$FilterInvocationDefinitionSourceEditorTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testConvertUrlToLowercaseDefaultSettingUnchangedByEditor() {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        editor.setAsText("\\A/secure/super.*\\Z=ROLE_WE_DONT_HAVE\r\n\\A/secure/.*\\Z=ROLE_SUPERVISOR,ROLE_TELLER");
        RegExpBasedFilterInvocationDefinitionMap map = (RegExpBasedFilterInvocationDefinitionMap)editor.getValue();
        FilterInvocationDefinitionSourceEditorTests.assertFalse((boolean)map.isConvertUrlToLowercaseBeforeComparison());
    }

    public void testConvertUrlToLowercaseDetectsUppercaseEntries() {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        try {
            editor.setAsText("CONVERT_URL_TO_LOWERCASE_BEFORE_COMPARISON\r\nPATTERN_TYPE_APACHE_ANT\r\n\\/secUre/super/**=ROLE_WE_DONT_HAVE");
            FilterInvocationDefinitionSourceEditorTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            FilterInvocationDefinitionSourceEditorTests.assertTrue((expected.getMessage().lastIndexOf("you have specified an uppercase character in line") != -1 ? 1 : 0) != 0);
        }
    }

    public void testConvertUrlToLowercaseSettingApplied() {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        editor.setAsText("CONVERT_URL_TO_LOWERCASE_BEFORE_COMPARISON\r\n\\A/secure/super.*\\Z=ROLE_WE_DONT_HAVE\r\n\\A/secure/.*\\Z=ROLE_SUPERVISOR,ROLE_TELLER");
        RegExpBasedFilterInvocationDefinitionMap map = (RegExpBasedFilterInvocationDefinitionMap)editor.getValue();
        FilterInvocationDefinitionSourceEditorTests.assertTrue((boolean)map.isConvertUrlToLowercaseBeforeComparison());
    }

    public void testDefaultIsRegularExpression() {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        editor.setAsText("\\A/secure/super.*\\Z=ROLE_WE_DONT_HAVE\r\n\\A/secure/.*\\Z=ROLE_SUPERVISOR,ROLE_TELLER");
        FilterInvocationDefinitionMap map = (FilterInvocationDefinitionMap)editor.getValue();
        FilterInvocationDefinitionSourceEditorTests.assertTrue((boolean)(map instanceof RegExpBasedFilterInvocationDefinitionMap));
    }

    public void testDetectsDuplicateDirectivesOnSameLineSituation1() {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        try {
            editor.setAsText("CONVERT_URL_TO_LOWERCASE_BEFORE_COMPARISON PATTERN_TYPE_APACHE_ANT\r\n\\/secure/super/**=ROLE_WE_DONT_HAVE");
            FilterInvocationDefinitionSourceEditorTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            FilterInvocationDefinitionSourceEditorTests.assertTrue((expected.getMessage().lastIndexOf("Line appears to be malformed") != -1 ? 1 : 0) != 0);
        }
    }

    public void testDetectsDuplicateDirectivesOnSameLineSituation2() {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        try {
            editor.setAsText("CONVERT_URL_TO_LOWERCASE_BEFORE_COMPARISON\r\nPATTERN_TYPE_APACHE_ANT /secure/super/**=ROLE_WE_DONT_HAVE");
            FilterInvocationDefinitionSourceEditorTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            FilterInvocationDefinitionSourceEditorTests.assertTrue((expected.getMessage().lastIndexOf("Line appears to be malformed") != -1 ? 1 : 0) != 0);
        }
    }

    public void testDetectsDuplicateDirectivesOnSameLineSituation3() {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        try {
            editor.setAsText("PATTERN_TYPE_APACHE_ANT\r\nCONVERT_URL_TO_LOWERCASE_BEFORE_COMPARISON /secure/super/**=ROLE_WE_DONT_HAVE");
            FilterInvocationDefinitionSourceEditorTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            FilterInvocationDefinitionSourceEditorTests.assertTrue((expected.getMessage().lastIndexOf("Line appears to be malformed") != -1 ? 1 : 0) != 0);
        }
    }

    public void testEmptyStringReturnsEmptyMap() {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        editor.setAsText("");
        RegExpBasedFilterInvocationDefinitionMap map = (RegExpBasedFilterInvocationDefinitionMap)editor.getValue();
        FilterInvocationDefinitionSourceEditorTests.assertEquals((int)0, (int)map.getMapSize());
    }

    public void testInvalidRegularExpressionsDetected() throws Exception {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        try {
            editor.setAsText("*=SOME_ROLE");
        }
        catch (IllegalArgumentException expected) {
            FilterInvocationDefinitionSourceEditorTests.assertEquals((String)"Malformed regular expression: *", (String)expected.getMessage());
        }
    }

    public void testIterator() {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        editor.setAsText("\\A/secure/super.*\\Z=ROLE_WE_DONT_HAVE\r\n\\A/secure/.*\\Z=ROLE_SUPERVISOR,ROLE_TELLER");
        RegExpBasedFilterInvocationDefinitionMap map = (RegExpBasedFilterInvocationDefinitionMap)editor.getValue();
        Iterator iter = map.getConfigAttributeDefinitions();
        int counter = 0;
        while (iter.hasNext()) {
            iter.next();
            ++counter;
        }
        FilterInvocationDefinitionSourceEditorTests.assertEquals((int)2, (int)counter);
    }

    public void testMapReturnsNullWhenNoMatchFound() throws Exception {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        editor.setAsText("\\A/secure/super.*\\Z=ROLE_WE_DONT_HAVE,ANOTHER_ROLE");
        RegExpBasedFilterInvocationDefinitionMap map = (RegExpBasedFilterInvocationDefinitionMap)editor.getValue();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest(null, null);
        httpRequest.setServletPath("/totally/different/path/index.html");
        ConfigAttributeDefinition returned = map.getAttributes((Object)new FilterInvocation((ServletRequest)httpRequest, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain()));
        FilterInvocationDefinitionSourceEditorTests.assertEquals(null, (Object)returned);
    }

    public void testMultiUrlParsing() {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        editor.setAsText("\\A/secure/super.*\\Z=ROLE_WE_DONT_HAVE\r\n\\A/secure/.*\\Z=ROLE_SUPERVISOR,ROLE_TELLER");
        RegExpBasedFilterInvocationDefinitionMap map = (RegExpBasedFilterInvocationDefinitionMap)editor.getValue();
        FilterInvocationDefinitionSourceEditorTests.assertEquals((int)2, (int)map.getMapSize());
    }

    public void testNoArgConstructorDoesntExist() {
        Class clazz = class$org$acegisecurity$intercept$web$RegExpBasedFilterInvocationDefinitionMap$EntryHolder == null ? (class$org$acegisecurity$intercept$web$RegExpBasedFilterInvocationDefinitionMap$EntryHolder = FilterInvocationDefinitionSourceEditorTests.class$("org.acegisecurity.intercept.web.RegExpBasedFilterInvocationDefinitionMap$EntryHolder")) : class$org$acegisecurity$intercept$web$RegExpBasedFilterInvocationDefinitionMap$EntryHolder;
        try {
            clazz.getDeclaredConstructor(null);
            FilterInvocationDefinitionSourceEditorTests.fail((String)"Should have thrown NoSuchMethodException");
        }
        catch (NoSuchMethodException expected) {
            FilterInvocationDefinitionSourceEditorTests.assertTrue((boolean)true);
        }
    }

    public void testNullReturnsEmptyMap() {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        editor.setAsText(null);
        RegExpBasedFilterInvocationDefinitionMap map = (RegExpBasedFilterInvocationDefinitionMap)editor.getValue();
        FilterInvocationDefinitionSourceEditorTests.assertEquals((int)0, (int)map.getMapSize());
    }

    public void testOrderOfEntriesIsPreservedOrderA() {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        editor.setAsText("\\A/secure/super.*\\Z=ROLE_WE_DONT_HAVE,ANOTHER_ROLE\r\n\\A/secure/.*\\Z=ROLE_SUPERVISOR,ROLE_TELLER");
        RegExpBasedFilterInvocationDefinitionMap map = (RegExpBasedFilterInvocationDefinitionMap)editor.getValue();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest(null, null);
        httpRequest.setServletPath("/secure/super/very_secret.html");
        ConfigAttributeDefinition returned = map.getAttributes((Object)new FilterInvocation((ServletRequest)httpRequest, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain()));
        ConfigAttributeDefinition expected = new ConfigAttributeDefinition();
        expected.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_WE_DONT_HAVE"));
        expected.addConfigAttribute((ConfigAttribute)new SecurityConfig("ANOTHER_ROLE"));
        FilterInvocationDefinitionSourceEditorTests.assertEquals((Object)expected, (Object)returned);
    }

    public void testOrderOfEntriesIsPreservedOrderB() {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        editor.setAsText("\\A/secure/.*\\Z=ROLE_SUPERVISOR,ROLE_TELLER\r\n\\A/secure/super.*\\Z=ROLE_WE_DONT_HAVE,ANOTHER_ROLE");
        RegExpBasedFilterInvocationDefinitionMap map = (RegExpBasedFilterInvocationDefinitionMap)editor.getValue();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest(null, null);
        httpRequest.setServletPath("/secure/super/very_secret.html");
        ConfigAttributeDefinition returned = map.getAttributes((Object)new FilterInvocation((ServletRequest)httpRequest, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain()));
        ConfigAttributeDefinition expected = new ConfigAttributeDefinition();
        expected.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_SUPERVISOR"));
        expected.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_TELLER"));
        FilterInvocationDefinitionSourceEditorTests.assertEquals((Object)expected, (Object)returned);
    }

    public void testSingleUrlParsingWithRegularExpressions() throws Exception {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        editor.setAsText("\\A/secure/super.*\\Z=ROLE_WE_DONT_HAVE,ANOTHER_ROLE");
        RegExpBasedFilterInvocationDefinitionMap map = (RegExpBasedFilterInvocationDefinitionMap)editor.getValue();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest(null, null);
        httpRequest.setServletPath("/secure/super/very_secret.html");
        ConfigAttributeDefinition returned = map.getAttributes((Object)new FilterInvocation((ServletRequest)httpRequest, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain()));
        ConfigAttributeDefinition expected = new ConfigAttributeDefinition();
        expected.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_WE_DONT_HAVE"));
        expected.addConfigAttribute((ConfigAttribute)new SecurityConfig("ANOTHER_ROLE"));
        FilterInvocationDefinitionSourceEditorTests.assertEquals((Object)expected, (Object)returned);
    }

    public void testSingleUrlParsingWithAntPaths() throws Exception {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        editor.setAsText("PATTERN_TYPE_APACHE_ANT\r\n/secure/super/**=ROLE_WE_DONT_HAVE,ANOTHER_ROLE");
        PathBasedFilterInvocationDefinitionMap map = (PathBasedFilterInvocationDefinitionMap)editor.getValue();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest(null, null);
        httpRequest.setServletPath("/secure/super/very_secret.html");
        ConfigAttributeDefinition returned = map.getAttributes((Object)new FilterInvocation((ServletRequest)httpRequest, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain()));
        ConfigAttributeDefinition expected = new ConfigAttributeDefinition();
        expected.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_WE_DONT_HAVE"));
        expected.addConfigAttribute((ConfigAttribute)new SecurityConfig("ANOTHER_ROLE"));
        FilterInvocationDefinitionSourceEditorTests.assertEquals((Object)expected, (Object)returned);
    }

    public void testWhitespaceAndCommentsAndLinesWithoutEqualsSignsAreIgnored() {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        editor.setAsText("         \\A/secure/super.*\\Z=ROLE_WE_DONT_HAVE,ANOTHER_ROLE      \r\n   \r\n     \r\n   // comment line  \r\n   \\A/testing.*\\Z=ROLE_TEST   \r\n");
        RegExpBasedFilterInvocationDefinitionMap map = (RegExpBasedFilterInvocationDefinitionMap)editor.getValue();
        FilterInvocationDefinitionSourceEditorTests.assertEquals((int)2, (int)map.getMapSize());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

