/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.intercept.web;

import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.MockFilterChain;
import org.acegisecurity.SecurityConfig;
import org.acegisecurity.intercept.web.FilterInvocation;
import org.acegisecurity.intercept.web.RegExpBasedFilterInvocationDefinitionMap;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class RegExpBasedFilterDefinitionMapTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$intercept$web$RegExpBasedFilterDefinitionMapTests;

    public RegExpBasedFilterDefinitionMapTests() {
    }

    public RegExpBasedFilterDefinitionMapTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$intercept$web$RegExpBasedFilterDefinitionMapTests == null ? (class$org$acegisecurity$intercept$web$RegExpBasedFilterDefinitionMapTests = RegExpBasedFilterDefinitionMapTests.class$("org.acegisecurity.intercept.web.RegExpBasedFilterDefinitionMapTests")) : class$org$acegisecurity$intercept$web$RegExpBasedFilterDefinitionMapTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testConvertUrlToLowercaseIsFalseByDefault() {
        RegExpBasedFilterInvocationDefinitionMap map = new RegExpBasedFilterInvocationDefinitionMap();
        RegExpBasedFilterDefinitionMapTests.assertFalse((boolean)map.isConvertUrlToLowercaseBeforeComparison());
    }

    public void testConvertUrlToLowercaseSetterRespected() {
        RegExpBasedFilterInvocationDefinitionMap map = new RegExpBasedFilterInvocationDefinitionMap();
        map.setConvertUrlToLowercaseBeforeComparison(true);
        RegExpBasedFilterDefinitionMapTests.assertTrue((boolean)map.isConvertUrlToLowercaseBeforeComparison());
    }

    public void testLookupNotRequiringExactMatchSuccessIfNotMatching() {
        RegExpBasedFilterInvocationDefinitionMap map = new RegExpBasedFilterInvocationDefinitionMap();
        map.setConvertUrlToLowercaseBeforeComparison(true);
        RegExpBasedFilterDefinitionMapTests.assertTrue((boolean)map.isConvertUrlToLowercaseBeforeComparison());
        ConfigAttributeDefinition def = new ConfigAttributeDefinition();
        def.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_ONE"));
        map.addSecureUrl("\\A/secure/super.*\\Z", def);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI(null);
        MockHttpServletRequest req = request;
        req.setServletPath("/SeCuRE/super/somefile.html");
        FilterInvocation fi = new FilterInvocation((ServletRequest)req, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain());
        ConfigAttributeDefinition response = map.lookupAttributes(fi.getRequestUrl());
        RegExpBasedFilterDefinitionMapTests.assertEquals((Object)def, (Object)response);
    }

    public void testLookupRequiringExactMatchFailsIfNotMatching() {
        RegExpBasedFilterInvocationDefinitionMap map = new RegExpBasedFilterInvocationDefinitionMap();
        RegExpBasedFilterDefinitionMapTests.assertFalse((boolean)map.isConvertUrlToLowercaseBeforeComparison());
        ConfigAttributeDefinition def = new ConfigAttributeDefinition();
        def.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_ONE"));
        map.addSecureUrl("\\A/secure/super.*\\Z", def);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI(null);
        MockHttpServletRequest req = request;
        req.setServletPath("/SeCuRE/super/somefile.html");
        FilterInvocation fi = new FilterInvocation((ServletRequest)req, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain());
        ConfigAttributeDefinition response = map.lookupAttributes(fi.getRequestUrl());
        RegExpBasedFilterDefinitionMapTests.assertEquals(null, (Object)response);
    }

    public void testLookupRequiringExactMatchIsSuccessful() {
        RegExpBasedFilterInvocationDefinitionMap map = new RegExpBasedFilterInvocationDefinitionMap();
        RegExpBasedFilterDefinitionMapTests.assertFalse((boolean)map.isConvertUrlToLowercaseBeforeComparison());
        ConfigAttributeDefinition def = new ConfigAttributeDefinition();
        def.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_ONE"));
        map.addSecureUrl("\\A/secure/super.*\\Z", def);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI(null);
        MockHttpServletRequest req = request;
        req.setServletPath("/secure/super/somefile.html");
        FilterInvocation fi = new FilterInvocation((ServletRequest)req, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain());
        ConfigAttributeDefinition response = map.lookupAttributes(fi.getRequestUrl());
        RegExpBasedFilterDefinitionMapTests.assertEquals((Object)def, (Object)response);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

