/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.intercept.web;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.intercept.AbstractSecurityInterceptor;
import org.acegisecurity.intercept.web.FilterInvocation;
import org.acegisecurity.intercept.web.FilterSecurityInterceptor;
import org.acegisecurity.intercept.web.WebInvocationPrivilegeEvaluator;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.util.FilterInvocationUtils;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class WebInvocationPrivilegeEvaluatorTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$intercept$web$WebInvocationPrivilegeEvaluatorTests;

    public WebInvocationPrivilegeEvaluatorTests() {
    }

    public WebInvocationPrivilegeEvaluatorTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$intercept$web$WebInvocationPrivilegeEvaluatorTests == null ? (class$org$acegisecurity$intercept$web$WebInvocationPrivilegeEvaluatorTests = WebInvocationPrivilegeEvaluatorTests.class$("org.acegisecurity.intercept.web.WebInvocationPrivilegeEvaluatorTests")) : class$org$acegisecurity$intercept$web$WebInvocationPrivilegeEvaluatorTests));
    }

    private FilterSecurityInterceptor makeFilterSecurityInterceptor() {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("org/acegisecurity/intercept/web/applicationContext.xml");
        return (FilterSecurityInterceptor)context.getBean("securityInterceptor");
    }

    public void testAllowsAccess1() throws Exception {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("MOCK_INDEX")});
        FilterInvocation fi = FilterInvocationUtils.create((String)"/foo/index.jsp");
        FilterSecurityInterceptor interceptor = this.makeFilterSecurityInterceptor();
        WebInvocationPrivilegeEvaluator wipe = new WebInvocationPrivilegeEvaluator();
        wipe.setSecurityInterceptor((AbstractSecurityInterceptor)interceptor);
        wipe.afterPropertiesSet();
        WebInvocationPrivilegeEvaluatorTests.assertTrue((boolean)wipe.isAllowed(fi, (Authentication)token));
    }

    public void testAllowsAccess2() throws Exception {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("MOCK_USER")});
        FilterInvocation fi = FilterInvocationUtils.create((String)"/anything.jsp");
        FilterSecurityInterceptor interceptor = this.makeFilterSecurityInterceptor();
        WebInvocationPrivilegeEvaluator wipe = new WebInvocationPrivilegeEvaluator();
        wipe.setSecurityInterceptor((AbstractSecurityInterceptor)interceptor);
        wipe.afterPropertiesSet();
        WebInvocationPrivilegeEvaluatorTests.assertTrue((boolean)wipe.isAllowed(fi, (Authentication)token));
    }

    public void testDeniesAccess1() throws Exception {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("MOCK_NOTHING_USEFUL")});
        FilterInvocation fi = FilterInvocationUtils.create((String)"/anything.jsp");
        FilterSecurityInterceptor interceptor = this.makeFilterSecurityInterceptor();
        WebInvocationPrivilegeEvaluator wipe = new WebInvocationPrivilegeEvaluator();
        wipe.setSecurityInterceptor((AbstractSecurityInterceptor)interceptor);
        wipe.afterPropertiesSet();
        WebInvocationPrivilegeEvaluatorTests.assertFalse((boolean)wipe.isAllowed(fi, (Authentication)token));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

